/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api;

import com.clickhouse.client.api.ClickHouseException;

public class ServerException
extends ClickHouseException {
    public static final int CODE_UNKNOWN = 0;
    public static final int TABLE_NOT_FOUND = 60;
    private final int code;
    private final int transportProtocolCode;

    public ServerException(int code, String message) {
        this(code, message, 500);
    }

    public ServerException(int code, String message, int transportProtocolCode) {
        super(message);
        this.code = code;
        this.transportProtocolCode = transportProtocolCode;
        this.isRetryable = this.discoverIsRetryable(code, message, transportProtocolCode);
    }

    public int getCode() {
        return this.code;
    }

    public int getTransportProtocolCode() {
        return this.transportProtocolCode;
    }

    @Override
    public boolean isRetryable() {
        return this.isRetryable;
    }

    private boolean discoverIsRetryable(int code, String message, int transportProtocolCode) {
        switch (code) {
            case 3: 
            case 107: 
            case 159: 
            case 164: 
            case 202: 
            case 203: 
            case 209: 
            case 210: 
            case 241: 
            case 242: 
            case 252: 
            case 285: 
            case 319: 
            case 425: 
            case 999: {
                return true;
            }
        }
        return false;
    }
}

