/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import java.util.Map;
import java.util.function.Consumer;

public class MapUtils {
    public static void applyLong(Map<String, String> map, String key, Consumer<Long> consumer) {
        String val = map.get(key);
        if (val != null) {
            try {
                consumer.accept(Long.valueOf(val));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid value for key " + key + ": " + val, e);
            }
        }
    }

    public static void applyInt(Map<String, String> map, String key, Consumer<Integer> consumer) {
        String val = map.get(key);
        if (val != null) {
            try {
                consumer.accept(Integer.valueOf(val));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid value for key " + key + ": " + val, e);
            }
        }
    }

    public static int getInt(Map<String, String> map, String key) {
        String val = map.get(key);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid value for key " + key + ": " + val, e);
            }
        }
        return 0;
    }

    public static long getLong(Map<String, String> map, String key) {
        String val = map.get(key);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid value for key " + key + ": " + val, e);
            }
        }
        return 0L;
    }

    public static boolean getFlag(Map<String, String> map, String key) {
        String val = map.get(key);
        if (val == null) {
            throw new NullPointerException("Missing value for the key '" + key + "'");
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Invalid non-boolean value for the key '" + key + "': '" + val + "'");
    }

    public static boolean getFlag(Map<String, ?> map, String key, boolean defaultValue) {
        Object val = map.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            String str = (String)val;
            if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("1")) {
                return true;
            }
            if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("0")) {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid non-boolean value for the key '" + key + "': '" + val + "'");
    }

    public static boolean getFlag(Map<String, ?> p1, Map<String, ?> p2, String key) {
        Object val = p1.get(key);
        if (val == null) {
            val = p2.get(key);
        }
        if (val == null) {
            throw new NullPointerException("Missing value for the key '" + key + "'");
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            String str = (String)val;
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalArgumentException("Invalid non-boolean value for the key '" + key + "': '" + val + "'");
        }
        throw new IllegalArgumentException("Invalid non-boolean value for the key '" + key + "': '" + val + "'");
    }
}

