/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.metadata;

import com.clickhouse.client.api.metadata.ColumnToMethodMatchingStrategy;
import java.util.regex.Pattern;

public class DefaultColumnToMethodMatchingStrategy
implements ColumnToMethodMatchingStrategy {
    public static final DefaultColumnToMethodMatchingStrategy INSTANCE = new DefaultColumnToMethodMatchingStrategy();
    private final Pattern getterPattern;
    private final Pattern setterPattern;
    private final Pattern methodReplacePattern;
    private final Pattern columnReplacePattern;

    public DefaultColumnToMethodMatchingStrategy() {
        this("^(get|is|has).+", "^(set).+", "^(get|set|is|has)|_", "[-_.]");
    }

    public DefaultColumnToMethodMatchingStrategy(String getterPatternRegEx, String setterPaternRegEx, String methodReplacePatternRegEx, String columnReplacePatternRegEx) {
        this.getterPattern = Pattern.compile(getterPatternRegEx);
        this.setterPattern = Pattern.compile(setterPaternRegEx);
        this.methodReplacePattern = Pattern.compile(methodReplacePatternRegEx);
        this.columnReplacePattern = Pattern.compile(columnReplacePatternRegEx);
    }

    @Override
    public String normalizeMethodName(String methodName) {
        return this.methodReplacePattern.matcher(methodName).replaceAll("").toLowerCase();
    }

    @Override
    public boolean isSetter(String methodName) {
        return this.setterPattern.matcher(methodName).matches();
    }

    @Override
    public boolean isGetter(String methodName) {
        return this.getterPattern.matcher(methodName).matches();
    }

    @Override
    public String normalizeColumnName(String columnName) {
        return this.columnReplacePattern.matcher(columnName).replaceAll("").toLowerCase();
    }
}

