/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.query;

import com.clickhouse.client.api.internal.ValidationUtils;
import com.clickhouse.data.ClickHouseFormat;
import java.util.HashMap;
import java.util.Map;

public class QuerySettings {
    public static final int MINIMAL_READ_BUFFER_SIZE = 8192;
    private Map<String, Object> rawSettings = new HashMap<String, Object>();

    public QuerySettings setOption(String option, Object value) {
        this.rawSettings.put(option, value);
        return this;
    }

    public Object getOption(String option) {
        return this.rawSettings.get(option);
    }

    public Map<String, Object> getAllSettings() {
        return this.rawSettings;
    }

    public QuerySettings setQueryId(String queryId) {
        this.rawSettings.put("query_id", queryId);
        return this;
    }

    public String getQueryId() {
        return (String)this.rawSettings.get("query_id");
    }

    public QuerySettings setReadBufferSize(Integer size) {
        ValidationUtils.checkNotNull(size, "read_buffer_size");
        ValidationUtils.checkRange(size, 8192, Integer.MAX_VALUE, "read_buffer_size");
        this.rawSettings.put("read_buffer_size", size);
        return this;
    }

    public Integer getReadBufferSize() {
        return (Integer)this.rawSettings.get("read_buffer_size");
    }

    public QuerySettings setFormat(ClickHouseFormat format) {
        this.rawSettings.put("format", format);
        return this;
    }

    public ClickHouseFormat getFormat() {
        return (ClickHouseFormat)this.rawSettings.get("format");
    }

    public QuerySettings setMaxExecutionTime(Integer maxExecutionTime) {
        this.rawSettings.put("max_execution_time", maxExecutionTime);
        return this;
    }

    public Integer getMaxExecutionTime() {
        return (Integer)this.rawSettings.get("max_execution_time");
    }

    public QuerySettings setDatabase(String database) {
        ValidationUtils.checkNonBlank(database, "database");
        this.rawSettings.put("database", database);
        return this;
    }

    public String getDatabase() {
        return (String)this.rawSettings.get("database");
    }
}

