/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.insert;

import com.clickhouse.client.api.internal.ValidationUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InsertSettings {
    private static final int DEFAULT_INPUT_STREAM_BATCH_SIZE = 8196;
    private String queryId;
    private int inputStreamCopyBufferSize;
    private String operationId;
    Map<String, Object> rawSettings = new HashMap<String, Object>();

    public InsertSettings() {
        this.setDefaults();
    }

    public InsertSettings(Map<String, Object> settings) {
        this.setDefaults();
        this.rawSettings.putAll(settings);
    }

    private void setDefaults() {
        this.setInputStreamCopyBufferSize(8196);
        this.queryId = null;
    }

    public Object getOption(String option) {
        return this.rawSettings.get(option);
    }

    public void setOption(String option, Object value) {
        this.rawSettings.put(option, value);
    }

    public Map<String, Object> getAllSettings() {
        return Collections.unmodifiableMap(this.rawSettings);
    }

    public InsertSettings setDeduplicationToken(String token) {
        this.rawSettings.put("insert_deduplication_token", token);
        return this;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public InsertSettings setQueryId(String queryId) {
        this.queryId = queryId;
        return this;
    }

    public int getInputStreamCopyBufferSize() {
        return this.inputStreamCopyBufferSize;
    }

    public InsertSettings setInputStreamCopyBufferSize(int size) {
        this.inputStreamCopyBufferSize = size;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public InsertSettings setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public InsertSettings setDatabase(String database) {
        ValidationUtils.checkNonBlank(database, "database");
        this.rawSettings.put("database", database);
        return this;
    }

    public String getDatabase() {
        return (String)this.rawSettings.get("database");
    }

    public InsertSettings compressClientRequest(boolean enabled) {
        this.rawSettings.put("decompress", enabled);
        return this;
    }

    public boolean isClientRequestEnabled() {
        return (Boolean)this.rawSettings.get("decompress");
    }
}

