/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.format.BinaryStreamUtils;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class BinaryStreamReader {
    private final ClickHouseInputStream chInputStream;
    private final Logger log;

    BinaryStreamReader(ClickHouseInputStream chInputStream, Logger log) {
        this.chInputStream = chInputStream;
        this.log = log == null ? NOPLogger.NOP_LOGGER : log;
    }

    public <T> T readValue(ClickHouseColumn column) throws IOException {
        return this.readValueImpl(column);
    }

    private <T> T readValueImpl(ClickHouseColumn column) throws IOException {
        if (column.isNullable() && BinaryStreamUtils.readNull((ClickHouseInputStream)this.chInputStream)) {
            return null;
        }
        try {
            switch (column.getDataType()) {
                case FixedString: {
                    return (T)BinaryStreamUtils.readFixedString((ClickHouseInputStream)this.chInputStream, (int)column.getEstimatedLength(), (Charset)StandardCharsets.UTF_8).trim();
                }
                case String: {
                    int len = this.chInputStream.readVarInt();
                    return (T)this.chInputStream.readUnicodeString(len);
                }
                case Int8: {
                    return (T)Byte.valueOf(BinaryStreamUtils.readInt8((ClickHouseInputStream)this.chInputStream));
                }
                case UInt8: {
                    return (T)Short.valueOf(BinaryStreamUtils.readUnsignedInt8((ClickHouseInputStream)this.chInputStream));
                }
                case Int16: {
                    return (T)Short.valueOf(BinaryStreamUtils.readInt16((ClickHouseInputStream)this.chInputStream));
                }
                case UInt16: {
                    return (T)Integer.valueOf(BinaryStreamUtils.readUnsignedInt16((ClickHouseInputStream)this.chInputStream));
                }
                case Int32: {
                    return (T)Integer.valueOf(BinaryStreamUtils.readInt32((ClickHouseInputStream)this.chInputStream));
                }
                case UInt32: {
                    return (T)Long.valueOf(BinaryStreamUtils.readUnsignedInt32((ClickHouseInputStream)this.chInputStream));
                }
                case Int64: {
                    return (T)Long.valueOf(BinaryStreamUtils.readInt64((ClickHouseInputStream)this.chInputStream));
                }
                case UInt64: {
                    return (T)BinaryStreamUtils.readUnsignedInt64((ClickHouseInputStream)this.chInputStream);
                }
                case Int128: {
                    return (T)BinaryStreamUtils.readInt128((ClickHouseInputStream)this.chInputStream);
                }
                case UInt128: {
                    return (T)BinaryStreamUtils.readUnsignedInt128((ClickHouseInputStream)this.chInputStream);
                }
                case Int256: {
                    return (T)BinaryStreamUtils.readInt256((ClickHouseInputStream)this.chInputStream);
                }
                case UInt256: {
                    return (T)BinaryStreamUtils.readUnsignedInt256((ClickHouseInputStream)this.chInputStream);
                }
                case Decimal: {
                    return (T)BinaryStreamUtils.readDecimal((ClickHouseInputStream)this.chInputStream, (int)column.getPrecision(), (int)column.getScale());
                }
                case Decimal32: {
                    return (T)BinaryStreamUtils.readDecimal32((ClickHouseInputStream)this.chInputStream, (int)column.getScale());
                }
                case Decimal64: {
                    return (T)BinaryStreamUtils.readDecimal64((ClickHouseInputStream)this.chInputStream, (int)column.getScale());
                }
                case Decimal128: {
                    return (T)BinaryStreamUtils.readDecimal128((ClickHouseInputStream)this.chInputStream, (int)column.getScale());
                }
                case Decimal256: {
                    return (T)BinaryStreamUtils.readDecimal256((ClickHouseInputStream)this.chInputStream, (int)column.getScale());
                }
                case Float32: {
                    return (T)Float.valueOf(BinaryStreamUtils.readFloat32((ClickHouseInputStream)this.chInputStream));
                }
                case Float64: {
                    return (T)Double.valueOf(BinaryStreamUtils.readFloat64((ClickHouseInputStream)this.chInputStream));
                }
                case Bool: {
                    return (T)Boolean.valueOf(BinaryStreamUtils.readBoolean((ClickHouseInputStream)this.chInputStream));
                }
                case Enum8: {
                    return (T)Byte.valueOf(BinaryStreamUtils.readEnum8((ClickHouseInputStream)this.chInputStream));
                }
                case Enum16: {
                    return (T)Short.valueOf(BinaryStreamUtils.readEnum16((ClickHouseInputStream)this.chInputStream));
                }
                case Date: {
                    return (T)BinaryStreamUtils.readDate((ClickHouseInputStream)this.chInputStream, (TimeZone)column.getTimeZone());
                }
                case Date32: {
                    return (T)BinaryStreamUtils.readDate32((ClickHouseInputStream)this.chInputStream, (TimeZone)column.getTimeZone());
                }
                case DateTime: {
                    return (T)BinaryStreamUtils.readDateTime((ClickHouseInputStream)this.chInputStream, (TimeZone)column.getTimeZone());
                }
                case DateTime32: {
                    return (T)BinaryStreamUtils.readDateTime32((ClickHouseInputStream)this.chInputStream, (TimeZone)column.getTimeZone());
                }
                case DateTime64: {
                    return (T)BinaryStreamUtils.readDateTime64((ClickHouseInputStream)this.chInputStream, (TimeZone)column.getTimeZone());
                }
                case IntervalYear: 
                case IntervalQuarter: 
                case IntervalMonth: 
                case IntervalWeek: 
                case IntervalDay: 
                case IntervalHour: 
                case IntervalMinute: 
                case IntervalSecond: 
                case IntervalMicrosecond: 
                case IntervalMillisecond: 
                case IntervalNanosecond: {
                    return (T)BinaryStreamUtils.readUnsignedInt64((ClickHouseInputStream)this.chInputStream);
                }
                case IPv4: {
                    return (T)BinaryStreamUtils.readInet4Address((ClickHouseInputStream)this.chInputStream);
                }
                case IPv6: {
                    return (T)BinaryStreamUtils.readInet6Address((ClickHouseInputStream)this.chInputStream);
                }
                case UUID: {
                    return (T)BinaryStreamUtils.readUuid((ClickHouseInputStream)this.chInputStream);
                }
                case Point: {
                    return (T)BinaryStreamUtils.readGeoPoint((ClickHouseInputStream)this.chInputStream);
                }
                case Polygon: {
                    return (T)BinaryStreamUtils.readGeoPolygon((ClickHouseInputStream)this.chInputStream);
                }
                case MultiPolygon: {
                    return (T)BinaryStreamUtils.readGeoMultiPolygon((ClickHouseInputStream)this.chInputStream);
                }
                case Ring: {
                    return (T)BinaryStreamUtils.readGeoRing((ClickHouseInputStream)this.chInputStream);
                }
                case Array: {
                    return (T)this.readArray(column);
                }
                case Map: {
                    return (T)this.readMap(column);
                }
                case Tuple: {
                    return (T)this.readTuple(column);
                }
                case Nothing: {
                    return null;
                }
            }
            throw new IllegalArgumentException("Unsupported data type: " + column.getDataType());
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            this.log.error("Failed to read value of type: {}", (Object)column.getDataType(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private ArrayValue readArray(ClickHouseColumn column) throws IOException {
        Class itemType = column.getArrayBaseColumn().getDataType().getWiderPrimitiveClass();
        int len = this.chInputStream.readVarInt();
        ArrayValue array = new ArrayValue(column.getArrayNestedLevel() > 1 ? ArrayValue.class : itemType, len);
        if (len == 0) {
            return array;
        }
        for (int i = 0; i < len; ++i) {
            array.set(i, this.readValueImpl((ClickHouseColumn)column.getNestedColumns().get(0)));
        }
        return array;
    }

    private Map<?, ?> readMap(ClickHouseColumn column) throws IOException {
        int len = this.chInputStream.readVarInt();
        if (len == 0) {
            return Collections.emptyMap();
        }
        ClickHouseColumn keyType = column.getKeyInfo();
        ClickHouseColumn valueType = column.getValueInfo();
        LinkedHashMap map = new LinkedHashMap(len);
        for (int i = 0; i < len; ++i) {
            Object key = this.readValueImpl(keyType);
            Object value = this.readValueImpl(valueType);
            map.put(key, value);
        }
        return map;
    }

    private Object[] readTuple(ClickHouseColumn column) throws IOException {
        int len = column.getNestedColumns().size();
        Object[] tuple = new Object[len];
        for (int i = 0; i < len; ++i) {
            tuple[i] = this.readValueImpl((ClickHouseColumn)column.getNestedColumns().get(i));
        }
        return tuple;
    }

    public static class ArrayValue {
        final int length;
        final Class<?> itemType;
        final Object array;

        ArrayValue(Class<?> itemType, int length) {
            this.itemType = itemType;
            this.length = length;
            try {
                this.array = itemType.isArray() ? Array.newInstance(ArrayValue.class, length) : Array.newInstance(itemType, length);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to create array of type: " + itemType, e);
            }
        }

        public int length() {
            return this.length;
        }

        public Object get(int index) {
            return Array.get(this.array, index);
        }

        public void set(int index, Object value) {
            try {
                Array.set(this.array, index, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to set value at index: " + index + " value " + value + " of class " + value.getClass().getName(), e);
            }
        }
    }
}

