/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseColumn;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

public class RowBinaryWithNamesAndTypesFormatReader
extends AbstractBinaryFormatReader {
    public RowBinaryWithNamesAndTypesFormatReader(InputStream inputStream, QuerySettings querySettings) {
        super(inputStream, querySettings, null);
        this.setSchema(this.readSchema());
    }

    private TableSchema readSchema() {
        try {
            int i;
            TableSchema headerSchema = new TableSchema();
            ArrayList<String> columns = new ArrayList<String>();
            int nCol = this.chInputStream.readVarInt();
            for (i = 0; i < nCol; ++i) {
                columns.add(this.chInputStream.readUnicodeString());
            }
            for (i = 0; i < nCol; ++i) {
                headerSchema.addColumn((String)columns.get(i), this.chInputStream.readUnicodeString());
            }
            return headerSchema;
        }
        catch (IOException e) {
            throw new ClientException("Failed to read header", e);
        }
    }

    @Override
    public void readRecord(Map<String, Object> record) throws IOException {
        for (ClickHouseColumn column : this.getSchema().getColumns()) {
            Object val = this.binaryStreamReader.readValue(column);
            if (val == null) continue;
            record.put(column.getColumnName(), val);
        }
    }

    @Override
    public boolean next() {
        if (this.hasNext) {
            try {
                this.readRecord(this.currentRecord);
                return true;
            }
            catch (EOFException e) {
                this.hasNext = false;
                return false;
            }
            catch (IOException e) {
                this.hasNext = false;
                throw new ClientException("Failed to read row", e);
            }
        }
        return false;
    }
}

