/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api;

import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.api.internal.StopWatch;
import java.util.HashMap;
import java.util.Map;

public class OperationStatistics {
    public static final ServerStatistics EMPTY_SERVER_STATS = new ServerStatistics(-1L, -1L, -1L, -1L, -1L, -1L, -1L);
    public ServerStatistics serverStatistics = EMPTY_SERVER_STATS;
    public ClientStatistics clientStatistics;

    public OperationStatistics(ClientStatistics clientStatistics) {
        this.clientStatistics = clientStatistics;
    }

    public void setClientStatistics(ClientStatistics clientStatistics) {
        this.clientStatistics = clientStatistics;
    }

    public ClientStatistics getClientStatistics() {
        return this.clientStatistics;
    }

    public ServerStatistics getServerStatistics() {
        return this.serverStatistics;
    }

    public void updateServerStats(ClickHouseResponseSummary summary) {
        if (summary == null || summary.equals(ClickHouseResponseSummary.EMPTY)) {
            this.serverStatistics = EMPTY_SERVER_STATS;
            return;
        }
        this.serverStatistics = new ServerStatistics(summary.getReadRows(), summary.getReadBytes(), summary.getTotalRowsToRead(), summary.getWrittenRows(), summary.getWrittenBytes(), summary.getResultRows(), summary.getElapsedTime());
    }

    public String toString() {
        return "OperationStatistics{\"serverStatistics\"=" + this.serverStatistics + ", \"clientStatistics\"=" + this.clientStatistics + '}';
    }

    public static class ServerStatistics {
        public final long numRowsRead;
        public final long numRowsWritten;
        public final long totalRowsToRead;
        public final long numBytesRead;
        public final long numBytesWritten;
        public final long resultRows;
        public final long elapsedTime;

        public ServerStatistics(long numRowsRead, long numBytesRead, long totalRowsToRead, long numRowsWritten, long numBytesWritten, long resultRows, long elapsedTime) {
            this.numRowsRead = numRowsRead;
            this.numBytesRead = numBytesRead;
            this.totalRowsToRead = totalRowsToRead;
            this.numRowsWritten = numRowsWritten;
            this.numBytesWritten = numBytesWritten;
            this.resultRows = resultRows;
            this.elapsedTime = elapsedTime;
        }

        public String toString() {
            return "ServerStatistics{\"numRowsRead\"=" + this.numRowsRead + ", \"numRowsWritten\"=" + this.numRowsWritten + ", \"totalRowsToRead\"=" + this.totalRowsToRead + ", \"numBytesRead\"=" + this.numBytesRead + ", \"numBytesWritten\"=" + this.numBytesWritten + ", \"resultRows\"=" + this.resultRows + ", \"elapsedTime\"=\"" + this.elapsedTime + "ns\"" + '}';
        }
    }

    public static class ClientStatistics {
        private final Map<String, StopWatch> spans = new HashMap<String, StopWatch>();

        public void start(String spanName) {
            this.spans.computeIfAbsent(spanName, k -> new StopWatch()).start();
        }

        public void stop(String spanName) {
            this.spans.computeIfAbsent(spanName, k -> new StopWatch()).stop();
        }

        public long getElapsedTime(String spanName) {
            StopWatch sw = this.spans.get(spanName);
            return sw == null ? -1L : sw.getElapsedTime();
        }

        public String toString() {
            return "ClientStatistics{\"spans\"=" + this.spans + '}';
        }
    }
}

