/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.query;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.data.ClickHouseInputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class QueryResponse
implements AutoCloseable {
    private final Future<ClickHouseResponse> responseRef;
    private long completeTimeout = TimeUnit.MINUTES.toMillis(1L);
    private ClickHouseClient client;

    public QueryResponse(ClickHouseClient client, Future<ClickHouseResponse> responseRef) {
        this.client = client;
        this.responseRef = responseRef;
    }

    public boolean isDone() {
        return this.responseRef.isDone();
    }

    public void ensureDone() {
        if (!this.isDone()) {
            try {
                this.responseRef.get(this.completeTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ClickHouseInputStream getInputStream() {
        this.ensureDone();
        try {
            return this.responseRef.get().getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

