/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.metadata;

import com.clickhouse.data.ClickHouseColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableSchema {
    private String tableName = "";
    private String databaseName = "";
    private List<ClickHouseColumn> columns;
    private Map<String, Map<String, Object>> metadata = new HashMap<String, Map<String, Object>>();

    public TableSchema() {
        this.columns = new ArrayList<ClickHouseColumn>();
    }

    public List<ClickHouseColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void addColumn(String name, String type) {
        this.columns.add(ClickHouseColumn.of((String)name, (String)type));
        this.metadata.computeIfAbsent(name, k -> new HashMap()).put("type", type);
    }
}

