/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JdbcTypeMapping {
    public static JdbcTypeMapping getDefaultMapping() {
        return InstanceHolder.defaultMapping;
    }

    public static JdbcTypeMapping getAnsiMapping() {
        return InstanceHolder.ansiMapping;
    }

    protected Class<?> getCustomJavaClass(ClickHouseColumn column, Map<String, Class<?>> typeMap) {
        if (typeMap != null && !typeMap.isEmpty()) {
            Class<?> javaClass = typeMap.get(column.getOriginalTypeName());
            if (javaClass == null) {
                javaClass = typeMap.get(column.getDataType().name());
            }
            return javaClass;
        }
        return null;
    }

    protected ClickHouseDataType getDataType(int sqlType) {
        ClickHouseDataType dataType;
        switch (sqlType) {
            case 16: {
                dataType = ClickHouseDataType.UInt8;
                break;
            }
            case -6: {
                dataType = ClickHouseDataType.Int8;
                break;
            }
            case 5: {
                dataType = ClickHouseDataType.Int16;
                break;
            }
            case 4: {
                dataType = ClickHouseDataType.Int32;
                break;
            }
            case -5: {
                dataType = ClickHouseDataType.Int64;
                break;
            }
            case 2: {
                dataType = ClickHouseDataType.Int256;
                break;
            }
            case 6: 
            case 7: {
                dataType = ClickHouseDataType.Float32;
                break;
            }
            case 8: {
                dataType = ClickHouseDataType.Float64;
                break;
            }
            case 3: {
                dataType = ClickHouseDataType.Decimal;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2000: 
            case 2004: 
            case 2005: 
            case 2009: 
            case 2011: {
                dataType = ClickHouseDataType.String;
                break;
            }
            case 91: {
                dataType = ClickHouseDataType.Date;
                break;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                dataType = ClickHouseDataType.DateTime;
                break;
            }
            case 2003: {
                dataType = ClickHouseDataType.Array;
                break;
            }
            case 2002: {
                dataType = ClickHouseDataType.Tuple;
                break;
            }
            default: {
                dataType = ClickHouseDataType.Nothing;
            }
        }
        return dataType;
    }

    protected int getSqlType(Class<?> javaClass) {
        int sqlType = javaClass == Boolean.TYPE || javaClass == Boolean.class ? 16 : (javaClass == Byte.TYPE || javaClass == Byte.class ? -6 : (javaClass == Short.TYPE || javaClass == Short.class ? 5 : (javaClass == Integer.TYPE || javaClass == Integer.class ? 4 : (javaClass == Long.TYPE || javaClass == Long.class ? -5 : (javaClass == Float.TYPE || javaClass == Float.class ? 6 : (javaClass == Double.TYPE || javaClass == Double.class ? 8 : (javaClass == BigInteger.class ? 2 : (javaClass == BigDecimal.class ? 3 : (javaClass == Date.class || javaClass == LocalDate.class ? 91 : (javaClass == Time.class || javaClass == LocalTime.class ? 92 : (javaClass == Timestamp.class || javaClass == LocalDateTime.class ? 93 : (javaClass == OffsetDateTime.class || javaClass == ZonedDateTime.class ? 2014 : (javaClass == String.class || javaClass == byte[].class || Enum.class.isAssignableFrom(javaClass) ? 12 : (javaClass.isArray() ? 2003 : (List.class.isAssignableFrom(javaClass) || Map.class.isAssignableFrom(javaClass) ? 2002 : 1111)))))))))))))));
        return sqlType;
    }

    public ClickHouseColumn toColumn(JDBCType jdbcType, int scaleOrLength) {
        Integer type = jdbcType.getVendorTypeNumber();
        return this.toColumn(type != null ? type : 1111, scaleOrLength);
    }

    public ClickHouseColumn toColumn(int sqlType, int scaleOrLength) {
        ClickHouseDataType dataType = this.getDataType(sqlType);
        ClickHouseColumn column = null;
        if (scaleOrLength > 0) {
            if (sqlType == -7 && scaleOrLength == 1) {
                dataType = ClickHouseDataType.UInt8;
            } else if (sqlType == 2 || sqlType == 3) {
                for (ClickHouseDataType t : new ClickHouseDataType[]{}) {
                    if (scaleOrLength > t.getMaxScale() / 2) continue;
                    column = ClickHouseColumn.of((String)"", (ClickHouseDataType)t, (boolean)false, (int)(t.getMaxPrecision() - t.getMaxScale()), (int)scaleOrLength);
                    break;
                }
            } else if (dataType == ClickHouseDataType.Date) {
                if (scaleOrLength > 2) {
                    dataType = ClickHouseDataType.Date32;
                }
            } else if (dataType == ClickHouseDataType.DateTime) {
                column = ClickHouseColumn.of((String)"", (ClickHouseDataType)ClickHouseDataType.DateTime64, (boolean)false, (int)0, (int)scaleOrLength);
            } else if (dataType == ClickHouseDataType.String) {
                column = ClickHouseColumn.of((String)"", (ClickHouseDataType)ClickHouseDataType.FixedString, (boolean)false, (int)scaleOrLength, (int)0);
            }
        }
        return column == null ? ClickHouseColumn.of((String)"", (ClickHouseDataType)dataType, (boolean)false, (boolean)false, (String[])new String[0]) : column;
    }

    public Class<?> toJavaClass(ClickHouseColumn column, Map<String, Class<?>> typeMap) {
        Class clazz = this.getCustomJavaClass(column, typeMap);
        if (clazz != null) {
            return clazz;
        }
        ClickHouseDataType type = column.getDataType();
        switch (type) {
            case DateTime: 
            case DateTime32: 
            case DateTime64: {
                clazz = column.getTimeZone() != null ? OffsetDateTime.class : LocalDateTime.class;
                break;
            }
            default: {
                clazz = type.getObjectClass();
            }
        }
        return clazz;
    }

    public String toNativeType(ClickHouseColumn column) {
        return column.getOriginalTypeName();
    }

    public int toSqlType(ClickHouseColumn column, Map<String, Class<?>> typeMap) {
        Class<?> javaClass = this.getCustomJavaClass(column, typeMap);
        if (javaClass != null) {
            return this.getSqlType(javaClass);
        }
        int sqlType = 1111;
        switch (column.getDataType()) {
            case Bool: {
                sqlType = 16;
                break;
            }
            case Int8: {
                sqlType = -6;
                break;
            }
            case UInt8: 
            case Int16: {
                sqlType = 5;
                break;
            }
            case UInt16: 
            case Int32: {
                sqlType = 4;
                break;
            }
            case UInt32: 
            case Int64: 
            case IntervalYear: 
            case IntervalQuarter: 
            case IntervalMonth: 
            case IntervalWeek: 
            case IntervalDay: 
            case IntervalHour: 
            case IntervalMinute: 
            case IntervalSecond: 
            case IntervalMicrosecond: 
            case IntervalMillisecond: 
            case IntervalNanosecond: {
                sqlType = -5;
                break;
            }
            case UInt64: 
            case Int128: 
            case UInt128: 
            case Int256: 
            case UInt256: {
                sqlType = 2;
                break;
            }
            case Float32: {
                sqlType = 6;
                break;
            }
            case Float64: {
                sqlType = 8;
                break;
            }
            case Decimal: 
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                sqlType = 3;
                break;
            }
            case Date: 
            case Date32: {
                sqlType = 91;
                break;
            }
            case DateTime: 
            case DateTime32: 
            case DateTime64: {
                sqlType = column.getTimeZone() != null ? 2014 : 93;
                break;
            }
            case Enum8: 
            case Enum16: 
            case IPv4: 
            case IPv6: 
            case JSON: 
            case Object: 
            case FixedString: 
            case String: 
            case UUID: {
                sqlType = 12;
                break;
            }
            case Point: 
            case Ring: 
            case Polygon: 
            case MultiPolygon: 
            case Array: {
                sqlType = 2003;
                break;
            }
            case Map: 
            case Nested: 
            case Tuple: {
                sqlType = 2002;
                break;
            }
            case Nothing: {
                sqlType = 0;
                break;
            }
        }
        return sqlType;
    }

    static final class InstanceHolder {
        private static final JdbcTypeMapping defaultMapping = (JdbcTypeMapping)ClickHouseUtils.getService(JdbcTypeMapping.class, JdbcTypeMapping::new);
        private static final JdbcTypeMapping ansiMapping = new AnsiTypeMapping();

        private InstanceHolder() {
        }
    }

    static final class AnsiTypeMapping
    extends JdbcTypeMapping {
        AnsiTypeMapping() {
        }

        static String toAnsiSqlType(ClickHouseDataType dataType, int precision, int scale, TimeZone tz) {
            String typeName;
            switch (dataType) {
                case Bool: {
                    typeName = "BOOLEAN";
                    break;
                }
                case Date: 
                case Date32: {
                    typeName = "DATE";
                    break;
                }
                case DateTime: 
                case DateTime32: 
                case DateTime64: {
                    typeName = (scale <= 0 ? new StringBuilder("TIMESTAMP") : new StringBuilder("TIMESTAMP(").append(scale).append(')')).append(tz != null ? " WITH TIMEZONE" : "").toString();
                    break;
                }
                case Int8: {
                    typeName = "BYTE";
                    break;
                }
                case UInt8: 
                case Int16: {
                    typeName = "SMALLINT";
                    break;
                }
                case UInt16: 
                case Int32: {
                    typeName = "INTEGER";
                    break;
                }
                case UInt32: 
                case Int64: 
                case IntervalYear: 
                case IntervalQuarter: 
                case IntervalMonth: 
                case IntervalWeek: 
                case IntervalDay: 
                case IntervalHour: 
                case IntervalMinute: 
                case IntervalSecond: 
                case IntervalMicrosecond: 
                case IntervalMillisecond: 
                case IntervalNanosecond: {
                    typeName = "BIGINT";
                    break;
                }
                case UInt64: 
                case Int128: 
                case UInt128: 
                case Int256: 
                case UInt256: 
                case Decimal: 
                case Decimal32: 
                case Decimal64: 
                case Decimal128: 
                case Decimal256: {
                    typeName = "DECIMAL(" + precision + ',' + scale + ')';
                    break;
                }
                case Float32: {
                    typeName = "REAL";
                    break;
                }
                case Float64: {
                    typeName = "DOUBLE PRECISION";
                    break;
                }
                case Point: 
                case Ring: 
                case Polygon: 
                case MultiPolygon: {
                    typeName = "ARRAY";
                    break;
                }
                case Enum8: 
                case Enum16: 
                case IPv4: 
                case IPv6: 
                case JSON: 
                case Object: 
                case FixedString: 
                case String: 
                case UUID: {
                    typeName = "VARCHAR";
                    break;
                }
                default: {
                    typeName = "BINARY";
                }
            }
            return typeName;
        }

        static String toAnsiSqlType(ClickHouseColumn column, StringBuilder builder) {
            String sqlType;
            ClickHouseDataType dataType = column.getDataType();
            if (dataType == ClickHouseDataType.SimpleAggregateFunction) {
                sqlType = column.hasNestedColumn() ? AnsiTypeMapping.toAnsiSqlType((ClickHouseColumn)column.getNestedColumns().get(0), builder) : "BINARY";
            } else if (column.isArray()) {
                sqlType = builder.append("ARRAY").append('(').append(AnsiTypeMapping.toAnsiSqlType(column.getArrayBaseColumn(), builder)).append(')').toString();
            } else {
                if (column.isMap()) {
                    return builder.append("MAP").append('(').append(AnsiTypeMapping.toAnsiSqlType(column.getKeyInfo(), builder)).append(',').append(AnsiTypeMapping.toAnsiSqlType(column.getValueInfo(), builder)).append(')').toString();
                }
                if (column.isNested() || column.isTuple()) {
                    builder.append("STRUCT").append('(');
                    for (ClickHouseColumn c : column.getNestedColumns()) {
                        builder.append(AnsiTypeMapping.toAnsiSqlType(c, builder)).append(',');
                    }
                    builder.setLength(builder.length() - 1);
                    sqlType = builder.append(')').toString();
                } else {
                    sqlType = AnsiTypeMapping.toAnsiSqlType(dataType, column.getPrecision(), column.getScale(), column.getTimeZone());
                }
            }
            return sqlType;
        }

        @Override
        protected int getSqlType(Class<?> javaClass) {
            int sqlType = javaClass == Boolean.TYPE || javaClass == Boolean.class ? 16 : (javaClass == Byte.TYPE || javaClass == Byte.class ? -6 : (javaClass == Short.TYPE || javaClass == Short.class || javaClass == Integer.TYPE || javaClass == Integer.class ? 4 : (javaClass == Long.TYPE || javaClass == Long.class ? -5 : (javaClass == Float.TYPE || javaClass == Float.class ? 6 : (javaClass == Double.TYPE || javaClass == Double.class ? 8 : (javaClass == BigInteger.class || javaClass == BigDecimal.class ? 3 : (javaClass == Date.class || javaClass == LocalDate.class ? 91 : (javaClass == Time.class || javaClass == LocalTime.class ? 92 : (javaClass == Timestamp.class || javaClass == LocalDateTime.class || javaClass == OffsetDateTime.class || javaClass == ZonedDateTime.class ? 93 : (javaClass == String.class || javaClass == byte[].class || Enum.class.isAssignableFrom(javaClass) ? 12 : (javaClass.isArray() ? 2003 : (List.class.isAssignableFrom(javaClass) || Map.class.isAssignableFrom(javaClass) ? 2002 : 1111))))))))))));
            return sqlType;
        }

        @Override
        public String toNativeType(ClickHouseColumn column) {
            return AnsiTypeMapping.toAnsiSqlType(column, new StringBuilder());
        }

        @Override
        public int toSqlType(ClickHouseColumn column, Map<String, Class<?>> typeMap) {
            Class<?> javaClass = this.getCustomJavaClass(column, typeMap);
            if (javaClass != null) {
                return this.getSqlType(javaClass);
            }
            int sqlType = 1111;
            switch (column.getDataType()) {
                case Bool: {
                    sqlType = 16;
                    break;
                }
                case Int8: {
                    sqlType = -6;
                    break;
                }
                case UInt8: 
                case Int16: 
                case UInt16: 
                case Int32: {
                    sqlType = 4;
                    break;
                }
                case UInt32: 
                case Int64: 
                case IntervalYear: 
                case IntervalQuarter: 
                case IntervalMonth: 
                case IntervalWeek: 
                case IntervalDay: 
                case IntervalHour: 
                case IntervalMinute: 
                case IntervalSecond: 
                case IntervalMicrosecond: 
                case IntervalMillisecond: 
                case IntervalNanosecond: {
                    sqlType = -5;
                    break;
                }
                case Float32: {
                    sqlType = 6;
                    break;
                }
                case Float64: {
                    sqlType = 8;
                    break;
                }
                case UInt64: 
                case Int128: 
                case UInt128: 
                case Int256: 
                case UInt256: 
                case Decimal: 
                case Decimal32: 
                case Decimal64: 
                case Decimal128: 
                case Decimal256: {
                    sqlType = 3;
                    break;
                }
                case Date: 
                case Date32: {
                    sqlType = 91;
                    break;
                }
                case DateTime: 
                case DateTime32: 
                case DateTime64: {
                    sqlType = 93;
                    break;
                }
                case Enum8: 
                case Enum16: 
                case IPv4: 
                case IPv6: 
                case JSON: 
                case Object: 
                case FixedString: 
                case String: 
                case UUID: {
                    sqlType = 12;
                    break;
                }
                case Point: 
                case Ring: 
                case Polygon: 
                case MultiPolygon: 
                case Array: {
                    sqlType = 2003;
                    break;
                }
                case Map: 
                case Nested: 
                case Tuple: {
                    sqlType = 2002;
                    break;
                }
                case Nothing: {
                    sqlType = 0;
                    break;
                }
            }
            return sqlType;
        }
    }
}

