/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.data.ClickHouseUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class JdbcParameterizedQuery
extends ClickHouseParameterizedQuery {
    public static JdbcParameterizedQuery of(ClickHouseConfig config, String query) {
        return new JdbcParameterizedQuery(config, query);
    }

    private JdbcParameterizedQuery(ClickHouseConfig config, String query) {
        super(config, query);
    }

    protected String parse() {
        int paramIndex = 0;
        int partIndex = 0;
        int len = this.originalQuery.length();
        for (int i = 0; i < len; ++i) {
            char ch = this.originalQuery.charAt(i);
            if (ClickHouseUtils.isQuote((char)ch)) {
                i = ClickHouseUtils.skipQuotedString((String)this.originalQuery, (int)i, (int)len, (char)ch) - 1;
                continue;
            }
            if (ch == '?') {
                int idx = ClickHouseUtils.skipContentsUntil((String)this.originalQuery, (int)(i + 2), (int)len, (char[])new char[]{'?', ':'});
                if (idx < len && this.originalQuery.charAt(idx - 1) == ':' && this.originalQuery.charAt(idx) != ':' && this.originalQuery.charAt(idx - 2) != ':') {
                    i = idx - 1;
                    continue;
                }
                this.addPart(this.originalQuery.substring(partIndex, i), paramIndex++, null);
                partIndex = i + 1;
                continue;
            }
            if (ch == ';') {
                throw new IllegalArgumentException(ClickHouseUtils.format((String)"Multi-statement query cannot be used in prepared statement. Please remove semicolon at %d and everything after it.", (Object[])new Object[]{i}));
            }
            if (i + 1 >= len) continue;
            char nextCh = this.originalQuery.charAt(i + 1);
            if (ch == '-' && nextCh == ch) {
                i = ClickHouseUtils.skipSingleLineComment((String)this.originalQuery, (int)(i + 2), (int)len) - 1;
                continue;
            }
            if (ch != '/' || nextCh != '*') continue;
            i = ClickHouseUtils.skipMultiLineComment((String)this.originalQuery, (int)(i + 2), (int)len) - 1;
        }
        return partIndex < len ? this.originalQuery.substring(partIndex, len) : null;
    }

    public void apply(StringBuilder builder, Collection<String> params) {
        if (!this.hasParameter()) {
            builder.append(this.originalQuery);
            return;
        }
        Iterator<Object> it = params == null ? Collections.emptyIterator() : params.iterator();
        for (ClickHouseParameterizedQuery.QueryPart p : this.getParts()) {
            builder.append(p.part);
            builder.append(it.hasNext() ? (String)it.next() : "NULL");
        }
        this.appendLastPartIfExists(builder);
    }

    public void apply(StringBuilder builder, Object param, Object ... more) {
        if (!this.hasParameter()) {
            builder.append(this.originalQuery);
            return;
        }
        int len = more == null ? 0 : more.length + 1;
        int index = 0;
        for (ClickHouseParameterizedQuery.QueryPart p : this.getParts()) {
            builder.append(p.part);
            if (index > 0) {
                param = index < len ? more[index - 1] : null;
            }
            builder.append(this.toSqlExpression(p.paramName, param));
            ++index;
        }
        this.appendLastPartIfExists(builder);
    }

    public void apply(StringBuilder builder, Object[] values) {
        if (!this.hasParameter()) {
            builder.append(this.originalQuery);
            return;
        }
        int len = values == null ? 0 : values.length;
        int index = 0;
        for (ClickHouseParameterizedQuery.QueryPart p : this.getParts()) {
            builder.append(p.part);
            builder.append(index < len ? this.toSqlExpression(p.paramName, values[index]) : "NULL");
            ++index;
        }
        this.appendLastPartIfExists(builder);
    }

    public void apply(StringBuilder builder, String param, String ... more) {
        if (!this.hasParameter()) {
            builder.append(this.originalQuery);
            return;
        }
        int len = more == null ? 0 : more.length + 1;
        int index = 0;
        for (ClickHouseParameterizedQuery.QueryPart p : this.getParts()) {
            builder.append(p.part);
            if (index > 0) {
                param = index < len ? more[index - 1] : "NULL";
            }
            builder.append(param);
            ++index;
        }
        this.appendLastPartIfExists(builder);
    }

    public void apply(StringBuilder builder, String[] values) {
        if (!this.hasParameter()) {
            builder.append(this.originalQuery);
            return;
        }
        int len = values == null ? 0 : values.length;
        int index = 0;
        for (ClickHouseParameterizedQuery.QueryPart p : this.getParts()) {
            builder.append(p.part);
            builder.append(index < len ? values[index] : "NULL");
            ++index;
        }
        this.appendLastPartIfExists(builder);
    }
}

