/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseDateTimeValue;
import com.clickhouse.client.data.ClickHouseDateValue;
import com.clickhouse.client.data.ClickHouseStringValue;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.jdbc.ClickHousePreparedStatement;
import com.clickhouse.jdbc.JdbcParameterizedQuery;
import com.clickhouse.jdbc.JdbcTypeMapping;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.AbstractPreparedStatement;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public class SqlBasedPreparedStatement
extends AbstractPreparedStatement
implements ClickHousePreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(SqlBasedPreparedStatement.class);
    private final Calendar defaultCalendar;
    private final TimeZone preferredTimeZone;
    private final ZoneId timeZoneForDate;
    private final ZoneId timeZoneForTs;
    private final ClickHouseSqlStatement parsedStmt;
    private final String insertValuesQuery;
    private final ClickHouseParameterizedQuery preparedQuery;
    private final ClickHouseValue[] templates;
    private final String[] values;
    private final List<String[]> batch;
    private final StringBuilder builder;
    private int counter;

    protected SqlBasedPreparedStatement(ClickHouseConnectionImpl connection, ClickHouseRequest<?> request, ClickHouseSqlStatement parsedStmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, request, resultSetType, resultSetConcurrency, resultSetHoldability);
        ClickHouseConfig config = this.getConfig();
        this.defaultCalendar = connection.getDefaultCalendar();
        this.preferredTimeZone = config.getUseTimeZone();
        this.timeZoneForTs = this.preferredTimeZone.toZoneId();
        this.timeZoneForDate = config.isUseServerTimeZoneForDates() ? this.timeZoneForTs : null;
        this.parsedStmt = parsedStmt;
        String valuesExpr = null;
        Object parsedValuesExpr = null;
        String prefix = null;
        if (parsedStmt.hasValues()) {
            valuesExpr = parsedStmt.getContentBetweenKeywords("ValuesStart", "ValuesEnd");
            if (ClickHouseChecker.isNullOrBlank((CharSequence)valuesExpr)) {
                log.warn((Object)"Please consider to use one and only one values expression, for example: use 'values(?)' instead of 'values(?),(?)'.", new Object[0]);
            } else {
                valuesExpr = valuesExpr + ")";
                prefix = parsedStmt.getSQL().substring(0, parsedStmt.getPositions().get("ValuesStart"));
                parsedValuesExpr = connection.getJdbcConfig().useNamedParameter() ? ClickHouseParameterizedQuery.of((ClickHouseConfig)config, (String)valuesExpr) : JdbcParameterizedQuery.of(config, valuesExpr);
            }
        }
        this.preparedQuery = parsedValuesExpr == null ? request.getPreparedQuery() : parsedValuesExpr;
        this.templates = this.preparedQuery.getParameterTemplates();
        this.values = new String[this.templates.length];
        this.batch = new LinkedList<String[]>();
        this.builder = new StringBuilder();
        this.insertValuesQuery = prefix;
        if (this.insertValuesQuery != null) {
            this.builder.append(this.insertValuesQuery);
        }
        this.counter = 0;
    }

    protected void ensureParams() throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            columns.add(String.valueOf(i + 1));
        }
        if (!columns.isEmpty()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing parameter(s): %s", (Object[])new Object[]{columns}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long[] executeAny(boolean asBatch) throws SQLException {
        this.ensureOpen();
        boolean continueOnError = false;
        if (asBatch) {
            if (this.counter < 1) {
                throw SqlExceptionUtils.emptyBatchError();
            }
            continueOnError = this.getConnection().getJdbcConfig().isContinueBatchOnError();
        } else {
            if (this.counter != 0) {
                throw SqlExceptionUtils.undeterminedExecutionError();
            }
            this.addBatch();
        }
        long[] results = new long[this.counter];
        ClickHouseResponse r = null;
        if (this.builder.length() > 0) {
            long rows = 0L;
            try {
                r = this.executeStatement(this.builder.toString(), null, null, null);
                this.updateResult(this.parsedStmt, r);
                if (asBatch && this.getResultSet() != null) {
                    throw SqlExceptionUtils.queryInBatchError(results);
                }
                rows = r.getSummary().getWrittenRows();
                Arrays.fill(results, 1L);
            }
            catch (Exception e) {
                if (!asBatch) {
                    throw SqlExceptionUtils.handle(e);
                }
                if (rows < 1L) {
                    results[0] = -3L;
                } else {
                    if (rows >= (long)this.counter) {
                        rows = this.counter;
                    }
                    int len = (int)rows - 1;
                    for (int i = 0; i < len; ++i) {
                        results[i] = 1L;
                    }
                    results[(int)rows] = -3L;
                }
                if (!continueOnError) {
                    throw SqlExceptionUtils.batchUpdateError(e, results);
                }
                log.error((Object)"Failed to execute batch insertion of %d records", new Object[]{this.counter, e});
            }
            finally {
                if (asBatch && r != null) {
                    r.close();
                }
                this.clearBatch();
            }
        } else {
            int index = 0;
            try {
                for (String[] params : this.batch) {
                    this.builder.setLength(0);
                    this.preparedQuery.apply(this.builder, params);
                    try {
                        r = this.executeStatement(this.builder.toString(), null, null, null);
                        this.updateResult(this.parsedStmt, r);
                        if (asBatch && this.getResultSet() != null) {
                            throw SqlExceptionUtils.queryInBatchError(results);
                        }
                        int count = this.getUpdateCount();
                        results[index] = count > 0 ? (long)count : 0L;
                    }
                    catch (Exception e) {
                        results[index] = -3L;
                        if (!continueOnError) {
                            throw SqlExceptionUtils.batchUpdateError(e, results);
                        }
                        log.error((Object)"Failed to execute batch insert at %d of %d", new Object[]{index + 1, this.counter, e});
                    }
                    finally {
                        ++index;
                        if (!asBatch || r == null) continue;
                        r.close();
                    }
                }
            }
            finally {
                this.clearBatch();
            }
        }
        return results;
    }

    @Override
    protected int getMaxParameterIndex() {
        return this.templates.length;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null) {
                throw e;
            }
            throw new SQLException("Query failed", "07000", e.getCause());
        }
        ResultSet rs = this.getResultSet();
        return rs == null ? this.newEmptyResultSet() : rs;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null) {
                throw e;
            }
            throw new SQLException("Update failed", "07000", e.getCause());
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = ClickHouseValues.convertToQuotedString((Object)x);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value == null) {
            this.templates[idx] = value = ClickHouseStringValue.ofNull();
        }
        this.values[idx] = value.update(x).toSqlExpression();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else if (x instanceof ClickHouseValue) {
            this.templates[idx] = value = (ClickHouseValue)x;
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = ClickHouseValues.convertToSqlExpression((Object)x);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null) {
                throw e;
            }
            throw new SQLException("Execution failed", "07000", e.getCause());
        }
        return this.getResultSet() != null;
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        if (this.builder.length() > 0) {
            int index = 1;
            for (String v : this.values) {
                if (v == null) {
                    throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing value for parameter #%d", (Object[])new Object[]{index}));
                }
                ++index;
            }
            this.preparedQuery.apply(this.builder, this.values);
        } else {
            int len = this.values.length;
            String[] newValues = new String[len];
            for (int i = 0; i < len; ++i) {
                String v = this.values[i];
                if (v == null) {
                    throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing value for parameter #%d", (Object[])new Object[]{i + 1}));
                }
                newValues[i] = v;
            }
            this.batch.add(newValues);
        }
        ++this.counter;
        this.clearParameters();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.batch.clear();
        this.builder.setLength(0);
        if (this.insertValuesQuery != null) {
            this.builder.append(this.insertValuesQuery);
        }
        this.counter = 0;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        Object array = x != null ? x.getArray() : x;
        this.values[idx] = array != null ? ClickHouseValues.convertToSqlExpression((Object)array) : "[]";
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        LocalDate d;
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x == null) {
            this.values[idx] = "NULL";
            return;
        }
        if (cal == null) {
            cal = this.defaultCalendar;
        }
        ZoneId tz = cal.getTimeZone().toZoneId();
        if (this.timeZoneForDate == null || tz.equals(this.timeZoneForDate)) {
            d = x.toLocalDate();
        } else {
            Calendar c = (Calendar)cal.clone();
            c.setTime(x);
            d = c.toInstant().atZone(tz).withZoneSameInstant(this.timeZoneForDate).toLocalDate();
        }
        ClickHouseValue value = this.templates[idx];
        if (value == null) {
            value = ClickHouseDateValue.ofNull();
        }
        this.values[idx] = value.update(d).toSqlExpression();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        LocalTime t;
        ZoneId tz;
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x == null) {
            this.values[idx] = "NULL";
            return;
        }
        if (cal == null) {
            cal = this.defaultCalendar;
        }
        if ((tz = cal.getTimeZone().toZoneId()).equals(this.timeZoneForTs)) {
            t = x.toLocalTime();
        } else {
            Calendar c = (Calendar)cal.clone();
            c.setTime(x);
            t = c.toInstant().atZone(tz).withZoneSameInstant(this.timeZoneForTs).toLocalTime();
        }
        ClickHouseValue value = this.templates[idx];
        if (value == null) {
            value = ClickHouseDateValue.ofNull();
        }
        this.values[idx] = value.update(t).toSqlExpression();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        LocalDateTime dt;
        ZoneId tz;
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x == null) {
            this.values[idx] = "NULL";
            return;
        }
        if (cal == null) {
            cal = this.defaultCalendar;
        }
        if ((tz = cal.getTimeZone().toZoneId()).equals(this.timeZoneForTs)) {
            dt = x.toLocalDateTime();
        } else {
            Calendar c = (Calendar)cal.clone();
            c.setTime(x);
            dt = c.toInstant().atZone(tz).withZoneSameInstant(this.timeZoneForTs).toLocalDateTime();
        }
        ClickHouseValue value = this.templates[idx];
        if (value == null) {
            value = ClickHouseDateTimeValue.ofNull((int)(dt.getNano() > 0 ? 9 : 0), (TimeZone)this.preferredTimeZone);
        }
        this.values[idx] = value.update(dt).toSqlExpression();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.resetToNullOrEmpty();
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = "NULL";
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value == null) {
            this.templates[idx] = value = ClickHouseValues.newValue((ClickHouseConfig)this.getConfig(), (ClickHouseColumn)JdbcTypeMapping.fromJdbcType(targetSqlType, scaleOrLength));
        }
        value.update(x);
        this.values[idx] = value.toSqlExpression();
    }
}

