/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.sql.SQLException;
import java.util.TimeZone;
import ru.yandex.clickhouse.except.ClickHouseUnknownException;
import ru.yandex.clickhouse.response.ByteFragment;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseValueParser;

final class ClickHouseFloatParser
extends ClickHouseValueParser<Float> {
    private static ClickHouseFloatParser instance;

    static ClickHouseFloatParser getInstance() {
        if (instance == null) {
            instance = new ClickHouseFloatParser();
        }
        return instance;
    }

    private ClickHouseFloatParser() {
    }

    @Override
    public Float parse(ByteFragment value, ClickHouseColumnInfo columnInfo, TimeZone resultTimeZone) throws SQLException {
        String s;
        if (value.isNull()) {
            return null;
        }
        if (value.isNaN()) {
            return Float.valueOf(Float.NaN);
        }
        switch (s = value.asString()) {
            case "+inf": 
            case "inf": {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            case "-inf": {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        try {
            return Float.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            throw new ClickHouseUnknownException("Error parsing '" + s + "' as Float", nfe);
        }
    }

    @Override
    protected Float getDefaultValue() {
        return Float.valueOf(0.0f);
    }
}

