/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseVersion;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.JdbcConfig;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseJdbcUrlParser;
import java.io.Serializable;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DriverV1
implements Driver {
    private static final Logger log = LoggerFactory.getLogger(DriverV1.class);
    private static final Map<Object, ClickHouseOption> clientSpecificOptions;
    static final String driverVersionString;
    static final ClickHouseVersion driverVersion;
    static final ClickHouseVersion specVersion;
    static final java.util.logging.Logger parentLogger;
    public static String frameworksDetected;

    public static void load() {
        try {
            log.debug("Registering ClickHouse JDBC driver v1 ({})", (Object)driverVersion);
            DriverManager.registerDriver(new DriverV1());
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        log.debug("ClickHouse Driver {}(JDBC: {}) registered", (Object)driverVersion, (Object)specVersion);
    }

    public static void unload() {
        try {
            log.debug("Unregistering ClickHouse JDBC driver v1 ({})", (Object)driverVersion);
            DriverManager.deregisterDriver(new DriverV1());
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Map<ClickHouseOption, Serializable> toClientOptions(Properties props) {
        if (props == null || props.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            String key = e.getKey().toString();
            ClickHouseOption o = ClickHouseClientOption.fromKey(key);
            if (o == null) {
                o = clientSpecificOptions.get(key);
            }
            if (o == null) continue;
            options.put(o, ClickHouseOption.fromString(e.getValue().toString(), o.getValueType()));
        }
        return options;
    }

    private DriverPropertyInfo create(ClickHouseOption option, Properties props) {
        DriverPropertyInfo propInfo = new DriverPropertyInfo(option.getKey(), props.getProperty(option.getKey(), String.valueOf(option.getEffectiveDefaultValue())));
        propInfo.required = false;
        propInfo.description = option.getDescription();
        propInfo.choices = null;
        Class<? extends Serializable> clazz = option.getValueType();
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            propInfo.choices = new String[]{"true", "false"};
        } else if (clazz.isEnum()) {
            Serializable[] values = clazz.getEnumConstants();
            String[] names = new String[values.length];
            int index = 0;
            for (Serializable v : values) {
                names[index++] = ((Enum)((Object)v)).name();
            }
            propInfo.choices = names;
        }
        return propInfo;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && (url.startsWith("jdbc:clickhouse:") || url.startsWith("jdbc:ch:"));
    }

    @Override
    public ClickHouseConnection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        log.debug("Creating connection");
        return new ClickHouseConnectionImpl(url, info);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        try {
            info = ClickHouseJdbcUrlParser.parse(url, info).getProperties();
        }
        catch (Exception e) {
            log.error("Could not parse url {}", (Object)url, (Object)e);
        }
        ArrayList<DriverPropertyInfo> result = new ArrayList<DriverPropertyInfo>(ClickHouseClientOption.values().length * 2);
        for (ClickHouseClientOption option : ClickHouseClientOption.values()) {
            result.add(this.create(option, info));
        }
        for (ClickHouseOption option : clientSpecificOptions.values()) {
            result.add(this.create(option, info));
        }
        result.addAll(JdbcConfig.getDriverProperties());
        return result.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return driverVersion.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return driverVersion.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return parentLogger;
    }

    static {
        parentLogger = java.util.logging.Logger.getLogger("com.clickhouse.jdbc");
        frameworksDetected = null;
        log.debug("Initializing ClickHouse JDBC driver V1");
        String str = DriverV1.class.getPackage().getImplementationVersion();
        if (str != null && !str.isEmpty()) {
            char[] chars = str.toCharArray();
            int len = chars.length;
            for (int i = 0; i < len; ++i) {
                if (!Character.isDigit(chars[i])) continue;
                str = str.substring(i);
                break;
            }
            driverVersionString = str;
        } else {
            driverVersionString = "";
        }
        driverVersion = ClickHouseVersion.of(driverVersionString);
        specVersion = ClickHouseVersion.of(DriverV1.class.getPackage().getSpecificationVersion());
        LinkedHashMap<String, ClickHouseOption> m = new LinkedHashMap<String, ClickHouseOption>();
        try {
            for (ClickHouseClient c : ServiceLoader.load(ClickHouseClient.class, DriverV1.class.getClassLoader())) {
                Class<? extends ClickHouseOption> clazz = c.getOptionClass();
                if (clazz == null || clazz == ClickHouseClientOption.class) continue;
                for (ClickHouseOption o : clazz.getEnumConstants()) {
                    m.put(o.getKey(), o);
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to load client-specific options", e);
        }
        clientSpecificOptions = Collections.unmodifiableMap(m);
    }

    public static class FrameworksDetection {
        private static final List<String> FRAMEWORKS_TO_DETECT = Arrays.asList("apache.spark", "apache.flink", "apache.nifi");
        static volatile String frameworksDetected = null;

        private FrameworksDetection() {
        }

        public static String getFrameworksDetected() {
            if (frameworksDetected == null) {
                LinkedHashSet<String> inferredFrameworks = new LinkedHashSet<String>();
                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                    for (String framework : FRAMEWORKS_TO_DETECT) {
                        if (!ste.toString().contains(framework)) continue;
                        inferredFrameworks.add(String.format("(%s)", framework));
                    }
                }
                frameworksDetected = String.join((CharSequence)"; ", inferredFrameworks);
            }
            return frameworksDetected;
        }
    }
}

