/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.api.Client;
import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.GenericRecord;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.jdbc.ClientInfoProperties;
import com.clickhouse.jdbc.Driver;
import com.clickhouse.jdbc.DriverProperties;
import com.clickhouse.jdbc.JdbcV2Wrapper;
import com.clickhouse.jdbc.PreparedStatementImpl;
import com.clickhouse.jdbc.StatementImpl;
import com.clickhouse.jdbc.WriterStatementImpl;
import com.clickhouse.jdbc.internal.FeatureManager;
import com.clickhouse.jdbc.internal.JdbcConfiguration;
import com.clickhouse.jdbc.internal.ParsedPreparedStatement;
import com.clickhouse.jdbc.internal.SqlParserFacade;
import com.clickhouse.jdbc.metadata.DatabaseMetaDataImpl;
import com.clickhouse.jdbc.types.Array;
import com.clickhouse.jdbc.types.Struct;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
implements Connection,
JdbcV2Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionImpl.class);
    protected final String url;
    private final Client client;
    protected final JdbcConfiguration config;
    private boolean closed = false;
    protected boolean onCluster;
    protected String cluster;
    private String catalog;
    private String schema;
    private String appName;
    private QuerySettings defaultQuerySettings;
    private boolean readOnly;
    private int holdability;
    private final DatabaseMetaDataImpl metadata;
    protected final Calendar defaultCalendar;
    private final SqlParserFacade sqlParser;
    private Executor networkTimeoutExecutor;
    private final FeatureManager featureManager;

    public ConnectionImpl(String url, Properties info) throws SQLException {
        try {
            this.url = url;
            this.config = new JdbcConfiguration(url, info);
            this.onCluster = false;
            this.cluster = null;
            this.appName = "";
            this.readOnly = false;
            this.holdability = 1;
            String clientName = "ClickHouse JDBC Driver V2/" + Driver.getLibraryVersion();
            Map<String, String> clientProperties = this.config.getClientProperties();
            if (clientProperties.get(ClientConfigProperties.CLIENT_NAME.getKey()) != null) {
                this.appName = clientProperties.get(ClientConfigProperties.CLIENT_NAME.getKey()).trim();
                clientName = this.appName + " " + clientName;
            } else if (clientProperties.get(ClientConfigProperties.PRODUCT_NAME.getKey()) != null) {
                this.appName = clientProperties.get(ClientConfigProperties.PRODUCT_NAME.getKey()).trim();
                clientName = this.appName + " " + clientName;
            }
            if (this.config.isDisableFrameworkDetection()) {
                LOG.debug("Framework detection is disabled.");
            } else {
                String detectedFrameworks = Driver.FrameworksDetection.getFrameworksDetected();
                LOG.debug("Detected frameworks: {}", (Object)detectedFrameworks);
                if (!detectedFrameworks.trim().isEmpty()) {
                    clientName = clientName + " (" + detectedFrameworks + ")";
                }
            }
            this.client = this.config.applyClientProperties(new Client.Builder()).setClientName(clientName).build();
            String serverTimezone = this.client.getServerTimeZone();
            if (serverTimezone == null) {
                this.client.loadServerInfo();
            }
            this.schema = this.client.getDefaultDatabase();
            this.defaultQuerySettings = new QuerySettings().serverSetting("async_insert", "0").serverSetting("wait_end_of_query", "0");
            this.metadata = new DatabaseMetaDataImpl(this, false, url);
            this.defaultCalendar = Calendar.getInstance();
            this.sqlParser = SqlParserFacade.getParser(this.config.getDriverProperty(DriverProperties.SQL_PARSER.getKey(), DriverProperties.SQL_PARSER.getDefaultValue()));
            this.featureManager = new FeatureManager(this.config);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Failed to create connection", "08000", e);
        }
    }

    public SqlParserFacade getSqlParser() {
        return this.sqlParser;
    }

    public QuerySettings getDefaultQuerySettings() {
        return this.defaultQuerySettings;
    }

    public void setDefaultQuerySettings(QuerySettings settings) {
        this.defaultQuerySettings = settings;
    }

    public Calendar getDefaultCalendar() {
        return this.defaultCalendar;
    }

    public String getServerVersion() throws SQLException {
        GenericRecord result = (GenericRecord)this.client.queryAll("SELECT version() as server_version").stream().findFirst().orElseThrow(() -> new SQLException("Failed to retrieve server version.", "HY000"));
        return result.getString("server_version");
    }

    public JdbcConfiguration getJdbcConfig() {
        return this.config;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.ensureOpen();
        return this.createStatement(1003, 1007, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.ensureOpen();
        return this.prepareStatement(sql, 1003, 1007, 2);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("prepareCall(String sql)");
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureOpen();
        return StatementImpl.escapedSQLToNative(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("setAutoCommit(false)", !autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureOpen();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.featureManager.unsupportedFeatureThrow("commit()");
    }

    @Override
    public void rollback() throws SQLException {
        this.featureManager.unsupportedFeatureThrow("rollback()");
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.client.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureOpen();
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpen();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("setTransactionIsolation(TRANSACTION_NONE)", 0 != level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureOpen();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.ensureOpen();
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.ensureOpen();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("prepareCall(String sql, int resultSetType, int resultSetConcurrency)");
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("getTypeMap()");
        return Collections.emptyMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("setTypeMap(Map<String, Class<?>>)");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureOpen();
        if (holdability != 1 && holdability != 2) {
            throw new SQLException("Only ResultSet.HOLD_CURSORS_OVER_COMMIT and  ResultSet.CLOSE_CURSORS_AT_COMMIT allowed for holdability");
        }
        this.holdability = 1;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureOpen();
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("setSavepoint()");
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("setSavepoint(String name)");
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("rollback(Savepoint savepoint)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("releaseSavepoint(Savepoint savepoint)");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        this.checkResultSetFlags(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new StatementImpl(this);
    }

    private void checkResultSetFlags(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.config.isIgnoreUnsupportedRequests()) {
            if (resultSetType != 1003) {
                throw new SQLFeatureNotSupportedException("Cannot create statement with result set type other then ResultSet.TYPE_FORWARD_ONLY", "0A000");
            }
            if (resultSetConcurrency != 1007) {
                throw new SQLFeatureNotSupportedException("Cannot create statement with result set concurrency other then ResultSet.CONCUR_READ_ONLY", "0A000");
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        this.checkResultSetFlags(resultSetType, resultSetConcurrency, resultSetHoldability);
        ParsedPreparedStatement parsedStatement = this.sqlParser.parsePreparedStatement(sql);
        if (parsedStatement.isInsert() && this.config.isBetaFeatureEnabled(DriverProperties.BETA_ROW_BINARY_WRITER) && !parsedStatement.isInsertWithSelect() && parsedStatement.getAssignValuesGroups() == 1 && !parsedStatement.isUseFunction()) {
            TableSchema tableSchema = this.client.getTableSchema(parsedStatement.getTable(), this.schema);
            return new WriterStatementImpl(this, sql, tableSchema, parsedStatement);
        }
        return new PreparedStatementImpl(this, sql, parsedStatement);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("prepareStatement(String sql, int autoGeneratedKeys) not supported", "0A000");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.ensureOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("prepareStatement(String sql, int[] columnIndexes) not supported", "0A000");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.ensureOpen();
        if (!this.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("prepareStatement(String sql, String[] columnNames) not supported", "0A000");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("createClob()");
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("createBlob()");
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("createNClob()");
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.ensureOpen();
        this.featureManager.unsupportedFeatureThrow("createSQLXML()");
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout must be >= 0", "HY000");
        }
        if (this.isClosed()) {
            return false;
        }
        return timeout == 0 ? this.client.ping() : this.client.ping(Duration.ofSeconds(timeout).toMillis());
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (ClientInfoProperties.APPLICATION_NAME.getKey().equals(name)) {
            this.config.updateUserClient(value, this.client);
            this.appName = value;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        HashSet<String> toSet = new HashSet<String>();
        HashSet<String> toReset = new HashSet<String>();
        for (ClientInfoProperties p : ClientInfoProperties.values()) {
            String key = p.getKey();
            if (properties.containsKey(key)) {
                toSet.add(key);
                continue;
            }
            toReset.add(key);
        }
        for (String key : toReset) {
            this.setClientInfo(key, null);
        }
        for (String key : toSet) {
            this.setClientInfo(key, properties.getProperty(key));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureOpen();
        if (ClientInfoProperties.APPLICATION_NAME.getKey().equals(name)) {
            return this.appName;
        }
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureOpen();
        Properties clientInfo = new Properties();
        clientInfo.put(ClientInfoProperties.APPLICATION_NAME.getKey(), this.appName);
        return clientInfo;
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.ensureOpen();
        if (typeName == null) {
            throw new SQLFeatureNotSupportedException("typeName cannot be null");
        }
        ClickHouseColumn column = ClickHouseColumn.of("array", typeName);
        try {
            return new Array(column, elements);
        }
        catch (Exception e) {
            throw new SQLException("Failed to create array", "HY000", e);
        }
    }

    @Override
    public java.sql.Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.ensureOpen();
        if (typeName == null) {
            throw new SQLFeatureNotSupportedException("typeName cannot be null");
        }
        ClickHouseColumn column = ClickHouseColumn.of("v", typeName);
        if (column.getDataType().equals(ClickHouseDataType.Tuple)) {
            return new Struct(column, attributes);
        }
        throw new SQLException("Only Tuple datatype is supported for Struct", "HY000");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureOpen();
        this.schema = schema;
        this.defaultQuerySettings.setDatabase(this.schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureOpen();
        return this.schema;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("Executor must be not null");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.ensureOpen();
        if (milliseconds > 0 && executor == null) {
            throw new SQLException("Executor must be not null");
        }
        if (milliseconds < 0) {
            throw new SQLException("Timeout must be >= 0");
        }
        this.networkTimeoutExecutor = executor;
        this.defaultQuerySettings.setNetworkTimeout(milliseconds, ChronoUnit.MILLIS);
    }

    public synchronized void onNetworkTimeout() {
        if (this.closed || this.networkTimeoutExecutor == null) {
            return;
        }
        this.networkTimeoutExecutor.execute(() -> {
            try {
                this.abort(this.networkTimeoutExecutor);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to abort connection", e);
            }
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.defaultQuerySettings.getNetworkTimeout().intValue();
    }

    public Client getClient() throws SQLException {
        this.ensureOpen();
        return this.client;
    }

    private void ensureOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed", "08000");
        }
    }
}

