/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.data.ClickHouseLZ4InputStream;
import com.clickhouse.client.data.ClickHouseLZ4OutputStream;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class ClickHouseHttpConnection
implements AutoCloseable {
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    protected final ClickHouseConfig config;
    protected final ClickHouseNode server;
    protected final Map<String, String> defaultHeaders;
    protected final String url;

    static String urlEncode(String str, Charset charset) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static StringBuilder appendQueryParameter(StringBuilder builder, String key, String value) {
        return builder.append(ClickHouseHttpConnection.urlEncode(key, StandardCharsets.UTF_8)).append('=').append(ClickHouseHttpConnection.urlEncode(value, StandardCharsets.UTF_8)).append('&');
    }

    static String buildQueryParams(ClickHouseRequest<?> request) {
        Optional optionalValue;
        String comment;
        if (request == null) {
            return "";
        }
        ClickHouseConfig config = request.getConfig();
        StringBuilder builder = new StringBuilder();
        Map customParams = ClickHouseUtils.getKeyValuePairs((String)((String)((Object)config.getOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS))));
        for (Map.Entry cp : customParams.entrySet()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, (String)cp.getKey(), (String)cp.getValue());
        }
        if (config.isCompressServerResponse()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "compress", "1");
        }
        if (config.isDecompressClientRequet()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "decompress", "1");
        }
        Map settings = request.getSettings();
        List stmts = request.getStatements(false);
        String settingKey = "max_execution_time";
        if (config.getMaxExecutionTime() > 0 && !settings.containsKey(settingKey)) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, String.valueOf(config.getMaxExecutionTime()));
        }
        settingKey = "max_result_rows";
        if (config.getMaxResultRows() > 0 && !settings.containsKey(settingKey)) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, String.valueOf(config.getMaxExecutionTime()));
            ClickHouseHttpConnection.appendQueryParameter(builder, "result_overflow_mode", "break");
        }
        settingKey = "log_comment";
        if (!stmts.isEmpty() && ((Boolean)config.getOption((ClickHouseOption)ClickHouseClientOption.LOG_LEADING_COMMENT)).booleanValue() && !settings.containsKey(settingKey) && !(comment = ClickHouseUtils.getLeadingComment((String)((String)stmts.get(0)))).isEmpty()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, comment);
        }
        if (!settings.containsKey(settingKey = "extremes")) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, "0");
        }
        if ((optionalValue = request.getSessionId()).isPresent()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "session_id", (String)optionalValue.get());
            if (config.isSessionCheck()) {
                ClickHouseHttpConnection.appendQueryParameter(builder, "session_check", "1");
            }
            if (config.getSessionTimeout() > 0) {
                ClickHouseHttpConnection.appendQueryParameter(builder, "session_timeout", String.valueOf(config.getSessionTimeout()));
            }
        }
        if ((optionalValue = request.getQueryId()).isPresent()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "query_id", (String)optionalValue.get());
        }
        for (Map.Entry entry : settings.entrySet()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, (String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    static String buildUrl(ClickHouseNode server, ClickHouseRequest<?> request) {
        String query;
        ClickHouseConfig config = request.getConfig();
        StringBuilder builder = new StringBuilder();
        builder.append(config.isSsl() ? "https" : "http").append("://").append(server.getHost()).append(':').append(server.getPort()).append('/');
        String context = (String)((Object)config.getOption((ClickHouseOption)ClickHouseHttpOption.WEB_CONTEXT));
        if (context != null && !context.isEmpty()) {
            char prev = '/';
            int len = context.length();
            for (int i = 0; i < len; ++i) {
                char ch = context.charAt(i);
                if (ch != '/' || ch != prev) {
                    builder.append(ch);
                }
                prev = ch;
            }
            if (prev != '/') {
                builder.append('/');
            }
        }
        if (!(query = ClickHouseHttpConnection.buildQueryParams(request)).isEmpty()) {
            builder.append('?').append(query);
        }
        return builder.toString();
    }

    protected ClickHouseHttpConnection(ClickHouseNode server, ClickHouseRequest<?> request) {
        if (server == null || request == null) {
            throw new IllegalArgumentException("Non-null server and request are required");
        }
        this.config = request.getConfig();
        this.server = server;
        this.url = ClickHouseHttpConnection.buildUrl(server, request);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll(ClickHouseUtils.getKeyValuePairs((String)((String)((Object)this.config.getOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS)))));
        map.put("Accept", "*/*");
        if (!((Boolean)this.config.getOption((ClickHouseOption)ClickHouseHttpOption.KEEP_ALIVE)).booleanValue()) {
            map.put("Connection", "Close");
        }
        map.put("User-Agent", this.config.getClientName());
        ClickHouseCredentials credentials = server.getCredentials(this.config);
        if (credentials.useAccessToken()) {
            map.put("Authorization", credentials.getAccessToken());
        } else {
            map.put("X-ClickHouse-User", credentials.getUserName());
            if (!ClickHouseChecker.isNullOrEmpty((CharSequence)credentials.getPassword())) {
                map.put("X-ClickHouse-Key", credentials.getPassword());
            }
        }
        map.put("X-ClickHouse-Database", server.getDatabase(this.config));
        map.put("X-ClickHouse-Format", this.config.getFormat().name());
        if (this.config.isCompressServerResponse()) {
            map.put("Accept-Encoding", this.config.getCompressAlgorithmForServerResponse().encoding());
        }
        if (this.config.isDecompressClientRequet() && this.config.getDecompressAlgorithmForClientRequest() != ClickHouseCompression.LZ4) {
            map.put("Content-Encoding", this.config.getDecompressAlgorithmForClientRequest().encoding());
        }
        this.defaultHeaders = Collections.unmodifiableMap(map);
    }

    protected String getBaseUrl() {
        int index = this.url.indexOf(63);
        String baseUrl = index > 0 ? this.url.substring(0, index) : this.url;
        return baseUrl;
    }

    protected OutputStream getRequestOutputStream(OutputStream out) throws IOException {
        if (!this.config.isDecompressClientRequet()) {
            return out;
        }
        ClickHouseCompression algorithm = this.config.getDecompressAlgorithmForClientRequest();
        switch (algorithm) {
            case GZIP: {
                out = new GZIPOutputStream(out, (Integer)this.config.getOption((ClickHouseOption)ClickHouseClientOption.MAX_COMPRESS_BLOCK_SIZE));
                break;
            }
            case LZ4: {
                out = new ClickHouseLZ4OutputStream(out, ((Integer)this.config.getOption((ClickHouseOption)ClickHouseClientOption.MAX_COMPRESS_BLOCK_SIZE)).intValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported compression algorithm: " + algorithm);
            }
        }
        return out;
    }

    protected ClickHouseInputStream getResponseInputStream(InputStream in) throws IOException {
        if (this.config.isCompressServerResponse()) {
            ClickHouseCompression algorithm = this.config.getCompressAlgorithmForServerResponse();
            switch (algorithm) {
                case GZIP: {
                    in = ClickHouseInputStream.of((InputStream)new GZIPInputStream(in));
                    break;
                }
                case LZ4: {
                    in = new ClickHouseLZ4InputStream(in);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported compression algorithm: " + algorithm);
                }
            }
        }
        return ClickHouseInputStream.of((InputStream)in, (int)this.config.getMaxBufferSize());
    }

    protected Map<String, String> mergeHeaders(Map<String, String> requestHeaders) {
        if (requestHeaders == null || requestHeaders.isEmpty()) {
            return this.defaultHeaders;
        }
        LinkedHashMap<String, String> merged = new LinkedHashMap<String, String>();
        merged.putAll(this.defaultHeaders);
        for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
            if (header.getValue() == null) {
                merged.remove(header.getKey());
                continue;
            }
            merged.put(header.getKey(), header.getValue());
        }
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pipe(InputStream input, OutputStream output, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            bufferSize = 8192;
        }
        byte[] bytes = new byte[bufferSize];
        int counter = 0;
        try {
            while ((counter = input.read(bytes, 0, bufferSize)) >= 0) {
                output.write(bytes, 0, counter);
            }
            output.flush();
            input.close();
            input = null;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected abstract ClickHouseHttpResponse post(String var1, InputStream var2, List<ClickHouseExternalTable> var3, Map<String, String> var4) throws IOException;

    protected boolean isReusable() {
        return true;
    }

    public abstract boolean ping(int var1);

    public ClickHouseHttpResponse update(String query) throws IOException {
        return this.post(query, null, null, null);
    }

    public ClickHouseHttpResponse update(String query, Map<String, String> headers) throws IOException {
        return this.post(query, null, null, headers);
    }

    public ClickHouseHttpResponse update(String query, InputStream data) throws IOException {
        return this.post(query, data, null, null);
    }

    public ClickHouseHttpResponse update(String query, InputStream data, Map<String, String> headers) throws IOException {
        return this.post(query, data, null, headers);
    }

    public ClickHouseHttpResponse query(String query) throws IOException {
        return this.post(query, null, null, null);
    }

    public ClickHouseHttpResponse query(String query, Map<String, String> headers) throws IOException {
        return this.post(query, null, null, headers);
    }

    public ClickHouseHttpResponse query(String query, List<ClickHouseExternalTable> tables) throws IOException {
        return this.post(query, null, tables, null);
    }

    public ClickHouseHttpResponse query(String query, List<ClickHouseExternalTable> tables, Map<String, String> headers) throws IOException {
        return this.post(query, null, tables, headers);
    }
}

