/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.UUID;

@Deprecated
public class ClickHouseIpv4Value
extends ClickHouseObjectValue<Inet4Address> {
    public static final Inet4Address DEFAULT;

    public static ClickHouseIpv4Value ofNull() {
        return ClickHouseIpv4Value.ofNull(null);
    }

    public static ClickHouseIpv4Value ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseIpv4Value ? (ClickHouseIpv4Value)((ClickHouseIpv4Value)ref).set(null) : new ClickHouseIpv4Value(null);
    }

    public static ClickHouseIpv4Value of(Inet4Address value) {
        return ClickHouseIpv4Value.of(null, value);
    }

    public static ClickHouseIpv4Value of(ClickHouseValue ref, Inet4Address value) {
        return ref instanceof ClickHouseIpv4Value ? (ClickHouseIpv4Value)((ClickHouseIpv4Value)ref).set(value) : new ClickHouseIpv4Value(value);
    }

    protected ClickHouseIpv4Value(Inet4Address value) {
        super(value);
    }

    @Override
    public ClickHouseIpv4Value copy(boolean deep) {
        return new ClickHouseIpv4Value((Inet4Address)this.getValue());
    }

    @Override
    public byte asByte() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? (byte)0 : bigInt.byteValue();
    }

    @Override
    public short asShort() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? (short)0 : bigInt.shortValue();
    }

    @Override
    public int asInteger() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? 0 : bigInt.intValue();
    }

    @Override
    public long asLong() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? 0L : bigInt.longValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNullOrEmpty() ? null : new BigInteger(1, ((Inet4Address)this.getValue()).getAddress());
    }

    @Override
    public float asFloat() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? 0.0f : bigInt.floatValue();
    }

    @Override
    public double asDouble() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? 0.0 : bigInt.doubleValue();
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? null : new BigDecimal(bigInt, scale);
    }

    @Override
    public Inet4Address asInet4Address() {
        return (Inet4Address)this.getValue();
    }

    @Override
    public Inet6Address asInet6Address() {
        return ClickHouseValues.convertToIpv6((Inet4Address)this.getValue());
    }

    @Override
    public Object asObject() {
        return this.getValue();
    }

    @Override
    public String asString() {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return String.valueOf(((Inet4Address)this.getValue()).getHostAddress());
    }

    @Override
    public ClickHouseIpv4Value resetToDefault() {
        this.set(DEFAULT);
        return this;
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        return '\'' + ((Inet4Address)this.getValue()).getHostAddress() + '\'';
    }

    @Override
    public ClickHouseIpv4Value update(byte value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseIpv4Value update(short value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseIpv4Value update(int value) {
        this.set(ClickHouseValues.convertToIpv4(value));
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(long value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseIpv4Value update(float value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseIpv4Value update(double value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseIpv4Value update(BigInteger value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(value.intValue());
        }
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(BigDecimal value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(value.intValue());
        }
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(Enum<?> value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(value.ordinal());
        }
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(Inet4Address value) {
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(Inet6Address value) {
        this.set(ClickHouseValues.convertToIpv4(value));
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(LocalDate value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update((int)value.toEpochDay());
        }
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(LocalTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(value.toSecondOfDay());
        }
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(LocalDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update((int)value.toEpochSecond(ZoneOffset.UTC));
        }
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(String value) {
        this.set(ClickHouseValues.convertToIpv4(value));
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(UUID value) {
        BigInteger v = ClickHouseValues.convertToBigInteger(value);
        if (v == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(v.intValue());
        }
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.asInet4Address());
        }
        return this;
    }

    @Override
    public ClickHouseIpv4Value update(Object value) {
        if (value instanceof Inet4Address) {
            this.set((Inet4Address)value);
        } else if (value instanceof Inet6Address) {
            this.set(ClickHouseValues.convertToIpv4((Inet6Address)value));
        } else {
            super.update(value);
        }
        return this;
    }

    static {
        try {
            DEFAULT = (Inet4Address)InetAddress.getByAddress("0.0.0.0", new byte[4]);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Failed to create default Ipv4 value", e);
        }
    }
}

