/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.ClickHouseArrayValue;
import com.clickhouse.data.value.ClickHouseObjectValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ClickHouseNestedValue
extends ClickHouseObjectValue<Object[][]> {
    private final List<ClickHouseColumn> columns;

    public static ClickHouseNestedValue ofEmpty(List<ClickHouseColumn> columns) {
        return ClickHouseNestedValue.of(null, columns, new Object[0][]);
    }

    public static ClickHouseNestedValue of(List<ClickHouseColumn> columns, Object[][] values) {
        return ClickHouseNestedValue.of(null, columns, values);
    }

    public static ClickHouseNestedValue of(ClickHouseValue ref, List<ClickHouseColumn> columns, Object[][] values) {
        return ref instanceof ClickHouseNestedValue ? ((ClickHouseNestedValue)ref).set(values != null ? values : ClickHouseValues.EMPTY_OBJECT_ARRAY2) : new ClickHouseNestedValue(columns, values);
    }

    protected static Object[][] check(List<ClickHouseColumn> columns, Object[][] value) {
        if (columns == null || value == null) {
            throw new IllegalArgumentException("Non-null columns and value are required");
        }
        int size = columns.size();
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            Object[] objs = value[i];
            if (objs != null && objs.length == size) continue;
            throw new IllegalArgumentException("Columns and values should have same length");
        }
        return value;
    }

    protected ClickHouseNestedValue(List<ClickHouseColumn> columns, Object[][] values) {
        super(ClickHouseNestedValue.check(columns, values));
        this.columns = columns;
    }

    protected Object getSingleValue() {
        Object[][] value = (Object[][])this.getValue();
        if (value == null || value.length != 1 || value[0] == null || value[0].length != 1) {
            throw new UnsupportedOperationException("Only nested object containing only one value(one column and one row) supports type conversion");
        }
        return value[0][0];
    }

    protected ClickHouseNestedValue set(Object[][] value) {
        if (this.columns == null && this.getValue() == null) {
            super.set(value);
        } else {
            super.set(ClickHouseNestedValue.check(this.columns, value));
        }
        return this;
    }

    public List<ClickHouseColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public ClickHouseNestedValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseNestedValue(this.columns, (Object[][])this.getValue());
        }
        Object[][] value = (Object[][])this.getValue();
        int len = value.length;
        Object[][] newValue = new Object[len][];
        for (int i = 0; i < len; ++i) {
            Object[] v = value[i];
            newValue[i] = Arrays.copyOf(v, v.length);
        }
        return new ClickHouseNestedValue(this.columns, newValue);
    }

    @Override
    public Object[] asArray() {
        return (Object[])this.getValue();
    }

    @Override
    public <T> T[] asArray(Class<T> clazz) {
        Object[][] v = (Object[][])this.getValue();
        Object[] array = (Object[])Array.newInstance(ClickHouseChecker.nonNull(clazz, "Class"), v.length);
        int index = 0;
        for (Object[] o : v) {
            array[index++] = clazz.cast(o);
        }
        return array;
    }

    @Override
    public Map<Object, Object> asMap() {
        Object[][] values = (Object[][])this.getValue();
        int len = values.length;
        if (len == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int size = this.columns.size();
        for (int i = 0; i < size; ++i) {
            Object[] v = new Object[len];
            for (int j = 0; j < len; ++j) {
                v[j] = values[j][i];
            }
            map.put(this.columns.get(i).getColumnName(), v);
        }
        return map;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        Class<?> compClass;
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        Object[][] values = (Object[][])this.getValue();
        int len = values.length;
        if (len == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        int size = this.columns.size();
        if (len == 1 && !valueClass.isArray()) {
            for (int i = 0; i < size; ++i) {
                map.put(keyClass.cast(this.columns.get(i).getColumnName()), valueClass.cast(values[i][0]));
            }
        } else if (!valueClass.isArray()) {
            throw new IllegalArgumentException("Value class should be array");
        }
        if ((compClass = valueClass.getComponentType()) == Object.class) {
            for (int i = 0; i < size; ++i) {
                Object[] v = new Object[len];
                for (int j = 0; j < len; ++j) {
                    v[j] = values[j][i];
                }
                map.put(keyClass.cast(this.columns.get(i).getColumnName()), valueClass.cast(v));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Object[] v = (Object[])Array.newInstance(compClass, len);
                for (int j = 0; j < len; ++j) {
                    v[j] = compClass.cast(values[j][i]);
                }
                map.put(keyClass.cast(this.columns.get(i).getColumnName()), valueClass.cast(v));
            }
        }
        return map;
    }

    @Override
    public String asString() {
        return Arrays.deepToString((Object[])this.getValue());
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isNullOrEmpty() {
        Object[][] value = (Object[][])this.getValue();
        return value == null || value.length == 0;
    }

    @Override
    public ClickHouseNestedValue resetToDefault() {
        this.set(ClickHouseValues.EMPTY_OBJECT_ARRAY2);
        return this;
    }

    @Override
    public ClickHouseNestedValue resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        Object[][] value = (Object[][])this.getValue();
        if (value == null || value.length == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        for (Object[] v : value) {
            if (v == null || v.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[');
                for (Object o : v) {
                    builder.append(ClickHouseValues.convertToSqlExpression(o)).append(',');
                }
                builder.setLength(builder.length() - 1);
                builder.append(']');
            }
            builder.append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    @Override
    public ClickHouseNestedValue update(boolean value) {
        this.set(new Object[][]{{value ? (byte)1 : 0}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(boolean[] value) {
        int len = value == null ? 0 : value.length;
        Byte[] v = new Byte[len];
        if (len > 0) {
            int index = 0;
            for (boolean b : value) {
                v[index++] = b ? (byte)1 : 0;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(char value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(char[] value) {
        int len = value == null ? 0 : value.length;
        Integer[] v = new Integer[len];
        if (len > 0) {
            int index = 0;
            for (char c : value) {
                v[index++] = c;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(byte value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(byte[] value) {
        int len = value == null ? 0 : value.length;
        Byte[] v = new Byte[len];
        if (len > 0) {
            int index = 0;
            for (byte b : value) {
                v[index++] = b;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(short value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(short[] value) {
        int len = value == null ? 0 : value.length;
        Short[] v = new Short[len];
        if (len > 0) {
            int index = 0;
            for (short s : value) {
                v[index++] = s;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(int value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(int[] value) {
        int len = value == null ? 0 : value.length;
        Integer[] v = new Integer[len];
        if (len > 0) {
            int index = 0;
            for (int i : value) {
                v[index++] = i;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(long value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(long[] value) {
        int len = value == null ? 0 : value.length;
        Long[] v = new Long[len];
        if (len > 0) {
            int index = 0;
            for (long l : value) {
                v[index++] = l;
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(float value) {
        this.set(new Object[][]{{Float.valueOf(value)}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(float[] value) {
        int len = value == null ? 0 : value.length;
        Float[] v = new Float[len];
        if (len > 0) {
            int index = 0;
            for (float f : value) {
                v[index++] = Float.valueOf(f);
            }
        }
        this.set(new Object[][]{v});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(double value) {
        this.set(new Object[][]{{value}});
        return this;
    }

    @Override
    public ClickHouseNestedValue update(double[] value) {
        int len = value == null ? 0 : value.length;
        Double[] v = new Double[len];
        if (len > 0) {
            int index = 0;
            for (double d : value) {
                v[index++] = d;
            }
        }
        return this.set(new Object[][]{v});
    }

    @Override
    public ClickHouseNestedValue update(BigInteger value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(BigDecimal value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(Enum<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(LocalDate value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(LocalTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(LocalDateTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        Object[] v = new Object[size];
        int index = 0;
        for (Object o : value) {
            v[index++] = o;
        }
        return this.set(new Object[][]{v});
    }

    @Override
    public ClickHouseNestedValue update(Enumeration<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        LinkedList v = new LinkedList();
        while (value.hasMoreElements()) {
            v.add(value.nextElement());
        }
        return this.set(new Object[][]{v.toArray(new Object[v.size()])});
    }

    @Override
    public ClickHouseNestedValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        Object[] v = new Object[size];
        int index = 0;
        for (Object o : value.values()) {
            v[index++] = o;
        }
        return this.set(new Object[][]{v});
    }

    @Override
    public ClickHouseNestedValue update(String value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof ClickHouseNestedValue) {
            this.set((Object[][])((ClickHouseNestedValue)value).getValue());
        } else {
            this.set(new Object[][]{value.asArray()});
        }
        return this;
    }

    @Override
    public ClickHouseNestedValue update(Object[] value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Object[][]) {
            this.set((Object[][])value);
        } else {
            this.set(new Object[][]{value});
        }
        return this;
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(new Object[][]{{value}});
    }

    @Override
    public ClickHouseNestedValue update(Object value) {
        if (value instanceof Object[][]) {
            this.set((Object[][])value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getValue(), (Object[])((ClickHouseArrayValue)obj).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.getValue());
    }
}

