/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import com.clickhouse.data.ClickHouseArraySequence;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.ClickHouseObjectValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;

public class ClickHouseArrayValue<T>
extends ClickHouseObjectValue<T[]>
implements ClickHouseArraySequence {
    private final T[] emptyValue;

    public static <T> ClickHouseArrayValue<T> ofEmpty() {
        return ClickHouseArrayValue.of(ClickHouseValues.EMPTY_OBJECT_ARRAY);
    }

    public static <T> ClickHouseArrayValue<T> ofEmpty(Class<T> clazz) {
        return ClickHouseArrayValue.of((Object[])Array.newInstance(clazz, new int[1]));
    }

    public static <T> ClickHouseArrayValue<T> of(T[] value) {
        return ClickHouseArrayValue.of(null, value);
    }

    public static <T> ClickHouseArrayValue<T> of(ClickHouseValue ref, T[] value) {
        return ref instanceof ClickHouseArrayValue ? ((ClickHouseArrayValue)ref).set(value) : new ClickHouseArrayValue<T>(value);
    }

    protected ClickHouseArrayValue(T[] value) {
        super(value);
        this.emptyValue = value.length == 0 ? value : (Object[])Array.newInstance(value.getClass().getComponentType(), new int[1]);
    }

    @Override
    protected ClickHouseArrayValue<T> set(T[] value) {
        super.set(ClickHouseChecker.nonNull(value, "Array"));
        return this;
    }

    @Override
    public Object[] asArray() {
        return (Object[])this.getValue();
    }

    public <E> E[] asArray(Class<E> clazz) {
        Object[] v = (Object[])this.getValue();
        Object[] array = (Object[])Array.newInstance(ClickHouseChecker.nonNull(clazz, "Class"), v.length);
        int index = 0;
        for (Object o : v) {
            array[index++] = clazz.cast(o);
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        int index = 1;
        for (Object o : (Object[])this.getValue()) {
            map.put(keyClass.cast(index++), valueClass.cast(o));
        }
        return map;
    }

    @Override
    public String asString() {
        return Arrays.deepToString((Object[])this.getValue());
    }

    @Override
    public ClickHouseArrayValue<T> copy(boolean deep) {
        if (!deep) {
            return new ClickHouseArrayValue<Object>((Object[])this.getValue());
        }
        Object[] value = (Object[])this.getValue();
        Object[] newValue = Arrays.copyOf(value, value.length);
        return new ClickHouseArrayValue<Object>(newValue);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((Object[])this.getValue()).length == 0;
    }

    @Override
    public ClickHouseArrayValue<T> resetToDefault() {
        this.set(this.emptyValue);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        int len;
        Object[] value = (Object[])this.getValue();
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder().append('[').append(ClickHouseValues.convertToSqlExpression(value[0]));
        for (int i = 1; i < len; ++i) {
            builder.append(',').append(ClickHouseValues.convertToSqlExpression(value[i]));
        }
        return builder.append(']').toString();
    }

    @Override
    public ClickHouseArrayValue<T> update(boolean[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        Object[] v = new Object[len];
        int index = 0;
        for (boolean b : value) {
            v[index++] = b ? (byte)1 : 0;
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(char[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        Object[] v = new Object[len];
        int index = 0;
        for (char c : value) {
            v[index++] = (int)c;
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(byte value) {
        this.set((Object[])new Byte[]{value});
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(byte[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        Byte[] v = new Byte[len];
        int index = 0;
        for (byte b : value) {
            v[index++] = b;
        }
        this.set((Object[])v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(short value) {
        this.set((Object[])new Short[]{value});
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(short[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        Short[] v = new Short[len];
        int index = 0;
        for (short s : value) {
            v[index++] = s;
        }
        this.set((Object[])v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(int value) {
        this.set((Object[])new Integer[]{value});
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(int[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        Integer[] v = new Integer[len];
        int index = 0;
        for (int i : value) {
            v[index++] = i;
        }
        this.set((Object[])v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(long value) {
        this.set((Object[])new Long[]{value});
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(long[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        Long[] v = new Long[len];
        int index = 0;
        for (long l : value) {
            v[index++] = l;
        }
        this.set((Object[])v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(float value) {
        this.set((Object[])new Float[]{Float.valueOf(value)});
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(float[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        Float[] v = new Float[len];
        int index = 0;
        for (float f : value) {
            v[index++] = Float.valueOf(f);
        }
        this.set((Object[])v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(double value) {
        this.set((Object[])new Double[]{value});
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(double[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        Double[] v = new Double[len];
        int index = 0;
        for (double d : value) {
            v[index++] = d;
        }
        this.set((Object[])v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(BigInteger value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set((Object[])new BigInteger[]{value});
    }

    @Override
    public ClickHouseArrayValue<T> update(BigDecimal value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set((Object[])new BigDecimal[]{value});
    }

    @Override
    public ClickHouseArrayValue<T> update(Enum<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set((Object[])new Enum[]{value});
    }

    @Override
    public ClickHouseArrayValue<T> update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set((Object[])new Inet4Address[]{value});
    }

    @Override
    public ClickHouseArrayValue<T> update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set((Object[])new Inet6Address[]{value});
    }

    @Override
    public ClickHouseArrayValue<T> update(LocalDate value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set((Object[])new LocalDate[]{value});
    }

    @Override
    public ClickHouseArrayValue<T> update(LocalTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set((Object[])new LocalTime[]{value});
    }

    @Override
    public ClickHouseArrayValue<T> update(LocalDateTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set((Object[])new LocalDateTime[]{value});
    }

    @Override
    public ClickHouseArrayValue<T> update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        Object[] v = new Object[size];
        int index = 0;
        for (Object o : value) {
            v[index++] = o;
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(Enumeration<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        LinkedList v = new LinkedList();
        while (value.hasMoreElements()) {
            v.add(value.nextElement());
        }
        this.set(v.toArray(new Object[v.size()]));
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        Object[] v = new Object[size];
        int index = 0;
        for (Map.Entry<?, ?> e : value.entrySet()) {
            v[index++] = e.getValue();
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(String value) {
        this.set((Object[])new String[]{value});
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(UUID value) {
        this.set((Object[])new UUID[]{value});
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof ClickHouseArrayValue) {
            this.set((Object[])((ClickHouseArrayValue)value).getValue());
        } else {
            this.set(value.isNullOrEmpty() ? ClickHouseValues.EMPTY_OBJECT_ARRAY : value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(Object[] value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        Object[] v = (Object[])Array.newInstance(value == null ? Object.class : value.getClass(), 1);
        v[0] = value;
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseArrayValue<T> update(Object value) {
        if (value instanceof Object[]) {
            this.set((Object[])value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getValue(), (Object[])((ClickHouseArrayValue)obj).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.getValue());
    }

    @Override
    public ClickHouseArraySequence allocate(int length, Class<?> clazz, int level) {
        if (length < 1) {
            if (!this.isNullOrEmpty() || ((Object[])this.getValue()).getClass().getComponentType() != clazz) {
                this.set(clazz.isPrimitive() ? ClickHouseValues.createPrimitiveArray(clazz, 0, level) : ClickHouseValues.createObjectArray(clazz, 0, level));
            }
        } else if (this.length() != length) {
            this.set(clazz.isPrimitive() ? ClickHouseValues.createPrimitiveArray(clazz, length, level) : ClickHouseValues.createObjectArray(clazz, length, level));
        }
        return this;
    }

    @Override
    public int length() {
        return this.isNullOrEmpty() ? 0 : ((Object[])this.getValue()).length;
    }

    @Override
    public <V extends ClickHouseValue> V getValue(int index, V value) {
        value.update(((Object[])this.getValue())[index]);
        return value;
    }

    @Override
    public ClickHouseArraySequence setValue(int index, ClickHouseValue value) {
        ((Object[])this.getValue())[index] = value.asRawObject();
        return this;
    }
}

