/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataUpdater;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.stream.AdaptiveQueue;
import com.clickhouse.data.stream.CapacityPolicy;
import com.clickhouse.data.stream.NonBlockingInputStream;
import java.io.IOException;

public class NonBlockingPipedOutputStream
extends ClickHousePipedOutputStream {
    protected final AdaptiveQueue<byte[]> queue;
    protected final int bufferSize;
    protected final int timeout;
    protected final byte[][] buckets;
    protected int current;
    protected byte[] buffer;
    protected int position;

    private byte[] allocateBuffer() {
        byte[] b;
        this.position = 0;
        if (this.buckets.length - this.queue.size() > 1) {
            b = this.buckets[this.current];
            if (b == null) {
                b = new byte[this.bufferSize];
                this.buckets[this.current] = b;
            }
            if (++this.current >= this.buckets.length) {
                this.current = 0;
            }
        } else {
            b = new byte[this.bufferSize];
        }
        return b;
    }

    private void updateBuffer(boolean allocateNewBuffer) throws IOException {
        this.updateBuffer(this.buffer, 0, this.position);
        if (allocateNewBuffer) {
            this.buffer = this.allocateBuffer();
        } else {
            this.position = 0;
        }
    }

    private void updateBuffer(byte[] bytes, int offset, int length) throws IOException {
        long startTime;
        byte[] b;
        if (length < this.buffer.length) {
            b = new byte[length];
            System.arraycopy(bytes, offset, b, 0, length);
        } else {
            b = bytes;
        }
        AdaptiveQueue<byte[]> q = this.queue;
        long t = this.timeout;
        long l = startTime = t < 1L ? 0L : System.currentTimeMillis();
        while (!q.offer(b)) {
            if (t <= 0L || System.currentTimeMillis() - startTime < t) continue;
            throw new IOException(ClickHouseUtils.format("Write timed out after %d ms", t));
        }
    }

    public NonBlockingPipedOutputStream(int bufferSize, int queueLength, int timeout, CapacityPolicy policy, Runnable postCloseAction) {
        super(postCloseAction);
        this.queue = AdaptiveQueue.create(policy, new byte[0][]);
        this.bufferSize = ClickHouseDataConfig.getBufferSize(bufferSize);
        this.timeout = timeout;
        this.buckets = queueLength < 2 ? new byte[][]{} : new byte[queueLength][];
        this.current = queueLength < 2 ? -1 : 0;
        this.buffer = this.allocateBuffer();
    }

    @Override
    public ClickHouseInputStream getInputStream(Runnable postCloseAction) {
        return new NonBlockingInputStream(this.queue, this.timeout, postCloseAction);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.position > 0) {
                this.updateBuffer(false);
            }
            this.buffer = ClickHouseByteBuffer.EMPTY_BYTES;
            this.queue.add(ClickHouseByteBuffer.EMPTY_BYTES);
        }
        catch (Throwable throwable) {
            this.buffer = ClickHouseByteBuffer.EMPTY_BYTES;
            this.queue.add(ClickHouseByteBuffer.EMPTY_BYTES);
            int len = this.buckets.length;
            for (int i = 0; i < len; ++i) {
                this.buckets[i] = null;
            }
            this.closed = true;
            if (this.postCloseAction != null) {
                this.postCloseAction.run();
            }
            throw throwable;
        }
        int len = this.buckets.length;
        for (int i = 0; i < len; ++i) {
            this.buckets[i] = null;
        }
        this.closed = true;
        if (this.postCloseAction != null) {
            this.postCloseAction.run();
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.position > 0) {
            this.updateBuffer(true);
        }
    }

    @Override
    public ClickHouseOutputStream transferBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        if (this.position > 0) {
            this.updateBuffer(true);
        }
        this.updateBuffer(bytes, offset, length);
        return this;
    }

    @Override
    public ClickHouseOutputStream writeByte(byte b) throws IOException {
        this.ensureOpen();
        this.buffer[this.position++] = b;
        if (this.position >= this.buffer.length) {
            this.updateBuffer(true);
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        while (length > 0) {
            int limit = this.buffer.length;
            int remain = limit - this.position;
            if (length < remain) {
                System.arraycopy(bytes, offset, this.buffer, this.position, length);
                this.position += length;
                length = 0;
                continue;
            }
            System.arraycopy(bytes, offset, this.buffer, this.position, remain);
            this.position = limit;
            offset += remain;
            length -= remain;
            this.updateBuffer(true);
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeCustom(ClickHouseDataUpdater writer) throws IOException {
        this.ensureOpen();
        int written = 0;
        while ((written = writer.update(this.buffer, this.position, this.buffer.length)) < 0) {
            this.position = this.buffer.length;
            this.updateBuffer(true);
        }
        this.position += written;
        return this;
    }
}

