/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.stream.AbstractByteBufferInputStream;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingInputStream
extends AbstractByteBufferInputStream {
    private static final Logger log = LoggerFactory.getLogger(BlockingInputStream.class);
    private final BlockingQueue<ByteBuffer> queue;
    private final int timeout;

    public BlockingInputStream(BlockingQueue<ByteBuffer> queue, int timeout, Runnable postCloseAction) {
        super(null, null, postCloseAction);
        this.queue = ClickHouseChecker.nonNull(queue, "Queue");
        this.timeout = timeout > 0 ? timeout : 0;
    }

    @Override
    protected int updateBuffer() throws IOException {
        try {
            ByteBuffer b;
            if (this.timeout > 0) {
                b = this.queue.poll(this.timeout, TimeUnit.MILLISECONDS);
                if (b == null) {
                    throw new IOException(ClickHouseUtils.format("Read timed out after %d ms", this.timeout));
                }
            } else {
                b = this.queue.take();
            }
            this.buffer = b;
            int remain = b.remaining();
            if (remain > 0 && this.copyTo != null) {
                int position = b.position();
                if (b.hasArray()) {
                    this.copyTo.write(b.array(), position, remain);
                } else {
                    byte[] bytes = new byte[remain];
                    b.get(bytes);
                    this.copyTo.write(bytes);
                    ((Buffer)b).position(position);
                }
            }
            return remain;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when getting next buffer from queue", e);
        }
    }
}

