/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.config.ClickHouseBufferingMode;
import com.clickhouse.config.ClickHouseRenameMethod;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseFormat;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.TimeZone;

public interface ClickHouseDataConfig
extends Serializable {
    public static final String TYPE_NAME = "DataConfig";
    public static final boolean DEFAULT_ASYNC = true;
    public static final ClickHouseBufferingMode DEFAULT_BUFFERING_MODE = ClickHouseBufferingMode.RESOURCE_EFFICIENT;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_READ_BUFFER_SIZE = 4096;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 4096;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 131072;
    public static final int DEFAULT_MAX_QUEUED_BUFFERS = 512;
    public static final int DEFAULT_BUFFER_QUEUE_VARIATION = 100;
    public static final ClickHouseRenameMethod DEFAULT_COLUMN_RENAME_METHOD = ClickHouseRenameMethod.NONE;
    public static final ClickHouseFormat DEFAULT_FORMAT = ClickHouseFormat.TabSeparated;
    public static final boolean DEFAULT_REUSE_VALUE_WRAPPER = true;
    public static final boolean DEFAULT_USE_BINARY_STRING = false;
    public static final boolean DEFAULT_USE_BLOCKING_QUEUE = false;
    public static final boolean DEFAULT_USE_OBJECT_IN_ARRAY = false;
    public static final boolean DEFAULT_WIDEN_UNSIGNED_TYPE = false;
    public static final int DEFAULT_READ_COMPRESS_LEVEL = -1;
    public static final int DEFAULT_WRITE_COMPRESS_LEVEL = -1;
    public static final int DEFAULT_TIMEOUT = 30000;
    public static final RoundingMode DEFAULT_ROUNDING_MODE = RoundingMode.DOWN;

    public static int getBufferSize(int bufferSize) {
        return ClickHouseDataConfig.getBufferSize(bufferSize, 4096, 131072);
    }

    public static int getBufferSize(int bufferSize, int defaultSize, int maxSize) {
        if (maxSize < 1 || maxSize > 131072) {
            maxSize = 131072;
        }
        if (defaultSize < 1) {
            defaultSize = 4096;
        } else if (defaultSize > maxSize) {
            defaultSize = maxSize;
        }
        if (bufferSize < 1) {
            return defaultSize;
        }
        return bufferSize > maxSize ? maxSize : bufferSize;
    }

    public static int getDefaultReadBufferSize() {
        return ClickHouseDataConfig.getBufferSize(4096, 4096, 131072);
    }

    default public ClickHouseFormat getFormat() {
        return DEFAULT_FORMAT;
    }

    default public int getBufferQueueVariation() {
        return 100;
    }

    default public int getBufferSize() {
        return 4096;
    }

    default public int getMaxBufferSize() {
        return 131072;
    }

    default public int getReadBufferSize() {
        return 4096;
    }

    default public int getWriteBufferSize() {
        return 4096;
    }

    default public int getMaxQueuedBuffers() {
        return 512;
    }

    default public ClickHouseBufferingMode getReadBufferingMode() {
        return DEFAULT_BUFFERING_MODE;
    }

    default public ClickHouseBufferingMode getWriteBufferingMode() {
        return DEFAULT_BUFFERING_MODE;
    }

    default public ClickHouseRenameMethod getColumnRenameMethod() {
        return DEFAULT_COLUMN_RENAME_METHOD;
    }

    default public boolean isAsync() {
        return true;
    }

    default public boolean isReuseValueWrapper() {
        return true;
    }

    default public boolean isUseBinaryString() {
        return false;
    }

    default public boolean isUseBlockingQueue() {
        return false;
    }

    default public boolean isUseObjectsInArray() {
        return false;
    }

    default public boolean isWidenUnsignedTypes() {
        return false;
    }

    default public int getReadTimeout() {
        return 30000;
    }

    default public int getWriteTimeout() {
        return 30000;
    }

    public TimeZone getTimeZoneForDate();

    public TimeZone getUseTimeZone();

    public static class Wrapped
    implements ClickHouseDataConfig {
        private static final long serialVersionUID = -8358244156373920188L;
        private final ClickHouseDataConfig config;

        public Wrapped(ClickHouseDataConfig config) {
            this.config = ClickHouseChecker.nonNull(config, ClickHouseDataConfig.TYPE_NAME);
        }

        @Override
        public ClickHouseFormat getFormat() {
            return this.config.getFormat();
        }

        @Override
        public int getBufferQueueVariation() {
            return this.config.getBufferQueueVariation();
        }

        @Override
        public int getBufferSize() {
            return this.config.getBufferSize();
        }

        @Override
        public int getMaxBufferSize() {
            return this.config.getMaxBufferSize();
        }

        @Override
        public int getReadBufferSize() {
            return this.config.getReadBufferSize();
        }

        @Override
        public int getWriteBufferSize() {
            return this.config.getWriteBufferSize();
        }

        @Override
        public int getReadTimeout() {
            return this.config.getReadTimeout();
        }

        @Override
        public int getWriteTimeout() {
            return this.config.getWriteTimeout();
        }

        @Override
        public ClickHouseBufferingMode getReadBufferingMode() {
            return this.config.getReadBufferingMode();
        }

        @Override
        public ClickHouseBufferingMode getWriteBufferingMode() {
            return this.config.getWriteBufferingMode();
        }

        @Override
        public ClickHouseRenameMethod getColumnRenameMethod() {
            return this.config.getColumnRenameMethod();
        }

        @Override
        public int getMaxQueuedBuffers() {
            return this.config.getMaxQueuedBuffers();
        }

        @Override
        public TimeZone getTimeZoneForDate() {
            return this.config.getTimeZoneForDate();
        }

        @Override
        public TimeZone getUseTimeZone() {
            return this.config.getUseTimeZone();
        }

        @Override
        public boolean isReuseValueWrapper() {
            return this.config.isReuseValueWrapper();
        }

        @Override
        public boolean isUseBinaryString() {
            return this.config.isUseBinaryString();
        }

        @Override
        public boolean isUseBlockingQueue() {
            return this.config.isUseBlockingQueue();
        }

        @Override
        public boolean isUseObjectsInArray() {
            return this.config.isUseObjectsInArray();
        }

        @Override
        public boolean isWidenUnsignedTypes() {
            return this.config.isWidenUnsignedTypes();
        }
    }
}

