/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseClientBuilder;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseNodes;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.config.ClickHouseBufferingMode;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseFile;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.ClickHouseWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public interface ClickHouseClient
extends AutoCloseable {
    public static ClickHouseClientBuilder builder() {
        return new ClickHouseClientBuilder();
    }

    public static ExecutorService getExecutorService() {
        return ClickHouseDataStreamFactory.getInstance().getExecutor();
    }

    public static ClickHouseOutputStream getRequestOutputStream(ClickHouseConfig config, OutputStream output, Runnable postCloseAction) {
        if (config == null) {
            return ClickHouseOutputStream.of((OutputStream)output, (int)((Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue()), (ClickHouseCompression)ClickHouseCompression.NONE, (int)-1, (Runnable)postCloseAction);
        }
        return ClickHouseOutputStream.of((OutputStream)output, (int)config.getWriteBufferSize(), (ClickHouseCompression)config.getRequestCompressAlgorithm(), (int)config.getRequestCompressLevel(), (Runnable)postCloseAction);
    }

    public static ClickHouseOutputStream getAsyncRequestOutputStream(ClickHouseConfig config, OutputStream output, Runnable postCloseAction) {
        if (config == null || !config.isAsync() || config.getRequestBuffering() == ClickHouseBufferingMode.RESOURCE_EFFICIENT) {
            return ClickHouseClient.getRequestOutputStream(config, output, postCloseAction);
        }
        CountDownLatch latch = new CountDownLatch(1);
        ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream((ClickHouseDataConfig)config, () -> {
            try {
                latch.await();
                if (postCloseAction != null) {
                    postCloseAction.run();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Stopped waiting for writes", e);
            }
        });
        ClickHouseClient.submit(() -> {
            try (ClickHouseInputStream in = stream.getInputStream();
                 ClickHouseOutputStream out = ClickHouseClient.getRequestOutputStream(config, output, postCloseAction);){
                in.pipe(out);
            }
            finally {
                latch.countDown();
            }
            return null;
        });
        return stream;
    }

    public static ClickHouseInputStream getResponseInputStream(ClickHouseConfig config, InputStream input, Runnable postCloseAction) {
        if (config == null) {
            return ClickHouseInputStream.of((InputStream)input, (int)ClickHouseDataConfig.getDefaultReadBufferSize(), (ClickHouseCompression)ClickHouseCompression.NONE, (int)-1, (Runnable)postCloseAction);
        }
        return ClickHouseInputStream.of((InputStream)input, (int)config.getReadBufferSize(), (ClickHouseCompression)config.getResponseCompressAlgorithm(), (int)config.getResponseCompressLevel(), (Runnable)postCloseAction);
    }

    public static ClickHouseInputStream getAsyncResponseInputStream(ClickHouseConfig config, InputStream input, Runnable postCloseAction) {
        ClickHouseInputStream wrappedInput;
        if (config == null || !config.isAsync() || config.getResponseBuffering() == ClickHouseBufferingMode.RESOURCE_EFFICIENT) {
            return ClickHouseClient.getResponseInputStream(config, input, postCloseAction);
        }
        ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream((ClickHouseDataConfig)config);
        if (config.isResponseCompressed()) {
            ClickHousePipedOutputStream decompressedStream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream((ClickHouseDataConfig)config);
            wrappedInput = ClickHouseClient.getResponseInputStream(config, (InputStream)decompressedStream.getInputStream(), postCloseAction);
            ClickHouseClient.submit(() -> {
                try (ClickHouseInputStream in = ClickHouseInputStream.of((InputStream)input, (int)config.getReadBufferSize(), (ClickHouseCompression)config.getResponseCompressAlgorithm(), (int)config.getResponseCompressLevel(), null);
                     ClickHousePipedOutputStream out = decompressedStream;){
                    in.pipe((ClickHouseOutputStream)out);
                }
                return null;
            });
        } else {
            wrappedInput = ClickHouseClient.getResponseInputStream(config, input, postCloseAction);
        }
        ClickHouseClient.submit(() -> {
            try (ClickHouseInputStream in = wrappedInput;
                 ClickHousePipedOutputStream out = stream;){
                in.pipe((ClickHouseOutputStream)out);
            }
            return null;
        });
        return stream.getInputStream();
    }

    public static <T> T run(Callable<T> task) {
        try {
            return task.call();
        }
        catch (ClickHouseException e) {
            throw new CompletionException(e);
        }
        catch (CompletionException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof CompletionException) {
                throw (CompletionException)cause;
            }
            if (cause == null) {
                cause = e;
            }
            throw new CompletionException(cause);
        }
    }

    public static void run(Runnable task) {
        try {
            task.run();
        }
        catch (CompletionException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable cause;
            Throwable throwable = cause = e instanceof ClickHouseException ? e : e.getCause();
            if (cause instanceof CompletionException) {
                throw (CompletionException)cause;
            }
            if (cause == null) {
                cause = e;
            }
            throw new CompletionException(cause);
        }
    }

    public static <T> CompletableFuture<T> submit(Callable<T> task) {
        return (Boolean)ClickHouseDefaults.ASYNC.getEffectiveDefaultValue() != false ? CompletableFuture.supplyAsync(() -> ClickHouseClient.run(task), ClickHouseClient.getExecutorService()) : CompletableFuture.completedFuture(ClickHouseClient.run(task));
    }

    public static CompletableFuture<Void> submit(Runnable task) {
        if (((Boolean)ClickHouseDefaults.ASYNC.getEffectiveDefaultValue()).booleanValue()) {
            return CompletableFuture.runAsync(() -> ClickHouseClient.run(task), ClickHouseClient.getExecutorService());
        }
        ClickHouseClient.run(task);
        return ClickHouseUtils.NULL_FUTURE;
    }

    public static CompletableFuture<ClickHouseResponseSummary> dump(ClickHouseNode server, String tableOrQuery, ClickHousePassThruStream stream) {
        if (server == null || tableOrQuery == null || stream == null) {
            throw new IllegalArgumentException("Non-null server, tableOrQuery, and pass-thru stream are required");
        }
        ClickHouseNode theServer = server.probe();
        String theQuery = tableOrQuery.trim();
        return ClickHouseClient.submit(() -> {
            try (ClickHouseClient client = ClickHouseClient.newInstance(theServer.getProtocol());){
                Object request = client.read(theServer).output(stream);
                if (theQuery.indexOf(32) < 0) {
                    ((ClickHouseRequest)request).table(theQuery);
                } else {
                    ((ClickHouseRequest)request).query(theQuery);
                }
                ClickHouseResponse response = ((ClickHouseRequest)request).executeAndWait();
                try {
                    ClickHouseResponseSummary clickHouseResponseSummary = response.getSummary();
                    if (response != null) {
                        response.close();
                    }
                    return clickHouseResponseSummary;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> dump(ClickHouseNode server, String tableOrQuery, String file, ClickHouseCompression compression, ClickHouseFormat format) {
        return ClickHouseClient.dump(server, tableOrQuery, (ClickHousePassThruStream)ClickHouseFile.of((String)file, (ClickHouseCompression)compression, (ClickHouseFormat)format));
    }

    public static CompletableFuture<ClickHouseResponseSummary> dump(ClickHouseNode server, String tableOrQuery, OutputStream output, ClickHouseCompression compression, ClickHouseFormat format) {
        if (server == null || tableOrQuery == null || output == null) {
            throw new IllegalArgumentException("Non-null server, tableOrQuery, and output are required");
        }
        ClickHouseNode theServer = server.probe();
        String theQuery = tableOrQuery.trim();
        return ClickHouseClient.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, ClickHousePassThruStream stream) {
        if (server == null || table == null || stream == null) {
            throw new IllegalArgumentException("Non-null server, table, and pass-thru stream are required");
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            try (ClickHouseClient client = ClickHouseClient.newInstance(theServer.getProtocol());){
                ClickHouseResponse response = ((ClickHouseRequest.Mutation)client.write(theServer).table(table)).data(stream).executeAndWait();
                try {
                    ClickHouseResponseSummary clickHouseResponseSummary = response.getSummary();
                    if (response != null) {
                        response.close();
                    }
                    return clickHouseResponseSummary;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, ClickHouseWriter writer, ClickHouseCompression compression, ClickHouseFormat format) {
        if (server == null || table == null || writer == null) {
            throw new IllegalArgumentException("Non-null server, table, and custom writer are required");
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            try (ClickHouseClient client = ClickHouseClient.newInstance(theServer.getProtocol());){
                ClickHouseResponse response = ((ClickHouseRequest.Mutation)((ClickHouseRequest.Mutation)client.write(theServer).table(table)).data(writer).decompressClientRequest(compression)).format(format).executeAndWait();
                try {
                    ClickHouseResponseSummary clickHouseResponseSummary = response.getSummary();
                    if (response != null) {
                        response.close();
                    }
                    return clickHouseResponseSummary;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, String file, ClickHouseCompression compression, ClickHouseFormat format) {
        return ClickHouseClient.load(server, table, (ClickHousePassThruStream)ClickHouseFile.of((String)file, (ClickHouseCompression)compression, (ClickHouseFormat)format));
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, InputStream input, ClickHouseCompression compression, ClickHouseFormat format) {
        if (server == null || table == null || input == null) {
            throw new IllegalArgumentException("Non-null server, table, and input are required");
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public static ClickHouseClient newInstance(ClickHouseProtocol ... preferredProtocols) {
        return ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(null, preferredProtocols)).build();
    }

    public static ClickHouseClient newInstance(ClickHouseCredentials defaultCredentials, ClickHouseProtocol ... preferredProtocols) {
        return ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(null, preferredProtocols)).defaultCredentials(defaultCredentials).build();
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, String ... more) {
        if (server == null || sql == null || more == null) {
            throw new IllegalArgumentException("Non-null server and sql are required");
        }
        ClickHouseNode theServer = server.probe();
        ArrayList<String> queries = new ArrayList<String>(more.length + 1);
        if (!ClickHouseChecker.isNullOrBlank((CharSequence)sql)) {
            queries.add(sql);
        }
        for (String query : more) {
            if (ClickHouseChecker.isNullOrBlank((CharSequence)query)) continue;
            queries.add(query);
        }
        if (queries.isEmpty()) {
            throw new IllegalArgumentException("At least one non-blank query is required");
        }
        return ClickHouseClient.submit(() -> {
            ArrayList<ClickHouseResponseSummary> list = new ArrayList<ClickHouseResponseSummary>(queries.size());
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                Object request = client.read(theServer).format(ClickHouseFormat.RowBinary);
                if (((Boolean)ClickHouseDefaults.AUTO_SESSION.getEffectiveDefaultValue()).booleanValue() && queries.size() > 1) {
                    ((ClickHouseRequest)request).session(((ClickHouseRequest)request).getManager().createSessionId(), false);
                }
                for (String query : queries) {
                    ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)request).query(query)).executeAndWait();
                    try {
                        list.add(resp.getSummary());
                    }
                    finally {
                        if (resp == null) continue;
                        resp.close();
                    }
                }
            }
            return list;
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> send(ClickHouseNode server, String sql, Map<String, String> params) {
        if (server == null || sql == null || params == null) {
            throw new IllegalArgumentException("Non-null server, sql and parameters are required");
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)client.read(theServer).format(ClickHouseFormat.RowBinary)).query(sql)).params(params)).executeAndWait();
                try {
                    ClickHouseResponseSummary clickHouseResponseSummary = resp.getSummary();
                    if (resp != null) {
                        resp.close();
                    }
                    return clickHouseResponseSummary;
                }
                catch (Throwable throwable) {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        });
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, List<ClickHouseColumn> columns, Object[] ... params) {
        int len;
        int n = len = columns == null ? 0 : columns.size();
        if (len == 0) {
            throw new IllegalArgumentException("Non-empty column list is required");
        }
        ClickHouseConfig config = new ClickHouseConfig(new ClickHouseConfig[0]);
        ClickHouseValue[] templates = new ClickHouseValue[len];
        int index = 0;
        for (ClickHouseColumn column : columns) {
            templates[index++] = ((ClickHouseColumn)ClickHouseChecker.nonNull((Object)column, (String)"Column")).newValue((ClickHouseDataConfig)config);
        }
        return ClickHouseClient.send(server, sql, templates, params);
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, ClickHouseValue[] templates, Object[] ... params) {
        int size;
        int len = templates != null ? templates.length : 0;
        int n = size = params != null ? params.length : 0;
        if (len == 0 || size == 0) {
            throw new IllegalArgumentException("Non-empty templates and parameters are required");
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            ArrayList<ClickHouseResponseSummary> list = new ArrayList<ClickHouseResponseSummary>(size);
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                Object request = ((ClickHouseRequest)client.read(theServer).format(ClickHouseFormat.RowBinary)).query(sql);
                for (int i = 0; i < size; ++i) {
                    int olen;
                    Object[] o = params[i];
                    String[] arr = new String[len];
                    int n = olen = o == null ? 0 : o.length;
                    for (int j = 0; j < len; ++j) {
                        ClickHouseValue v = templates[j];
                        arr[j] = j < olen ? (v != null ? v.update(o[j]).toSqlExpression() : ClickHouseValues.convertToSqlExpression((Object)o[j])) : (v != null ? v.resetToNullOrEmpty().toSqlExpression() : "NULL");
                    }
                    try (ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)request).params(arr)).executeAndWait();){
                        list.add(resp.getSummary());
                        continue;
                    }
                }
            }
            return list;
        });
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, String[][] params) {
        if (server == null || sql == null || params == null) {
            throw new IllegalArgumentException("Non-null server, sql, and parameters are required");
        }
        if (params.length == 0) {
            return ClickHouseClient.send(server, sql, new String[0]);
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            ArrayList<ClickHouseResponseSummary> list = new ArrayList<ClickHouseResponseSummary>(params.length);
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                Object request = client.read(theServer).format(ClickHouseFormat.RowBinary);
                ClickHouseParameterizedQuery query = ClickHouseParameterizedQuery.of(((ClickHouseRequest)request).getConfig(), sql);
                StringBuilder builder = new StringBuilder();
                for (String[] p : params) {
                    builder.setLength(0);
                    query.apply(builder, p);
                    try (ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)request).query(builder.toString())).executeAndWait();){
                        list.add(resp.getSummary());
                    }
                }
            }
            return list;
        });
    }

    default public boolean accept(ClickHouseProtocol protocol) {
        return protocol == null || protocol == ClickHouseProtocol.ANY;
    }

    default public ClickHouseRequest<?> read(String endpoints) {
        return this.read(ClickHouseNodes.of(endpoints));
    }

    default public ClickHouseRequest<?> read(ClickHouseNodes nodes) {
        return this.read(nodes, nodes.template.config.getAllOptions());
    }

    default public ClickHouseRequest<?> read(ClickHouseNode node) {
        return this.read(node, node.config.getAllOptions());
    }

    default public ClickHouseRequest<?> read(Function<ClickHouseNodeSelector, ClickHouseNode> nodeFunc, Map<ClickHouseOption, Serializable> options) {
        return new ClickHouseRequest(this, (Function)ClickHouseChecker.nonNull(nodeFunc, (String)"Node"), null, options, false);
    }

    default public ClickHouseRequest.Mutation write(ClickHouseNode node) {
        return this.read(node).write();
    }

    public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> var1);

    default public ClickHouseResponse executeAndWait(ClickHouseRequest<?> request) throws ClickHouseException {
        ClickHouseRequest<?> sealedRequest = request.seal();
        try {
            return this.execute(sealedRequest).get(sealedRequest.getConfig().getSocketTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ClickHouseException.forCancellation(e, sealedRequest.getServer());
        }
        catch (CancellationException e) {
            throw ClickHouseException.forCancellation(e, sealedRequest.getServer());
        }
        catch (UncheckedIOException | CompletionException | ExecutionException | TimeoutException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw cause instanceof ClickHouseException ? (ClickHouseException)cause : ClickHouseException.of(cause, sealedRequest.getServer());
        }
        catch (RuntimeException e) {
            throw ClickHouseException.of(e, sealedRequest.getServer());
        }
    }

    public ClickHouseConfig getConfig();

    default public Class<? extends ClickHouseOption> getOptionClass() {
        return null;
    }

    default public void init(ClickHouseConfig config) {
        ClickHouseChecker.nonNull((Object)config, (String)"Config");
    }

    default public boolean ping(ClickHouseNode server, int timeout) {
        if (server != null) {
            if (timeout < 1) {
                timeout = server.config.getConnectionTimeout();
            }
            if (server.getProtocol() == ClickHouseProtocol.ANY) {
                server = ClickHouseNode.probe(server.getHost(), server.getPort(), timeout);
            }
            ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)this.read(server).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false))).option(ClickHouseClientOption.CONNECTION_TIMEOUT, Integer.valueOf(timeout))).option(ClickHouseClientOption.SOCKET_TIMEOUT, Integer.valueOf(timeout))).option(ClickHouseClientOption.BUFFER_SIZE, Integer.valueOf(8))).option(ClickHouseClientOption.MAX_QUEUED_BUFFERS, Integer.valueOf(1))).format(ClickHouseFormat.TabSeparated)).query("SELECT 1 FORMAT TabSeparated")).execute().get(timeout, TimeUnit.MILLISECONDS);
            try {
                boolean bl;
                boolean bl2 = bl = resp != null;
                if (resp != null) {
                    resp.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public void close();
}

