/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.config;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.data.ClickHouseUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ClickHouseDefaultSslContextProvider
implements ClickHouseSslContextProvider {
    static final String PEM_BEGIN_PART1 = "---BEGIN ";
    static final String PEM_BEGIN_PART2 = " PRIVATE KEY---";

    protected KeyStore getKeyStore(String cert, String key) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, CertificateException, KeyStoreException {
        KeyStore ks;
        block19: {
            try {
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, null);
            }
            catch (KeyStoreException e) {
                throw new NoSuchAlgorithmException(ClickHouseUtils.format((String)"%s KeyStore not available", (Object[])new Object[]{KeyStore.getDefaultType()}));
            }
            try (InputStream in = ClickHouseUtils.getFileInputStream((String)cert);){
                CertificateFactory factory = CertificateFactory.getInstance((String)((Object)ClickHouseDefaults.SSL_CERTIFICATE_TYPE.getEffectiveDefaultValue()));
                if (key == null || key.isEmpty()) {
                    int index = 1;
                    for (Certificate certificate : factory.generateCertificates(in)) {
                        ks.setCertificateEntry("cert" + index++, certificate);
                    }
                    break block19;
                }
                String algorithm = (String)((Object)ClickHouseDefaults.SSL_KEY_ALGORITHM.getEffectiveDefaultValue());
                StringBuilder builder = new StringBuilder();
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ClickHouseUtils.getFileInputStream((String)key)));){
                    String str;
                    boolean started = false;
                    while ((str = bufferedReader.readLine()) != null) {
                        if (!started) {
                            int endIndex;
                            int startIndex = str.indexOf(PEM_BEGIN_PART1);
                            int n = endIndex = startIndex < 0 ? -1 : str.indexOf(PEM_BEGIN_PART2, startIndex += PEM_BEGIN_PART1.length() - 1);
                            if (startIndex < endIndex) {
                                algorithm = str.substring(startIndex, endIndex);
                            }
                            started = true;
                            continue;
                        }
                        if (str.indexOf("---END ") < 0) {
                            builder.append(str);
                            continue;
                        }
                        break;
                    }
                }
                byte[] byArray = Base64.getDecoder().decode(builder.toString());
                KeyFactory kf = KeyFactory.getInstance(algorithm);
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(byArray);
                Certificate[] certChain = factory.generateCertificates(in).toArray(new Certificate[0]);
                ks.setKeyEntry("key", kf.generatePrivate(keySpec), null, certChain);
            }
        }
        return ks;
    }

    protected SSLContext getJavaSslContext(ClickHouseConfig config) throws SSLException {
        SSLContext ctx;
        ClickHouseSslMode sslMode = config.getSslMode();
        String clientCert = config.getSslCert();
        String clientKey = config.getSslKey();
        String sslRootCert = config.getSslRootCert();
        try {
            ctx = SSLContext.getInstance((String)((Object)ClickHouseDefaults.SSL_PROTOCOL.getEffectiveDefaultValue()));
            TrustManager[] tms = null;
            KeyManager[] kms = null;
            SecureRandom sr = null;
            if (sslMode == ClickHouseSslMode.NONE) {
                tms = new TrustManager[]{new NonValidatingTrustManager()};
                kms = new KeyManager[]{};
                sr = new SecureRandom();
            } else if (sslMode == ClickHouseSslMode.STRICT) {
                Object factory;
                if (clientCert != null && !clientCert.isEmpty()) {
                    factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    ((KeyManagerFactory)factory).init(this.getKeyStore(clientCert, clientKey), null);
                    kms = ((KeyManagerFactory)factory).getKeyManagers();
                }
                if (sslRootCert != null && !sslRootCert.isEmpty()) {
                    factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    ((TrustManagerFactory)factory).init(this.getKeyStore(sslRootCert, null));
                    tms = ((TrustManagerFactory)factory).getTrustManagers();
                }
                sr = new SecureRandom();
            } else {
                throw new IllegalArgumentException(ClickHouseUtils.format((String)"unspported ssl mode '%s'", (Object[])new Object[]{sslMode}));
            }
            ctx.init(kms, tms, sr);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            throw new SSLException("Failed to get SSL context", e);
        }
        return ctx;
    }

    @Override
    public <T> Optional<T> getSslContext(Class<? extends T> sslContextClass, ClickHouseConfig config) throws SSLException {
        return SSLContext.class == sslContextClass ? Optional.of(this.getJavaSslContext(config)) : Optional.empty();
    }

    static class NonValidatingTrustManager
    implements X509TrustManager {
        NonValidatingTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

