/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClientBuilder;
import com.clickhouse.client.ClickHouseCluster;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.ClickHouseWriter;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseOption;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public interface ClickHouseClient
extends AutoCloseable {
    public static ClickHouseClientBuilder builder() {
        return new ClickHouseClientBuilder();
    }

    public static ExecutorService getExecutorService() {
        return ClickHouseClientBuilder.defaultExecutor;
    }

    public static <T> CompletableFuture<T> submit(Callable<T> task) {
        try {
            return (Boolean)ClickHouseDefaults.ASYNC.getEffectiveDefaultValue() != false ? CompletableFuture.supplyAsync(() -> {
                try {
                    return task.call();
                }
                catch (CompletionException e) {
                    throw e;
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CompletionException) {
                        throw (CompletionException)cause;
                    }
                    if (cause == null) {
                        cause = e;
                    }
                    throw new CompletionException(cause);
                }
            }, ClickHouseClient.getExecutorService()) : CompletableFuture.completedFuture(task.call());
        }
        catch (CompletionException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof CompletionException) {
                throw (CompletionException)cause;
            }
            if (cause == null) {
                cause = e;
            }
            throw new CompletionException(cause);
        }
    }

    public static CompletableFuture<ClickHouseResponseSummary> dump(ClickHouseNode server, String tableOrQuery, ClickHouseFormat format, ClickHouseCompression compression, String file) throws IOException {
        return ClickHouseClient.dump(server, tableOrQuery, format, compression, ClickHouseUtils.getFileOutputStream(file));
    }

    public static CompletableFuture<ClickHouseResponseSummary> dump(ClickHouseNode server, String tableOrQuery, ClickHouseFormat format, ClickHouseCompression compression, OutputStream output) {
        if (server == null || tableOrQuery == null || output == null) {
            throw new IllegalArgumentException("Non-null server, tableOrQuery, and output are required");
        }
        ClickHouseNode theServer = ClickHouseCluster.probe(server);
        String theQuery = tableOrQuery.trim();
        return ClickHouseClient.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, ClickHouseFormat format, ClickHouseCompression compression, String file) throws FileNotFoundException {
        return ClickHouseClient.load(server, table, format, compression, ClickHouseUtils.getFileInputStream(file));
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, ClickHouseFormat format, ClickHouseCompression compression, ClickHouseWriter writer) {
        if (server == null || table == null || writer == null) {
            throw new IllegalArgumentException("Non-null server, table, and writer are required");
        }
        ClickHouseNode theServer = ClickHouseCluster.probe(server);
        return ClickHouseClient.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, ClickHouseFormat format, ClickHouseCompression compression, InputStream input) {
        if (server == null || table == null || input == null) {
            throw new IllegalArgumentException("Non-null server, table, and input are required");
        }
        ClickHouseNode theServer = ClickHouseCluster.probe(server);
        return ClickHouseClient.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public static ClickHouseClient newInstance(ClickHouseProtocol ... preferredProtocols) {
        return ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(null, preferredProtocols)).build();
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, String ... more) {
        if (server == null || sql == null) {
            throw new IllegalArgumentException("Non-null server and sql are required");
        }
        ClickHouseNode theServer = ClickHouseCluster.probe(server);
        LinkedList<String> queries = new LinkedList<String>();
        queries.add(sql);
        if (more != null && more.length > 0) {
            for (String query : more) {
                queries.add(ClickHouseChecker.nonNull(query, "query"));
            }
        }
        return ClickHouseClient.submit(() -> {
            LinkedList<ClickHouseResponseSummary> list = new LinkedList<ClickHouseResponseSummary>();
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                Object request = client.connect(theServer).format(ClickHouseFormat.RowBinary);
                if (((Boolean)ClickHouseDefaults.AUTO_SESSION.getEffectiveDefaultValue()).booleanValue() && queries.size() > 1) {
                    ((ClickHouseRequest)request).session(UUID.randomUUID().toString(), false);
                }
                for (String query : queries) {
                    ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)request).query(query)).execute().get();
                    try {
                        list.add(resp.getSummary());
                    }
                    finally {
                        if (resp == null) continue;
                        resp.close();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ClickHouseException.forCancellation(e, theServer);
            }
            catch (CancellationException e) {
                throw ClickHouseException.forCancellation(e, theServer);
            }
            catch (ExecutionException e) {
                throw ClickHouseException.of(e, theServer);
            }
            return list;
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> send(ClickHouseNode server, String sql, Map<String, String> params) {
        if (server == null || sql == null || params == null) {
            throw new IllegalArgumentException("Non-null server, sql and parameters are required");
        }
        ClickHouseNode theServer = ClickHouseCluster.probe(server);
        return ClickHouseClient.submit(() -> {
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)client.connect(theServer).format(ClickHouseFormat.RowBinary)).query(sql)).params(params)).execute().get();
                try {
                    ClickHouseResponseSummary clickHouseResponseSummary = resp.getSummary();
                    if (resp != null) {
                        resp.close();
                    }
                    return clickHouseResponseSummary;
                }
                catch (Throwable throwable) {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ClickHouseException.forCancellation(e, theServer);
            }
            catch (CancellationException e) {
                throw ClickHouseException.forCancellation(e, theServer);
            }
            catch (ExecutionException e) {
                throw ClickHouseException.of(e, theServer);
            }
        });
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, List<ClickHouseColumn> columns, Object[] ... params) {
        int len;
        int n = len = columns == null ? 0 : columns.size();
        if (len == 0) {
            throw new IllegalArgumentException("Non-empty column list is required");
        }
        ClickHouseValue[] templates = new ClickHouseValue[len];
        int index = 0;
        for (ClickHouseColumn column : columns) {
            templates[index++] = ClickHouseValues.newValue(ClickHouseChecker.nonNull(column, "column"));
        }
        return ClickHouseClient.send(server, sql, templates, params);
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, ClickHouseValue[] templates, Object[] ... params) {
        int size;
        int len = templates == null ? 0 : templates.length;
        int n = size = params == null ? 0 : params.length;
        if (templates == null || templates.length == 0 || params == null || params.length == 0) {
            throw new IllegalArgumentException("Non-empty templates and parameters are required");
        }
        ClickHouseParameterizedQuery query = ClickHouseParameterizedQuery.of(sql);
        if (!query.hasParameter()) {
            throw new IllegalArgumentException("No named parameter found from the given query");
        }
        ClickHouseNode theServer = ClickHouseCluster.probe(server);
        return ClickHouseClient.submit(() -> {
            ArrayList<ClickHouseResponseSummary> list = new ArrayList<ClickHouseResponseSummary>(params.length);
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                Object request = ((ClickHouseRequest)client.connect(theServer).format(ClickHouseFormat.RowBinary)).query(query);
                for (int i = 0; i < size; ++i) {
                    int slen;
                    Object[] o = params[i];
                    String[] arr = new String[len];
                    int n = slen = o == null ? 0 : o.length;
                    for (int j = 0; j < slen; ++j) {
                        ClickHouseValue v;
                        arr[j] = j < len ? "NULL" : ((v = templates[j]) != null ? v.update(o[j]).toSqlExpression() : ClickHouseValues.convertToSqlExpression(o[j]));
                    }
                    try (ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)request).params(arr)).execute().get();){
                        list.add(resp.getSummary());
                        continue;
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ClickHouseException.forCancellation(e, theServer);
            }
            catch (CancellationException e) {
                throw ClickHouseException.forCancellation(e, theServer);
            }
            catch (ExecutionException e) {
                throw ClickHouseException.of(e, theServer);
            }
            return list;
        });
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, String[][] params) {
        if (server == null || sql == null || params == null) {
            throw new IllegalArgumentException("Non-null server, sql, and parameters are required");
        }
        if (params.length == 0) {
            return ClickHouseClient.send(server, sql, new String[0]);
        }
        ClickHouseParameterizedQuery query = ClickHouseParameterizedQuery.of(sql);
        if (!query.hasParameter()) {
            throw new IllegalArgumentException("No named parameter found from the given query");
        }
        ClickHouseNode theServer = ClickHouseCluster.probe(server);
        return ClickHouseClient.submit(() -> {
            ArrayList<ClickHouseResponseSummary> list = new ArrayList<ClickHouseResponseSummary>(params.length);
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                Object request = client.connect(theServer).format(ClickHouseFormat.RowBinary);
                for (String[] p : params) {
                    try (ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)request).query(query.apply(p))).execute().get();){
                        list.add(resp.getSummary());
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ClickHouseException.forCancellation(e, theServer);
            }
            catch (CancellationException e) {
                throw ClickHouseException.forCancellation(e, theServer);
            }
            catch (ExecutionException e) {
                throw ClickHouseException.of(e, theServer);
            }
            return list;
        });
    }

    default public boolean accept(ClickHouseProtocol protocol) {
        return protocol == null || protocol == ClickHouseProtocol.ANY;
    }

    default public ClickHouseRequest<?> connect(Function<ClickHouseNodeSelector, ClickHouseNode> nodeFunc) {
        return new ClickHouseRequest(this, ClickHouseChecker.nonNull(nodeFunc, "nodeFunc"), false);
    }

    public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> var1);

    public ClickHouseConfig getConfig();

    default public Class<? extends ClickHouseOption> getOptionClass() {
        return null;
    }

    default public void init(ClickHouseConfig config) {
        ClickHouseChecker.nonNull(config, "configuration");
    }

    default public boolean ping(ClickHouseNode server, int timeout) {
        if (server != null) {
            server = ClickHouseCluster.probe(server, timeout);
            ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)this.connect(server).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false))).option(ClickHouseClientOption.CONNECTION_TIMEOUT, Integer.valueOf(timeout))).option(ClickHouseClientOption.SOCKET_TIMEOUT, Integer.valueOf(timeout))).option(ClickHouseClientOption.MAX_BUFFER_SIZE, Integer.valueOf(8))).option(ClickHouseClientOption.MAX_QUEUED_BUFFERS, Integer.valueOf(1))).format(ClickHouseFormat.TabSeparated)).query("SELECT 1")).execute().get(timeout, TimeUnit.MILLISECONDS);
            try {
                boolean bl = true;
                if (resp != null) {
                    resp.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public void close();
}

