/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.data.ClickHouseBlockChecksum;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class ClickHouseLZ4InputStream
extends InputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    static final int MAGIC = 130;
    private final InputStream stream;
    private byte[] currentBlock;
    private int pointer;

    private void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.stream.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    private int readUnsignedByte() throws IOException {
        int ch = this.stream.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public ClickHouseLZ4InputStream(InputStream stream) {
        this.stream = ClickHouseChecker.nonNull(stream, "InputStream");
    }

    @Override
    public int available() throws IOException {
        int estimated = this.stream.available();
        if (estimated == 0 && this.currentBlock != null) {
            estimated = this.currentBlock.length - this.pointer;
        }
        return estimated;
    }

    @Override
    public int read() throws IOException {
        return this.checkNext() ? 0xFF & this.currentBlock[this.pointer++] : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int copied;
        int toCopy;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.checkNext()) {
            return -1;
        }
        int targetPointer = off;
        for (copied = 0; copied != len; copied += toCopy) {
            toCopy = Math.min(this.currentBlock.length - this.pointer, len - copied);
            System.arraycopy(this.currentBlock, this.pointer, b, targetPointer, toCopy);
            targetPointer += toCopy;
            this.pointer += toCopy;
            if (this.checkNext()) continue;
            break;
        }
        return copied;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    private boolean checkNext() throws IOException {
        if (this.currentBlock == null || this.pointer == this.currentBlock.length) {
            this.currentBlock = this.readNextBlock();
            this.pointer = 0;
        }
        return this.currentBlock != null && this.pointer < this.currentBlock.length;
    }

    private int readInt() throws IOException {
        byte b1 = (byte)this.readUnsignedByte();
        byte b2 = (byte)this.readUnsignedByte();
        byte b3 = (byte)this.readUnsignedByte();
        byte b4 = (byte)this.readUnsignedByte();
        return b4 << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    private byte[] readNextBlock() throws IOException {
        int read = this.stream.read();
        if (read < 0) {
            return null;
        }
        byte[] checksum = new byte[16];
        checksum[0] = (byte)read;
        this.readFully(checksum, 1, 15);
        ClickHouseBlockChecksum expected = ClickHouseBlockChecksum.fromBytes(checksum);
        int magic = this.readUnsignedByte();
        if (magic != 130) {
            throw new IOException("Magic is not correct: " + magic);
        }
        int compressedSizeWithHeader = this.readInt();
        int uncompressedSize = this.readInt();
        int compressedSize = compressedSizeWithHeader - 9;
        byte[] block = new byte[compressedSize];
        this.readFully(block, 0, block.length);
        ClickHouseBlockChecksum real = ClickHouseBlockChecksum.calculateForBlock((byte)magic, compressedSizeWithHeader, uncompressedSize, block, compressedSize);
        if (!real.equals(expected)) {
            throw new IllegalArgumentException("Checksum doesn't match: corrupted data.");
        }
        byte[] decompressed = new byte[uncompressedSize];
        LZ4FastDecompressor decompressor = factory.fastDecompressor();
        decompressor.decompress(block, 0, decompressed, 0, uncompressedSize);
        return decompressed;
    }
}

