/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClickHouseLongValue
implements ClickHouseValue {
    private static final BigInteger MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    private boolean isNull;
    private boolean unsigned;
    private long value;

    public static ClickHouseLongValue ofNull(boolean unsigned) {
        return ClickHouseLongValue.ofNull(null, unsigned);
    }

    public static ClickHouseLongValue ofNull(ClickHouseValue ref, boolean unsigned) {
        return ref instanceof ClickHouseLongValue ? ((ClickHouseLongValue)ref).set(true, unsigned, 0L) : new ClickHouseLongValue(true, unsigned, 0L);
    }

    public static ClickHouseLongValue of(long value, boolean unsigned) {
        return ClickHouseLongValue.of(null, unsigned, value);
    }

    public static ClickHouseLongValue of(Number value) {
        return value == null ? ClickHouseLongValue.ofNull(null, false) : ClickHouseLongValue.of(null, false, value.longValue());
    }

    public static ClickHouseLongValue of(ClickHouseValue ref, boolean unsigned, long value) {
        return ref instanceof ClickHouseLongValue ? ((ClickHouseLongValue)ref).set(false, unsigned, value) : new ClickHouseLongValue(false, unsigned, value);
    }

    protected ClickHouseLongValue(boolean isNull, boolean unsigned, long value) {
        this.set(isNull, unsigned, value);
    }

    protected ClickHouseLongValue set(boolean isNull, boolean unsigned, long value) {
        this.isNull = isNull;
        this.unsigned = unsigned;
        this.value = isNull ? 0L : value;
        return this;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public ClickHouseLongValue copy(boolean deep) {
        return new ClickHouseLongValue(this.isNull, this.unsigned, this.value);
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.isNull;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return (short)this.value;
    }

    @Override
    public int asInteger() {
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        if (this.isNull) {
            return null;
        }
        BigInteger v = BigInteger.valueOf(this.value);
        if (this.unsigned && this.value < 0L) {
            v = v.and(MASK);
        }
        return v;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return this.unsigned && this.value < 0L ? new BigDecimal(this.asBigInteger(), scale) : BigDecimal.valueOf(this.value, scale);
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : Long.valueOf(this.getValue());
    }

    @Override
    public String asString(int length, Charset charset) {
        String str;
        if (this.isNull) {
            return null;
        }
        String string = str = this.unsigned && this.value < 0L ? this.asBigInteger().toString() : String.valueOf(this.value);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseLongValue resetToNullOrEmpty() {
        return this.set(true, false, 0L);
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        return this.unsigned && this.value < 0L ? this.asBigInteger().toString() : String.valueOf(this.value);
    }

    @Override
    public ClickHouseLongValue update(boolean value) {
        return this.set(false, this.unsigned, value ? 1L : 0L);
    }

    @Override
    public ClickHouseLongValue update(char value) {
        return this.set(false, this.unsigned, value);
    }

    @Override
    public ClickHouseLongValue update(byte value) {
        return this.set(false, this.unsigned, value);
    }

    @Override
    public ClickHouseLongValue update(short value) {
        return this.set(false, this.unsigned, value);
    }

    @Override
    public ClickHouseLongValue update(int value) {
        return this.set(false, this.unsigned, value);
    }

    @Override
    public ClickHouseLongValue update(long value) {
        return this.set(false, this.unsigned, value);
    }

    @Override
    public ClickHouseLongValue update(float value) {
        return this.set(false, this.unsigned, (long)value);
    }

    @Override
    public ClickHouseLongValue update(double value) {
        return this.set(false, this.unsigned, (long)value);
    }

    @Override
    public ClickHouseLongValue update(BigInteger value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, this.unsigned, value.longValueExact());
    }

    @Override
    public ClickHouseLongValue update(BigDecimal value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, this.unsigned, value.longValueExact());
    }

    @Override
    public ClickHouseLongValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, this.unsigned, value.ordinal());
    }

    @Override
    public ClickHouseLongValue update(String value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, this.unsigned, new BigInteger(value).longValue());
    }

    @Override
    public ClickHouseLongValue update(ClickHouseValue value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, this.unsigned, value.asLong());
    }

    @Override
    public ClickHouseLongValue update(Object value) {
        if (value instanceof Number) {
            return this.set(false, this.unsigned, ((Number)value).longValue());
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, this.unsigned, ((ClickHouseValue)value).asLong());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseLongValue v = (ClickHouseLongValue)obj;
        return this.isNull == v.isNull && this.unsigned == v.unsigned && this.value == v.value;
    }

    public int hashCode() {
        return (31 + (this.isNull ? 1231 : 1237)) * 31 + (this.unsigned ? 1231 : 1237) * 31 + (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

