/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseAggregateFunction;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDeserializer;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseSerializer;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseSimpleRecord;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public abstract class ClickHouseDataProcessor {
    public static final List<ClickHouseColumn> DEFAULT_COLUMNS = Collections.singletonList(ClickHouseColumn.of("results", "Nullable(String)"));
    protected static final String ERROR_FAILED_TO_READ = "Failed to read column #%d of %d: %s";
    protected static final String ERROR_FAILED_TO_WRITE = "Failed to write column #%d of %d: %s";
    protected static final String ERROR_REACHED_END_OF_STREAM = "Reached end of the stream when reading column #%d of %d: %s";
    protected static final String ERROR_UNKNOWN_DATA_TYPE = "Unsupported data type: ";
    protected final ClickHouseConfig config;
    protected final ClickHouseInputStream input;
    protected final ClickHouseOutputStream output;
    protected final ClickHouseColumn[] columns;
    protected final ClickHouseValue[] templates;
    protected final Map<String, Object> settings;
    protected final Iterator<ClickHouseRecord> records;
    protected final Iterator<ClickHouseValue> values;
    protected int readPosition;

    protected static void buildAggMappings(Map<ClickHouseAggregateFunction, ClickHouseDeserializer<ClickHouseValue>> deserializers, Map<ClickHouseAggregateFunction, ClickHouseSerializer<ClickHouseValue>> serializers, ClickHouseDeserializer<ClickHouseValue> d, ClickHouseSerializer<ClickHouseValue> s, ClickHouseAggregateFunction ... types) {
        for (ClickHouseAggregateFunction t : types) {
            if (deserializers.put(t, d) != null) {
                throw new IllegalArgumentException("Duplicated deserializer of AggregateFunction - " + t.name());
            }
            if (serializers.put(t, s) == null) continue;
            throw new IllegalArgumentException("Duplicated serializer of AggregateFunction - " + t.name());
        }
    }

    protected static <E extends Enum<E>, T extends ClickHouseValue> void buildMappings(Map<E, ClickHouseDeserializer<? extends ClickHouseValue>> deserializers, Map<E, ClickHouseSerializer<? extends ClickHouseValue>> serializers, ClickHouseDeserializer<T> d, ClickHouseSerializer<T> s, E ... types) {
        for (E t : types) {
            if (deserializers.put(t, d) != null) {
                throw new IllegalArgumentException("Duplicated deserializer of: " + ((Enum)t).name());
            }
            if (serializers.put(t, s) == null) continue;
            throw new IllegalArgumentException("Duplicated serializer of: " + ((Enum)t).name());
        }
    }

    protected ClickHouseRecord createRecord() {
        return ClickHouseSimpleRecord.of(this.getColumns(), this.templates);
    }

    protected Iterator<ClickHouseRecord> initRecords() {
        ClickHouseRecord reusableRecord = this.createRecord();
        final Supplier<ClickHouseRecord> factory = this.config.isReuseValueWrapper() ? () -> reusableRecord : reusableRecord::copy;
        return new Iterator<ClickHouseRecord>(){

            @Override
            public boolean hasNext() {
                try {
                    return ClickHouseDataProcessor.this.input.available() > 0;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public ClickHouseRecord next() {
                ClickHouseRecord currentRecord = (ClickHouseRecord)factory.get();
                try {
                    ClickHouseDataProcessor.this.readAndFill(currentRecord);
                    ClickHouseDataProcessor.this.readPosition = 0;
                }
                catch (EOFException e) {
                    if (ClickHouseDataProcessor.this.readPosition == 0) {
                        throw new NoSuchElementException("No more record");
                    }
                    throw new UncheckedIOException(ClickHouseUtils.format(ClickHouseDataProcessor.ERROR_REACHED_END_OF_STREAM, ClickHouseDataProcessor.this.readPosition + 1, ClickHouseDataProcessor.this.columns.length, ClickHouseDataProcessor.this.columns[ClickHouseDataProcessor.this.readPosition]), e);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(ClickHouseUtils.format(ClickHouseDataProcessor.ERROR_FAILED_TO_READ, ClickHouseDataProcessor.this.readPosition + 1, ClickHouseDataProcessor.this.columns.length, ClickHouseDataProcessor.this.columns[ClickHouseDataProcessor.this.readPosition]), e);
                }
                return currentRecord;
            }
        };
    }

    protected Iterator<ClickHouseValue> initValues() {
        if (this.readPosition != 0) {
            throw new IllegalStateException("This method is supposed to be called once during instantiation");
        }
        return new Iterator<ClickHouseValue>(){

            @Override
            public boolean hasNext() {
                try {
                    return ClickHouseDataProcessor.this.input.available() > 0;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public ClickHouseValue next() {
                ClickHouseColumn column = ClickHouseDataProcessor.this.columns[ClickHouseDataProcessor.this.readPosition];
                ClickHouseValue value = ClickHouseDataProcessor.this.config.isReuseValueWrapper() ? ClickHouseDataProcessor.this.templates[ClickHouseDataProcessor.this.readPosition] : ClickHouseValues.newValue(ClickHouseDataProcessor.this.config, column);
                try {
                    ClickHouseDataProcessor.this.templates[ClickHouseDataProcessor.this.readPosition] = ClickHouseDataProcessor.this.read(value, column);
                    if (++ClickHouseDataProcessor.this.readPosition >= ClickHouseDataProcessor.this.columns.length) {
                        ClickHouseDataProcessor.this.readPosition = 0;
                    }
                }
                catch (EOFException e) {
                    if (ClickHouseDataProcessor.this.readPosition == 0) {
                        throw new NoSuchElementException("No more value");
                    }
                    throw new UncheckedIOException(ClickHouseUtils.format(ClickHouseDataProcessor.ERROR_REACHED_END_OF_STREAM, ClickHouseDataProcessor.this.readPosition + 1, ClickHouseDataProcessor.this.columns.length, column), e);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(ClickHouseUtils.format(ClickHouseDataProcessor.ERROR_FAILED_TO_READ, ClickHouseDataProcessor.this.readPosition + 1, ClickHouseDataProcessor.this.columns.length, column), e);
                }
                return value;
            }
        };
    }

    protected void readAndFill(ClickHouseRecord r) throws IOException {
        while (this.readPosition < this.columns.length) {
            this.readAndFill(r.getValue(this.readPosition), this.columns[this.readPosition]);
            ++this.readPosition;
        }
    }

    protected abstract void readAndFill(ClickHouseValue var1, ClickHouseColumn var2) throws IOException;

    protected abstract List<ClickHouseColumn> readColumns() throws IOException;

    protected ClickHouseDataProcessor(ClickHouseConfig config, ClickHouseInputStream input, ClickHouseOutputStream output, List<ClickHouseColumn> columns, Map<String, Object> settings) throws IOException {
        this.config = ClickHouseChecker.nonNull(config, "config");
        if (input == null && output == null) {
            throw new IllegalArgumentException("One of input and output stream must not be null");
        }
        this.input = input;
        this.output = output;
        if (settings == null || settings.isEmpty()) {
            this.settings = Collections.emptyMap();
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(settings);
            this.settings = Collections.unmodifiableMap(map);
        }
        if (columns == null && input != null) {
            columns = this.readColumns();
        }
        if (columns == null || columns.isEmpty()) {
            this.columns = ClickHouseColumn.EMPTY_ARRAY;
            this.templates = ClickHouseValues.EMPTY_VALUES;
        } else {
            int len = columns.size();
            int idx = 0;
            ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(len);
            this.templates = new ClickHouseValue[len];
            for (ClickHouseColumn column : columns) {
                column.setColumnIndex(idx, len);
                list.add(column);
                if (config.isReuseValueWrapper()) {
                    this.templates[idx] = ClickHouseValues.newValue(config, column);
                }
                ++idx;
            }
            this.columns = list.toArray(ClickHouseColumn.EMPTY_ARRAY);
        }
        if (this.columns.length == 0 || input == null) {
            this.records = Collections.emptyIterator();
            this.values = Collections.emptyIterator();
        } else {
            this.records = ClickHouseChecker.nonNull(this.initRecords(), "Records");
            this.values = ClickHouseChecker.nonNull(this.initValues(), "Values");
        }
        this.readPosition = 0;
    }

    public final List<ClickHouseColumn> getColumns() {
        return Collections.unmodifiableList(Arrays.asList(this.columns));
    }

    public final Iterable<ClickHouseRecord> records() {
        if (this.columns.length == 0) {
            return Collections.emptyList();
        }
        return () -> this.records;
    }

    public final Iterable<ClickHouseValue> values() {
        if (this.columns.length == 0) {
            return Collections.emptyList();
        }
        return () -> this.values;
    }

    public ClickHouseValue read(ClickHouseValue value, ClickHouseColumn column) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("No input stream available to read");
        }
        if (column == null) {
            column = this.columns[this.readPosition];
        }
        if (value == null) {
            value = this.config.isReuseValueWrapper() ? this.templates[this.readPosition] : ClickHouseValues.newValue(this.config, column);
        }
        this.readAndFill(value, column);
        if (++this.readPosition >= this.columns.length) {
            this.readPosition = 0;
        }
        return value;
    }

    public abstract void write(ClickHouseValue var1, ClickHouseColumn var2) throws IOException;
}

