/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.logging;

import java.util.Locale;

public final class LogMessage {
    private final String message;
    private final Throwable throwable;

    public static LogMessage of(Object format, Object ... arguments) {
        int len;
        String message = String.valueOf(format);
        Throwable t = null;
        int n = len = arguments != null ? arguments.length : 0;
        if (len > 0) {
            Object lastArg = arguments[len - 1];
            if (lastArg instanceof Throwable) {
                t = (Throwable)lastArg;
                if (--len > 0) {
                    Object[] args = new Object[len];
                    System.arraycopy(arguments, 0, args, 0, len);
                    arguments = args;
                }
            }
            if (len > 0) {
                message = String.format(Locale.ROOT, message, arguments);
            }
        }
        return new LogMessage(message, t);
    }

    private LogMessage(String message, Throwable t) {
        this.message = message;
        this.throwable = t;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean hasThrowable() {
        return this.throwable != null;
    }
}

