/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseDnsResolver;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

class ClickHouseCluster
implements Function<ClickHouseNodeSelector, ClickHouseNode>,
Serializable {
    private static final long serialVersionUID = 8684489015067906319L;
    private static final Logger log = LoggerFactory.getLogger(ClickHouseCluster.class);
    private static final String PARAM_NODES = "nodes";
    private final AtomicBoolean checking;
    private final transient ScheduledExecutorService scheduledExecutor;
    private final List<ClickHouseNode> unhealthyNodes;
    private final AtomicInteger index;
    private final List<ClickHouseNode> nodes;
    private final LoadBalancingPolicy lbPolicy;

    public static Builder builder() {
        return new Builder();
    }

    public static ClickHouseNode probe(ClickHouseNode node) {
        return ClickHouseCluster.probe(node, 3000);
    }

    public static ClickHouseNode probe(ClickHouseNode node, int timeout) {
        ClickHouseDnsResolver resolver = ClickHouseDnsResolver.getInstance();
        if (ClickHouseChecker.nonNull(node, "node").getProtocol() == ClickHouseProtocol.ANY) {
            InetSocketAddress address = resolver != null ? resolver.resolve(ClickHouseProtocol.ANY, node.getHost(), node.getPort()) : new InetSocketAddress(node.getHost(), node.getPort());
            ClickHouseProtocol p = ClickHouseProtocol.HTTP;
            try (Socket client = new Socket();){
                client.setKeepAlive(false);
                client.connect(address, timeout);
                client.setSoTimeout(timeout);
                OutputStream out = client.getOutputStream();
                out.write("GET /ping HTTP/1.1\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
                out.flush();
                byte[] buf = new byte[12];
                if (client.getInputStream().read(buf) == buf.length) {
                    if (buf[0] == 0) {
                        p = ClickHouseProtocol.GRPC;
                    } else if (buf[3] == 0) {
                        p = ClickHouseProtocol.MYSQL;
                    } else if (buf[0] == 72 && buf[9] == 52) {
                        p = ClickHouseProtocol.TCP;
                    }
                }
            }
            catch (IOException e) {
                log.debug((Object)("Failed to probe: " + address), e);
            }
            node = ClickHouseNode.builder(node).port(p).build();
        }
        return node;
    }

    public static ClickHouseCluster of(ClickHouseNode ... nodes) {
        return new ClickHouseCluster(null, nodes);
    }

    public static ClickHouseCluster of(Collection<ClickHouseNode> nodes) {
        return new ClickHouseCluster(null, nodes);
    }

    protected static void handleUncaughtException(Thread r, Throwable t) {
        log.warn((Object)("Exception caught from thread: " + r), t);
    }

    protected ClickHouseCluster(LoadBalancingPolicy policy, ClickHouseNode ... nodes) {
        this(policy, Arrays.asList(ClickHouseChecker.nonNull(nodes, PARAM_NODES)));
    }

    protected ClickHouseCluster(LoadBalancingPolicy policy, Collection<ClickHouseNode> nodes) {
        this.lbPolicy = policy == null ? LoadBalancingPolicy.ROUND_ROBIN : policy;
        this.checking = new AtomicBoolean(false);
        this.index = new AtomicInteger(0);
        int size = ClickHouseChecker.nonNull(nodes, PARAM_NODES).size();
        this.nodes = Collections.synchronizedList(new ArrayList(size));
        this.unhealthyNodes = Collections.synchronizedList(new ArrayList(size));
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, ClickHouseCluster.class.getSimpleName());
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler(ClickHouseCluster::handleUncaughtException);
                return thread;
            }
        });
        for (ClickHouseNode node : nodes) {
            if (node == null) continue;
            ClickHouseCluster.probe(node).setManager(this::update);
        }
    }

    protected synchronized void update(ClickHouseNode node, ClickHouseNode.Status status) {
        switch (status) {
            case UNMANAGED: {
                this.nodes.remove(node);
                this.unhealthyNodes.remove(node);
                break;
            }
            case MANAGED: 
            case HEALTHY: {
                this.unhealthyNodes.remove(node);
                if (this.nodes.contains(node)) break;
                this.nodes.add(node);
                break;
            }
            case UNHEALTHY: {
                this.nodes.remove(node);
                if (this.unhealthyNodes.contains(node)) break;
                this.unhealthyNodes.add(node);
                if (this.checking.get()) break;
                this.scheduledExecutor.execute(this::check);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check() {
        if (this.checking.compareAndSet(false, true)) {
            return;
        }
        try {
            boolean passed = true;
            int timeout = 5000;
            for (int i = 0; i < this.unhealthyNodes.size(); ++i) {
                ClickHouseNode node = ClickHouseCluster.probe(this.unhealthyNodes.get(i), timeout);
                boolean isAlive = false;
                try (ClickHouseClient client = ClickHouseClient.newInstance(node.getProtocol());){
                    isAlive = client.ping(node, timeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (isAlive) {
                    this.update(node, ClickHouseNode.Status.HEALTHY);
                    continue;
                }
                passed = false;
            }
            if (!passed) {
                this.scheduledExecutor.schedule(this::check, 3L, TimeUnit.SECONDS);
            }
        }
        finally {
            this.checking.set(false);
        }
    }

    public LoadBalancingPolicy getLbPolicy() {
        return this.lbPolicy;
    }

    public boolean hasNode() {
        return !this.nodes.isEmpty();
    }

    public List<ClickHouseNode> getAvailableNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    @Override
    public synchronized ClickHouseNode apply(ClickHouseNodeSelector t) {
        ClickHouseNode node;
        int i;
        boolean noSelector;
        boolean bl = noSelector = t == null || t == ClickHouseNodeSelector.EMPTY;
        if (this.nodes.isEmpty()) {
            throw new IllegalArgumentException("No healthy node available");
        }
        if (this.lbPolicy == LoadBalancingPolicy.PICK_FIRST) {
            return this.nodes.get(0);
        }
        int idx = this.index.get();
        ClickHouseNode matched = null;
        for (i = idx; i < this.nodes.size(); ++i) {
            node = this.nodes.get(i);
            if (!noSelector && !t.match(node)) continue;
            matched = node;
            this.index.compareAndSet(idx, i + 1);
            break;
        }
        if (matched == null && idx > 0) {
            for (i = 0; i < Math.min(idx, this.nodes.size()); ++i) {
                node = this.nodes.get(i);
                if (!noSelector && !t.match(node)) continue;
                matched = node;
                this.index.compareAndSet(idx, i + 1);
                break;
            }
        }
        if (matched == null) {
            throw new IllegalArgumentException(ClickHouseUtils.format("No healthy node found from a list of %d(index=%d)", this.nodes.size(), this.index.get()));
        }
        return matched;
    }

    public static class Builder {
        private final List<ClickHouseNode> nodes = new LinkedList<ClickHouseNode>();
        private LoadBalancingPolicy lbPolicy;

        private Builder() {
        }

        protected Builder addNode(ClickHouseNode node) {
            if (!this.nodes.contains(ClickHouseChecker.nonNull(node, "node"))) {
                this.nodes.add(node);
            }
            return this;
        }

        public Builder addNodes(ClickHouseNode node, ClickHouseNode ... more) {
            this.addNode(node);
            if (more != null) {
                for (ClickHouseNode n : more) {
                    this.addNode(n);
                }
            }
            return this;
        }

        public Builder addNodes(Collection<ClickHouseNode> nodes) {
            for (ClickHouseNode node : ClickHouseChecker.nonNull(nodes, ClickHouseCluster.PARAM_NODES)) {
                this.addNode(node);
            }
            return this;
        }

        public Builder merge(ClickHouseCluster cluster) {
            for (ClickHouseNode node : ClickHouseChecker.nonNull(cluster, "cluster").nodes) {
                this.addNode(node);
            }
            return this;
        }

        public Builder withLbPolicy(LoadBalancingPolicy policy) {
            this.lbPolicy = policy;
            return this;
        }

        public ClickHouseCluster build() {
            return new ClickHouseCluster(this.lbPolicy, this.nodes);
        }
    }

    public static enum LoadBalancingPolicy {
        ROUND_ROBIN,
        PICK_FIRST;

    }
}

