/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseRecordTransformer;
import com.clickhouse.client.data.ClickHouseSimpleRecord;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ClickHouseSimpleResponse
implements ClickHouseResponse {
    public static final ClickHouseSimpleResponse EMPTY = new ClickHouseSimpleResponse(Collections.emptyList(), new ClickHouseValue[0][], ClickHouseResponseSummary.EMPTY);
    private final List<ClickHouseColumn> columns;
    private final List<ClickHouseRecord> records;
    private final ClickHouseResponseSummary summary;
    private boolean isClosed;

    public static ClickHouseResponse of(ClickHouseConfig config, List<ClickHouseColumn> columns, Object[][] values) {
        return ClickHouseSimpleResponse.of(config, columns, values, null);
    }

    public static ClickHouseResponse of(ClickHouseConfig config, List<ClickHouseColumn> columns, Object[][] values, ClickHouseResponseSummary summary) {
        if (columns == null || columns.isEmpty()) {
            return EMPTY;
        }
        int size = columns.size();
        int len = values != null ? values.length : 0;
        ClickHouseValue[][] wrappedValues = new ClickHouseValue[len][];
        if (len > 0) {
            int i;
            ClickHouseValue[] templates = new ClickHouseValue[size];
            for (i = 0; i < size; ++i) {
                templates[i] = ClickHouseValues.newValue(config, columns.get(i));
            }
            for (i = 0; i < len; ++i) {
                Object[] input = values[i];
                int count = input != null ? input.length : 0;
                ClickHouseValue[] v = new ClickHouseValue[size];
                for (int j = 0; j < size; ++j) {
                    v[j] = templates[j].copy().update(j < count ? input[j] : null);
                }
                wrappedValues[i] = v;
            }
        }
        return new ClickHouseSimpleResponse(columns, wrappedValues, summary);
    }

    public static ClickHouseResponse of(ClickHouseResponse response) {
        return ClickHouseSimpleResponse.of(response, null);
    }

    public static ClickHouseResponse of(ClickHouseResponse response, ClickHouseRecordTransformer func) {
        if (response == null) {
            return EMPTY;
        }
        if (response instanceof ClickHouseSimpleResponse) {
            return response;
        }
        List<ClickHouseColumn> columns = response.getColumns();
        int size = columns.size();
        LinkedList<ClickHouseRecord> records = new LinkedList<ClickHouseRecord>();
        int rowIndex = 0;
        for (ClickHouseRecord r : response.records()) {
            ClickHouseValue[] values = new ClickHouseValue[size];
            for (int i = 0; i < size; ++i) {
                values[i] = r.getValue(i).copy();
            }
            ClickHouseRecord rec = ClickHouseSimpleRecord.of(columns, values);
            if (func != null) {
                func.update(rowIndex, rec);
            }
            records.add(rec);
        }
        return new ClickHouseSimpleResponse(response.getColumns(), records, response.getSummary());
    }

    protected ClickHouseSimpleResponse(List<ClickHouseColumn> columns, List<ClickHouseRecord> records, ClickHouseResponseSummary summary) {
        this.columns = columns;
        this.records = Collections.unmodifiableList(records);
        this.summary = summary != null ? summary : ClickHouseResponseSummary.EMPTY;
    }

    protected ClickHouseSimpleResponse(List<ClickHouseColumn> columns, ClickHouseValue[][] values, ClickHouseResponseSummary summary) {
        this.columns = columns;
        int len = values.length;
        ArrayList<ClickHouseSimpleRecord> list = new ArrayList<ClickHouseSimpleRecord>(len);
        for (int i = 0; i < len; ++i) {
            list.add(new ClickHouseSimpleRecord(columns, values[i]));
        }
        this.records = Collections.unmodifiableList(list);
        this.summary = summary != null ? summary : ClickHouseResponseSummary.EMPTY;
    }

    @Override
    public List<ClickHouseColumn> getColumns() {
        return this.columns;
    }

    @Override
    public ClickHouseResponseSummary getSummary() {
        return this.summary;
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException("An in-memory response does not have input stream");
    }

    @Override
    public Iterable<ClickHouseRecord> records() {
        return this.records;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

