/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseClientBuilder;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseVersion;
import com.clickhouse.client.config.ClickHouseBufferingMode;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.config.ClickHouseSslMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;

public class ClickHouseConfig
implements Serializable {
    private static final long serialVersionUID = 7794222888859182491L;
    private final boolean async;
    private final boolean autoDiscovery;
    private final String clientName;
    private final boolean compressRequest;
    private final ClickHouseCompression compressAlgorithm;
    private final int compressLevel;
    private final boolean decompressResponse;
    private final ClickHouseCompression decompressAlgorithm;
    private final int decompressLevel;
    private final int connectionTimeout;
    private final String database;
    private final ClickHouseFormat format;
    private final int maxBufferSize;
    private final int bufferSize;
    private final int bufferQueueVariation;
    private final int readBufferSize;
    private final int writeBufferSize;
    private final int requestChunkSize;
    private final ClickHouseBufferingMode requestBuffering;
    private final ClickHouseBufferingMode responseBuffering;
    private final int maxExecutionTime;
    private final int maxQueuedBuffers;
    private final int maxQueuedRequests;
    private final long maxResultRows;
    private final int maxThreads;
    private final int nodeCheckInterval;
    private final int failover;
    private final int retry;
    private final boolean reuseValueWrapper;
    private final boolean serverInfo;
    private final TimeZone serverTimeZone;
    private final ClickHouseVersion serverVersion;
    private final int sessionTimeout;
    private final boolean sessionCheck;
    private final int socketTimeout;
    private final boolean ssl;
    private final ClickHouseSslMode sslMode;
    private final String sslRootCert;
    private final String sslCert;
    private final String sslKey;
    private final boolean useBlockingQueue;
    private final boolean useObjectsInArray;
    private final boolean useServerTimeZone;
    private final boolean useServerTimeZoneForDates;
    private final TimeZone timeZoneForDate;
    private final TimeZone useTimeZone;
    private final Map<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
    private final ClickHouseCredentials credentials;
    private final transient Optional<Object> metricRegistry;
    private final ClickHouseNodeSelector nodeSelector;

    protected static final Map<ClickHouseOption, Serializable> mergeOptions(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
        ArrayList<ClickHouseConfig> cl = new ArrayList<ClickHouseConfig>(list.size());
        for (ClickHouseConfig c : list) {
            if (c == null) continue;
            boolean duplicated = false;
            for (ClickHouseConfig conf : cl) {
                if (conf != c) continue;
                duplicated = true;
                break;
            }
            if (duplicated) continue;
            options.putAll(c.options);
            cl.add(c);
        }
        return options;
    }

    protected static final ClickHouseCredentials mergeCredentials(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ClickHouseCredentials credentials = null;
        for (ClickHouseConfig c : list) {
            if (c == null || c.credentials == null) continue;
            credentials = c.credentials;
            break;
        }
        return credentials;
    }

    protected static final ClickHouseNodeSelector mergeNodeSelector(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ClickHouseNodeSelector nodeSelector = null;
        for (ClickHouseConfig c : list) {
            if (c == null || c.nodeSelector == null) continue;
            nodeSelector = c.nodeSelector;
            break;
        }
        return nodeSelector;
    }

    protected static final Object mergeMetricRegistry(List<ClickHouseConfig> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object metricRegistry = null;
        for (ClickHouseConfig c : list) {
            if (c == null || !c.metricRegistry.isPresent()) continue;
            metricRegistry = c.metricRegistry.get();
            break;
        }
        return metricRegistry;
    }

    public static Map<ClickHouseOption, Serializable> toClientOptions(Map<?, ?> props) {
        HashMap<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
        if (props != null && !props.isEmpty()) {
            Map customOptions = ClientOptions.instance.customOptions;
            for (Map.Entry<?, ?> e : props.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                String key = e.getKey().toString();
                ClickHouseOption o = ClickHouseClientOption.fromKey(key);
                if (o == null) {
                    o = (ClickHouseOption)customOptions.get(key);
                }
                if (o == null) continue;
                options.put(o, ClickHouseOption.fromString(e.getValue().toString(), o.getValueType()));
            }
        }
        return options;
    }

    public ClickHouseConfig(ClickHouseConfig ... configs) {
        this(configs == null || configs.length == 0 ? Collections.emptyList() : Arrays.asList(configs));
    }

    public ClickHouseConfig(List<ClickHouseConfig> configs) {
        this(ClickHouseConfig.mergeOptions(configs), ClickHouseConfig.mergeCredentials(configs), ClickHouseConfig.mergeNodeSelector(configs), ClickHouseConfig.mergeMetricRegistry(configs));
    }

    public ClickHouseConfig(Map<ClickHouseOption, Serializable> options, ClickHouseCredentials credentials, ClickHouseNodeSelector nodeSelector, Object metricRegistry) {
        if (options != null) {
            this.options.putAll(options);
        }
        this.async = (Boolean)this.getOption((ClickHouseOption)ClickHouseClientOption.ASYNC, ClickHouseDefaults.ASYNC);
        this.autoDiscovery = (Boolean)this.getOption(ClickHouseClientOption.AUTO_DISCOVERY);
        this.clientName = (String)((Object)this.getOption(ClickHouseClientOption.CLIENT_NAME));
        this.compressRequest = (Boolean)this.getOption(ClickHouseClientOption.DECOMPRESS);
        this.compressAlgorithm = (ClickHouseCompression)((Object)this.getOption(ClickHouseClientOption.DECOMPRESS_ALGORITHM));
        this.compressLevel = (Integer)this.getOption(ClickHouseClientOption.DECOMPRESS_LEVEL);
        this.decompressResponse = (Boolean)this.getOption(ClickHouseClientOption.COMPRESS);
        this.decompressAlgorithm = (ClickHouseCompression)((Object)this.getOption(ClickHouseClientOption.COMPRESS_ALGORITHM));
        this.decompressLevel = (Integer)this.getOption(ClickHouseClientOption.COMPRESS_LEVEL);
        this.connectionTimeout = (Integer)this.getOption(ClickHouseClientOption.CONNECTION_TIMEOUT);
        this.database = (String)((Object)this.getOption((ClickHouseOption)ClickHouseClientOption.DATABASE, ClickHouseDefaults.DATABASE));
        this.format = (ClickHouseFormat)((Object)this.getOption((ClickHouseOption)ClickHouseClientOption.FORMAT, ClickHouseDefaults.FORMAT));
        this.maxBufferSize = ClickHouseUtils.getBufferSize((Integer)this.getOption(ClickHouseClientOption.MAX_BUFFER_SIZE), -1, -1);
        this.bufferSize = (Integer)this.getOption(ClickHouseClientOption.BUFFER_SIZE);
        this.bufferQueueVariation = (Integer)this.getOption(ClickHouseClientOption.BUFFER_QUEUE_VARIATION);
        this.readBufferSize = (Integer)this.getOption(ClickHouseClientOption.READ_BUFFER_SIZE);
        this.writeBufferSize = (Integer)this.getOption(ClickHouseClientOption.WRITE_BUFFER_SIZE);
        this.requestChunkSize = (Integer)this.getOption(ClickHouseClientOption.REQUEST_CHUNK_SIZE);
        this.requestBuffering = (ClickHouseBufferingMode)((Object)this.getOption((ClickHouseOption)ClickHouseClientOption.REQUEST_BUFFERING, ClickHouseDefaults.BUFFERING));
        this.responseBuffering = (ClickHouseBufferingMode)((Object)this.getOption((ClickHouseOption)ClickHouseClientOption.RESPONSE_BUFFERING, ClickHouseDefaults.BUFFERING));
        this.maxExecutionTime = (Integer)this.getOption(ClickHouseClientOption.MAX_EXECUTION_TIME);
        this.maxQueuedBuffers = (Integer)this.getOption(ClickHouseClientOption.MAX_QUEUED_BUFFERS);
        this.maxQueuedRequests = (Integer)this.getOption(ClickHouseClientOption.MAX_QUEUED_REQUESTS);
        this.maxResultRows = (Long)this.getOption(ClickHouseClientOption.MAX_RESULT_ROWS);
        this.maxThreads = (Integer)this.getOption(ClickHouseClientOption.MAX_THREADS_PER_CLIENT);
        this.nodeCheckInterval = (Integer)this.getOption(ClickHouseClientOption.NODE_CHECK_INTERVAL);
        this.failover = (Integer)this.getOption(ClickHouseClientOption.FAILOVER);
        this.retry = (Integer)this.getOption(ClickHouseClientOption.RETRY);
        this.reuseValueWrapper = (Boolean)this.getOption(ClickHouseClientOption.REUSE_VALUE_WRAPPER);
        this.serverInfo = !ClickHouseChecker.isNullOrBlank((String)((Object)this.getOption(ClickHouseClientOption.SERVER_TIME_ZONE))) && !ClickHouseChecker.isNullOrBlank((String)((Object)this.getOption(ClickHouseClientOption.SERVER_VERSION)));
        this.serverTimeZone = TimeZone.getTimeZone((String)((Object)this.getOption((ClickHouseOption)ClickHouseClientOption.SERVER_TIME_ZONE, ClickHouseDefaults.SERVER_TIME_ZONE)));
        this.serverVersion = ClickHouseVersion.of((String)((Object)this.getOption((ClickHouseOption)ClickHouseClientOption.SERVER_VERSION, ClickHouseDefaults.SERVER_VERSION)));
        this.sessionTimeout = (Integer)this.getOption(ClickHouseClientOption.SESSION_TIMEOUT);
        this.sessionCheck = (Boolean)this.getOption(ClickHouseClientOption.SESSION_CHECK);
        this.socketTimeout = (Integer)this.getOption(ClickHouseClientOption.SOCKET_TIMEOUT);
        this.ssl = (Boolean)this.getOption(ClickHouseClientOption.SSL);
        this.sslMode = (ClickHouseSslMode)((Object)this.getOption(ClickHouseClientOption.SSL_MODE));
        this.sslRootCert = (String)((Object)this.getOption(ClickHouseClientOption.SSL_ROOT_CERTIFICATE));
        this.sslCert = (String)((Object)this.getOption(ClickHouseClientOption.SSL_CERTIFICATE));
        this.sslKey = (String)((Object)this.getOption(ClickHouseClientOption.SSL_KEY));
        this.useBlockingQueue = (Boolean)this.getOption(ClickHouseClientOption.USE_BLOCKING_QUEUE);
        this.useObjectsInArray = (Boolean)this.getOption(ClickHouseClientOption.USE_OBJECTS_IN_ARRAYS);
        this.useServerTimeZone = (Boolean)this.getOption(ClickHouseClientOption.USE_SERVER_TIME_ZONE);
        this.useServerTimeZoneForDates = (Boolean)this.getOption(ClickHouseClientOption.USE_SERVER_TIME_ZONE_FOR_DATES);
        String timeZone = (String)((Object)this.getOption(ClickHouseClientOption.USE_TIME_ZONE));
        TimeZone tz = ClickHouseChecker.isNullOrBlank(timeZone) ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZone);
        this.useTimeZone = this.useServerTimeZone ? this.serverTimeZone : tz;
        this.timeZoneForDate = this.useServerTimeZoneForDates ? this.useTimeZone : null;
        this.credentials = credentials == null ? ClickHouseCredentials.fromUserAndPassword((String)((Object)this.getOption(ClickHouseDefaults.USER)), (String)((Object)this.getOption(ClickHouseDefaults.PASSWORD))) : credentials;
        this.metricRegistry = Optional.ofNullable(metricRegistry);
        this.nodeSelector = nodeSelector == null ? ClickHouseNodeSelector.EMPTY : nodeSelector;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isAutoDiscovery() {
        return this.autoDiscovery;
    }

    public String getClientName() {
        return this.clientName;
    }

    public boolean isResponseCompressed() {
        return this.decompressResponse;
    }

    public ClickHouseCompression getResponseCompressAlgorithm() {
        return this.decompressResponse ? this.decompressAlgorithm : ClickHouseCompression.NONE;
    }

    public int getResponseCompressLevel() {
        return this.decompressResponse ? this.decompressLevel : 0;
    }

    @Deprecated
    public boolean isCompressServerResponse() {
        return this.decompressResponse;
    }

    @Deprecated
    public ClickHouseCompression getCompressAlgorithmForServerResponse() {
        return this.decompressAlgorithm;
    }

    @Deprecated
    public int getCompressLevelForServerResponse() {
        return this.decompressLevel;
    }

    public boolean isRequestCompressed() {
        return this.compressRequest;
    }

    public ClickHouseCompression getRequestCompressAlgorithm() {
        return this.compressRequest ? this.compressAlgorithm : ClickHouseCompression.NONE;
    }

    public int getRequestCompressLevel() {
        return this.compressRequest ? this.compressLevel : 0;
    }

    @Deprecated
    public boolean isDecompressClientRequet() {
        return this.compressRequest;
    }

    @Deprecated
    public ClickHouseCompression getDecompressAlgorithmForClientRequest() {
        return this.decompressAlgorithm;
    }

    @Deprecated
    public int getDecompressLevelForClientRequest() {
        return this.decompressLevel;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getDatabase() {
        return this.database;
    }

    public ClickHouseFormat getFormat() {
        return this.format;
    }

    public int getNodeCheckInterval() {
        return this.nodeCheckInterval;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getBufferQueueVariation() {
        return this.bufferQueueVariation;
    }

    public int getReadBufferSize() {
        return ClickHouseUtils.getBufferSize(this.readBufferSize, this.getBufferSize(), this.getMaxBufferSize());
    }

    public int getWriteBufferSize() {
        return ClickHouseUtils.getBufferSize(this.writeBufferSize, this.getBufferSize(), this.getMaxBufferSize());
    }

    public int getRequestChunkSize() {
        return ClickHouseUtils.getBufferSize(this.requestChunkSize, this.getWriteBufferSize(), this.getMaxBufferSize());
    }

    public ClickHouseBufferingMode getRequestBuffering() {
        return this.requestBuffering;
    }

    public ClickHouseBufferingMode getResponseBuffering() {
        return this.responseBuffering;
    }

    public int getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public int getMaxQueuedBuffers() {
        return this.maxQueuedBuffers;
    }

    public int getMaxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public long getMaxResultRows() {
        return this.maxResultRows;
    }

    public int getMaxThreadsPerClient() {
        return this.maxThreads;
    }

    public int getFailover() {
        return this.failover;
    }

    public int getRetry() {
        return this.retry;
    }

    @Deprecated
    public boolean isRetry() {
        return this.retry > 0;
    }

    public boolean isReuseValueWrapper() {
        return this.reuseValueWrapper;
    }

    public boolean hasServerInfo() {
        return this.serverInfo;
    }

    public TimeZone getServerTimeZone() {
        return this.serverTimeZone;
    }

    public ClickHouseVersion getServerVersion() {
        return this.serverVersion;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isSessionCheck() {
        return this.sessionCheck;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public ClickHouseSslMode getSslMode() {
        return this.sslMode;
    }

    public String getSslRootCert() {
        return this.sslRootCert;
    }

    public String getSslCert() {
        return this.sslCert;
    }

    public String getSslKey() {
        return this.sslKey;
    }

    public boolean isUseBlockingQueue() {
        return this.useBlockingQueue;
    }

    public boolean isUseObjectsInArray() {
        return this.useObjectsInArray;
    }

    public boolean isUseServerTimeZone() {
        return this.useServerTimeZone;
    }

    public boolean isUseServerTimeZoneForDates() {
        return this.useServerTimeZoneForDates;
    }

    public TimeZone getTimeZoneForDate() {
        return this.timeZoneForDate;
    }

    public TimeZone getUseTimeZone() {
        return this.useTimeZone;
    }

    public ClickHouseCredentials getDefaultCredentials() {
        return this.credentials;
    }

    public Optional<Object> getMetricRegistry() {
        return this.metricRegistry;
    }

    public ClickHouseNodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public List<ClickHouseProtocol> getPreferredProtocols() {
        return this.nodeSelector.getPreferredProtocols();
    }

    public Set<String> getPreferredTags() {
        return this.nodeSelector.getPreferredTags();
    }

    public Map<ClickHouseOption, Serializable> getAllOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public Serializable getOption(ClickHouseOption option) {
        return this.getOption(option, (ClickHouseDefaults)null);
    }

    public Serializable getOption(ClickHouseOption option, ClickHouseConfig defaultConfig) {
        return this.options.getOrDefault(ClickHouseChecker.nonNull(option, "option"), defaultConfig == null ? option.getEffectiveDefaultValue() : defaultConfig.getOption(option));
    }

    public Serializable getOption(ClickHouseOption option, ClickHouseDefaults defaultValue) {
        return this.options.getOrDefault(ClickHouseChecker.nonNull(option, "option"), defaultValue == null ? option.getEffectiveDefaultValue() : defaultValue.getEffectiveDefaultValue());
    }

    public boolean hasOption(ClickHouseOption option) {
        return option != null && this.options.containsKey(option);
    }

    public int hashCode() {
        return Objects.hash(this.options, this.credentials, this.metricRegistry.orElse(null), this.nodeSelector);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseConfig other = (ClickHouseConfig)obj;
        return Objects.equals(this.options, other.options) && Objects.equals(this.credentials, other.credentials) && Objects.equals(this.metricRegistry.orElse(null), other.metricRegistry.orElse(null)) && Objects.equals(this.nodeSelector, other.nodeSelector);
    }

    static final class ClientOptions {
        private static final ClientOptions instance = new ClientOptions();
        private final Map<String, ClickHouseOption> customOptions;

        private ClientOptions() {
            LinkedHashMap<String, ClickHouseOption> m = new LinkedHashMap<String, ClickHouseOption>();
            try {
                for (ClickHouseClient c : ClickHouseClientBuilder.loadClients()) {
                    Class<? extends ClickHouseOption> clazz = c.getOptionClass();
                    if (clazz == null || clazz == ClickHouseClientOption.class) continue;
                    for (ClickHouseOption o : clazz.getEnumConstants()) {
                        m.put(o.getKey(), o);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.customOptions = m.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(m);
        }
    }
}

