/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.benchmark.misc;

import com.clickhouse.benchmark.BaseState;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.config.ClickHouseBufferingMode;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Warmup(iterations=10, timeUnit=TimeUnit.SECONDS, time=1)
@Measurement(iterations=10, timeUnit=TimeUnit.SECONDS, time=1)
@Fork(value=2)
@Threads(value=-1)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
public class StreamBenchmark {
    @Benchmark
    public void classic(StreamState state, Blackhole consumer) throws IOException {
        int size = state.bufferSize;
        byte[] buffer = new byte[size];
        int count = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(state.samples);
        try (ByteArrayInputStream in = new ByteArrayInputStream(state.bytes);){
            int read = 0;
            while ((read = ((InputStream)in).read(buffer, 0, size)) > 0) {
                out.write(buffer, 0, read);
                count += read;
            }
            if (count != state.samples) {
                throw new IllegalStateException(String.format("Expect %d bytes but got %d", size, count));
            }
            out.flush();
            out.close();
        }
        if (!Arrays.equals(state.bytes, out.toByteArray())) {
            throw new IllegalStateException("Incorrect result");
        }
    }

    @Benchmark
    public void piped(StreamState state, Blackhole consumer) throws IOException {
        int size = state.bufferSize;
        long count = 0L;
        ByteArrayOutputStream out = new ByteArrayOutputStream(state.samples);
        try (ByteArrayInputStream in = new ByteArrayInputStream(state.bytes);){
            count = ClickHouseInputStream.pipe((InputStream)in, (OutputStream)out, (int)size);
            if (count != (long)state.samples) {
                throw new IllegalStateException(String.format("Expect %d bytes but got %d", size, count));
            }
            out.flush();
            out.close();
        }
        if (!Arrays.equals(state.bytes, out.toByteArray())) {
            throw new IllegalStateException("Incorrect result");
        }
    }

    @Benchmark
    public void wrapped(StreamState state, Blackhole consumer) throws IOException {
        int size = state.bufferSize;
        long count = 0L;
        ByteArrayOutputStream bao = new ByteArrayOutputStream(state.samples);
        try (ClickHouseInputStream in = ClickHouseInputStream.of((InputStream)new ByteArrayInputStream(state.bytes), (int)size);
             ClickHouseOutputStream out = ClickHouseOutputStream.of((OutputStream)bao, (int)size);){
            count = in.pipe(out);
            if (count != (long)state.samples) {
                throw new IllegalStateException(String.format("Expect %d bytes but got %d", size, count));
            }
        }
        if (!Arrays.equals(state.bytes, bao.toByteArray())) {
            throw new IllegalStateException("Incorrect result");
        }
    }

    @Benchmark
    public void async(StreamState state, Blackhole consumer) throws IOException {
        int size = state.bufferSize;
        long count = 0L;
        ByteArrayOutputStream bao = new ByteArrayOutputStream(state.samples);
        try (ClickHouseInputStream in = ClickHouseInputStream.of((InputStream)new ByteArrayInputStream(state.bytes), (int)size);
             ClickHouseOutputStream out = ClickHouseClient.getAsyncRequestOutputStream((ClickHouseConfig)state.config, (OutputStream)bao, null);){
            count = in.pipe(out);
            if (count != (long)state.samples) {
                throw new IllegalStateException(String.format("Expect %d bytes but got %d", size, count));
            }
        }
        if (!Arrays.equals(state.bytes, bao.toByteArray())) {
            throw new IllegalStateException("Incorrect result");
        }
    }

    @State(value=Scope.Thread)
    public static class StreamState
    extends BaseState {
        public int bufferSize;
        public int samples;
        public byte[] bytes;
        public ClickHouseConfig config;

        @Setup(value=Level.Trial)
        public void setupSamples() {
            this.bufferSize = Integer.getInteger("buffer", (int)((Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue()));
            this.samples = Integer.getInteger("samples", 500000);
            this.bytes = new byte[this.samples];
            HashMap<ClickHouseClientOption, Comparable<Boolean>> options = new HashMap<ClickHouseClientOption, Comparable<Boolean>>();
            options.put(ClickHouseClientOption.ASYNC, Boolean.valueOf(Boolean.parseBoolean(System.getProperty("async", "true"))));
            options.put(ClickHouseClientOption.REQUEST_BUFFERING, (Comparable<Boolean>)ClickHouseBufferingMode.valueOf((String)System.getProperty("mode", ClickHouseClientOption.REQUEST_BUFFERING.getDefaultValue().toString()).toUpperCase()));
            options.put(ClickHouseClientOption.BUFFER_SIZE, Integer.valueOf(this.bufferSize));
            options.put(ClickHouseClientOption.MAX_QUEUED_BUFFERS, Integer.getInteger("queue", (int)((Integer)ClickHouseClientOption.MAX_QUEUED_BUFFERS.getDefaultValue())));
            options.put(ClickHouseClientOption.COMPRESS, Boolean.valueOf(Boolean.parseBoolean(System.getProperty("compress", "false"))));
            options.put(ClickHouseClientOption.DECOMPRESS, Boolean.valueOf(Boolean.parseBoolean(System.getProperty("compress", "false"))));
            options.put(ClickHouseClientOption.USE_BLOCKING_QUEUE, Boolean.valueOf(Boolean.parseBoolean(System.getProperty("blocking", "true"))));
            this.config = new ClickHouseConfig(options, null, null, null);
        }

        @Setup(value=Level.Iteration)
        public void initStream() {
            new Random().nextBytes(this.bytes);
        }
    }
}

