/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.benchmark.jdbc;

import com.clickhouse.benchmark.jdbc.DriverBenchmark;
import com.clickhouse.benchmark.jdbc.DriverState;
import java.sql.Timestamp;
import java.util.Enumeration;
import org.openjdk.jmh.annotations.Benchmark;

public class Insertion
extends DriverBenchmark {
    @Benchmark
    public int insert10kUInt64Rows(DriverState state) throws Throwable {
        final int range = state.getRandomNumber();
        final int rows = state.getSampleSize() + range;
        return this.executeInsert(state, "insert into system.test_insert(i) values(?)", new Enumeration<Object[]>(){
            int counter = 0;

            @Override
            public boolean hasMoreElements() {
                return this.counter < rows;
            }

            @Override
            public Object[] nextElement() {
                return new Object[]{range + this.counter++};
            }
        });
    }

    @Benchmark
    public int insert10kStringRows(DriverState state) throws Throwable {
        final int range = state.getRandomNumber();
        final int rows = state.getSampleSize() + range;
        return this.executeInsert(state, "insert into system.test_insert(s) values(?)", new Enumeration<Object[]>(){
            int counter = 0;

            @Override
            public boolean hasMoreElements() {
                return this.counter < rows;
            }

            @Override
            public Object[] nextElement() {
                return new Object[]{String.valueOf(range + this.counter++)};
            }
        });
    }

    @Benchmark
    public int insert10kTimestampRows(DriverState state) throws Throwable {
        final int range = state.getRandomNumber();
        final int rows = state.getSampleSize() + range;
        return this.executeInsert(state, "insert into system.test_insert(t) values(?)", new Enumeration<Object[]>(){
            int counter = 0;

            @Override
            public boolean hasMoreElements() {
                return this.counter < rows;
            }

            @Override
            public Object[] nextElement() {
                return new Object[]{new Timestamp((long)range + (long)this.counter++)};
            }
        });
    }
}

