/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.benchmark.misc;

import com.clickhouse.benchmark.BaseState;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.data.ClickHouseBigDecimalValue;
import com.clickhouse.client.data.ClickHouseBigIntegerValue;
import com.clickhouse.client.data.ClickHouseByteValue;
import com.clickhouse.client.data.ClickHouseDateTimeValue;
import com.clickhouse.client.data.ClickHouseDateValue;
import com.clickhouse.client.data.ClickHouseDoubleValue;
import com.clickhouse.client.data.ClickHouseEnumValue;
import com.clickhouse.client.data.ClickHouseFloatValue;
import com.clickhouse.client.data.ClickHouseIntegerValue;
import com.clickhouse.client.data.ClickHouseIpv4Value;
import com.clickhouse.client.data.ClickHouseIpv6Value;
import com.clickhouse.client.data.ClickHouseLongValue;
import com.clickhouse.client.data.ClickHouseShortValue;
import com.clickhouse.client.data.ClickHouseStringValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Warmup(iterations=10, timeUnit=TimeUnit.SECONDS, time=1)
@Measurement(iterations=10, timeUnit=TimeUnit.SECONDS, time=1)
@Fork(value=2)
@Threads(value=-1)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
public class FactoryBenchmark {
    @Benchmark
    public void ifElse(FactoryState state, Blackhole consumer) {
        for (int i = 0; i < state.samples; ++i) {
            IfElseFactory f = new IfElseFactory();
            consumer.consume((Object)f.newValue(state.clazz));
        }
    }

    @Benchmark
    public void hashMap(FactoryState state, Blackhole consumer) {
        for (int i = 0; i < state.samples; ++i) {
            HashMapFactory f = new HashMapFactory();
            consumer.consume((Object)f.newValue(state.mappings, state.clazz));
        }
    }

    static class HashMapFactory {
        HashMapFactory() {
        }

        ClickHouseValue newValue(Map<Class<?>, Supplier<? extends ClickHouseValue>> mappings, Class<?> clazz) {
            Supplier<? extends ClickHouseValue> func = mappings.get(clazz);
            if (func == null) {
                throw new IllegalArgumentException("Unsupported type: " + clazz);
            }
            return func.get();
        }
    }

    static class IfElseFactory {
        IfElseFactory() {
        }

        ClickHouseValue newValue(Class<?> clazz) {
            if (Byte.class.equals(clazz)) {
                return ClickHouseByteValue.ofNull();
            }
            if (Short.class.equals(clazz)) {
                return ClickHouseShortValue.ofNull();
            }
            if (Integer.class.equals(clazz)) {
                return ClickHouseIntegerValue.ofNull();
            }
            if (Long.class.equals(clazz)) {
                return ClickHouseLongValue.ofNull((boolean)false);
            }
            if (Float.class.equals(clazz)) {
                return ClickHouseFloatValue.ofNull();
            }
            if (Double.class.equals(clazz)) {
                return ClickHouseDoubleValue.ofNull();
            }
            if (BigInteger.class.equals(clazz)) {
                return ClickHouseBigIntegerValue.ofNull();
            }
            if (BigDecimal.class.equals(clazz)) {
                return ClickHouseBigDecimalValue.ofNull();
            }
            if (Enum.class.equals(clazz)) {
                return ClickHouseEnumValue.ofNull();
            }
            if (Inet4Address.class.equals(clazz)) {
                return ClickHouseIpv4Value.ofNull();
            }
            if (Inet6Address.class.equals(clazz)) {
                return ClickHouseIpv6Value.ofNull();
            }
            if (LocalDate.class.equals(clazz)) {
                return ClickHouseDateValue.ofNull();
            }
            if (LocalTime.class.equals(clazz)) {
                return ClickHouseDateTimeValue.ofNull((int)0);
            }
            if (LocalDateTime.class.equals(clazz)) {
                return ClickHouseDateTimeValue.ofNull((int)0);
            }
            if (String.class.equals(clazz)) {
                return ClickHouseStringValue.ofNull();
            }
            throw new IllegalArgumentException("Unsupported type: " + clazz);
        }
    }

    @State(value=Scope.Thread)
    public static class FactoryState
    extends BaseState {
        public int samples;
        public Class<?> clazz;
        public Map<Class<?>, Supplier<? extends ClickHouseValue>> mappings;
        private List<Class<?>> classes;

        private static void add(Map<Class<?>, Supplier<? extends ClickHouseValue>> map, List<Class<?>> list, Class<?> clazz, Supplier<? extends ClickHouseValue> func) {
            if (map.put(clazz, func) != null) {
                throw new IllegalArgumentException("Duplicated key: " + clazz);
            }
            list.add(clazz);
        }

        @Setup(value=Level.Trial)
        public void setupSamples() {
            this.samples = 500000;
            HashMap map = new HashMap();
            ArrayList list = new ArrayList();
            FactoryState.add(map, list, Byte.class, () -> ClickHouseByteValue.ofNull());
            FactoryState.add(map, list, Short.class, () -> ClickHouseShortValue.ofNull());
            FactoryState.add(map, list, Integer.class, () -> ClickHouseIntegerValue.ofNull());
            FactoryState.add(map, list, Long.class, () -> ClickHouseLongValue.ofNull((boolean)false));
            FactoryState.add(map, list, Float.class, () -> ClickHouseFloatValue.ofNull());
            FactoryState.add(map, list, Double.class, () -> ClickHouseDoubleValue.ofNull());
            FactoryState.add(map, list, BigInteger.class, () -> ClickHouseBigIntegerValue.ofNull());
            FactoryState.add(map, list, BigDecimal.class, () -> ClickHouseBigDecimalValue.ofNull());
            FactoryState.add(map, list, Enum.class, () -> ClickHouseEnumValue.ofNull());
            FactoryState.add(map, list, Inet4Address.class, () -> ClickHouseIpv4Value.ofNull());
            FactoryState.add(map, list, Inet6Address.class, () -> ClickHouseIpv6Value.ofNull());
            FactoryState.add(map, list, LocalDate.class, () -> ClickHouseDateValue.ofNull());
            FactoryState.add(map, list, LocalTime.class, () -> ClickHouseDateTimeValue.ofNull((int)0));
            FactoryState.add(map, list, LocalDateTime.class, () -> ClickHouseDateTimeValue.ofNull((int)0));
            FactoryState.add(map, list, String.class, () -> ClickHouseStringValue.ofNull());
            this.mappings = Collections.unmodifiableMap(map);
            this.classes = Collections.unmodifiableList(new ArrayList(list));
        }

        @Setup(value=Level.Iteration)
        public void initValueClass() {
            this.clazz = this.classes.get(this.getRandomNumber(this.classes.size()));
        }
    }
}

