/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.benchmark.jdbc;

import com.clickhouse.benchmark.BaseState;
import com.clickhouse.benchmark.Constants;
import com.clickhouse.benchmark.ServerState;
import com.clickhouse.benchmark.jdbc.ConsumeValueFunction;
import com.clickhouse.benchmark.jdbc.JdbcDriver;
import com.clickhouse.benchmark.jdbc.SupplyValueFunction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
public class DriverState
extends BaseState {
    @Param(value={"clickhouse4j", "clickhouse-http-jdbc", "clickhouse-grpc-jdbc", "clickhouse-jdbc", "clickhouse-native-jdbc", "mariadb-java-client", "mysql-connector-java", "postgresql-jdbc"})
    private String client;
    @Param(value={"reuse", "new"})
    private String connection;
    @Param(value={"normal", "prepared"})
    private String statement;
    @Param(value={"default", "string", "object"})
    private String type;
    private Driver driver;
    private String url;
    private Connection conn;
    private int randomSample;
    private int randomNum;

    @Setup(value=Level.Trial)
    public void doSetup(ServerState serverState) throws Exception {
        JdbcDriver jdbcDriver = JdbcDriver.from(this.client);
        String compression = String.valueOf(Boolean.parseBoolean(System.getProperty("compression", "true")));
        String additional = System.getProperty("additional", "");
        try {
            this.driver = (Driver)Class.forName(jdbcDriver.getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.url = String.format(jdbcDriver.getUrlTemplate(), serverState.getHost(), serverState.getPort(jdbcDriver.getDefaultPort()), serverState.getDatabase(), serverState.getUser(), serverState.getPassword(), compression, additional);
            this.conn = this.driver.connect(this.url, new Properties());
            try (Statement s = this.conn.createStatement();){
                s.execute("truncate table if exists system.test_insert");
                s.execute("create table if not exists system.test_insert(b String, i Nullable(UInt64), s Nullable(String), t Nullable(DateTime))engine=Memory");
            }
            if (!"reuse".equalsIgnoreCase(this.connection)) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @TearDown(value=Level.Trial)
    public void doTearDown(ServerState serverState) throws SQLException {
        this.dispose();
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    @Setup(value=Level.Iteration)
    public void prepare() {
        if (!"reuse".equalsIgnoreCase(this.connection)) {
            try {
                this.conn = this.driver.connect(this.url, new Properties());
            }
            catch (SQLException e) {
                throw new IllegalStateException("Failed to create new connection", e);
            }
        }
        this.randomSample = this.getRandomNumber(Constants.SAMPLE_SIZE);
        this.randomNum = this.getRandomNumber(Constants.FLOATING_RANGE);
    }

    @TearDown(value=Level.Iteration)
    public void shutdown() {
        if (!"reuse".equalsIgnoreCase(this.connection)) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Failed to close connection", e);
            }
            finally {
                this.conn = null;
            }
        }
    }

    public int getSampleSize() {
        return Constants.SAMPLE_SIZE;
    }

    public int getRandomSample() {
        return this.randomSample;
    }

    public int getRandomNumber() {
        return this.randomNum;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public boolean usePreparedStatement() {
        return "prepared".equalsIgnoreCase(this.statement);
    }

    public ConsumeValueFunction getConsumeFunction(ConsumeValueFunction defaultFunc) {
        if ("string".equals(this.type)) {
            return (b, r, l, i) -> b.consume((Object)r.getString(i));
        }
        if ("object".equals(this.type)) {
            return (b, r, l, i) -> b.consume(r.getObject(i));
        }
        if (defaultFunc == null) {
            return (b, r, l, i) -> b.consume(i);
        }
        return defaultFunc;
    }

    public SupplyValueFunction getSupplyFunction(SupplyValueFunction defaultFunc) {
        if ("string".equals(this.type)) {
            return (p, v, l, i) -> p.setString(i, v != null ? v.toString() : null);
        }
        if ("object".equals(this.type)) {
            return (p, v, l, i) -> p.setObject(i, v);
        }
        if (defaultFunc == null) {
            return (p, v, l, i) -> p.setObject(i, v);
        }
        return defaultFunc;
    }
}

