/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.pushtemplates;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import androidx.core.app.RemoteInput;
import com.clevertap.android.pushtemplates.PTLog;
import com.clevertap.android.pushtemplates.R;
import com.clevertap.android.pushtemplates.TemplateType;
import com.clevertap.android.pushtemplates.Utils;
import com.clevertap.android.pushtemplates.content.PendingIntentFactory;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.interfaces.NotificationHandler;
import com.clevertap.android.sdk.pushnotification.LaunchPendingIntentFactory;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class PushTemplateReceiver
extends BroadcastReceiver {
    boolean clicked1 = true;
    boolean clicked2 = true;
    boolean clicked3 = true;
    boolean clicked4 = true;
    boolean clicked5 = true;
    boolean close = true;
    private CleverTapAPI cleverTapAPI;
    private RemoteViews contentViewBig;
    private RemoteViews contentViewSmall;
    private RemoteViews contentViewRating;
    private RemoteViews contentViewManualCarousel;
    private String pt_id;
    private TemplateType templateType;
    private String pt_title;
    private String pt_msg;
    private String pt_msg_summary;
    private String pt_rating_default_dl;
    private ArrayList<String> imageList = new ArrayList();
    private ArrayList<String> deepLinkList = new ArrayList();
    private ArrayList<String> bigTextList = new ArrayList();
    private ArrayList<String> smallTextList = new ArrayList();
    private ArrayList<String> priceList = new ArrayList();
    private int smallIcon = 0;
    private boolean requiresChannelId;
    private NotificationManager notificationManager;
    private String pt_product_display_linear;
    private String pt_big_img_alt;
    private String pt_small_icon_clr;
    private String pt_big_img;
    private String pt_meta_clr;
    private boolean pt_dismiss_intent;
    private String pt_rating_toast;
    private String pt_subtitle;
    private CleverTapInstanceConfig config;

    public void onReceive(final Context context, final Intent intent) {
        Utils.createSilentNotificationChannel(context);
        if (intent.getExtras() != null) {
            final Bundle extras = intent.getExtras();
            this.cleverTapAPI = CleverTapAPI.getGlobalInstance((Context)context, (String)extras.getString("wzrk_acct_id"));
            this.pt_id = intent.getStringExtra("pt_id");
            this.pt_msg = extras.getString("pt_msg");
            this.pt_msg_summary = extras.getString("pt_msg_summary");
            this.pt_title = extras.getString("pt_title");
            this.pt_rating_default_dl = extras.getString("pt_default_dl");
            this.imageList = Utils.getImageListFromExtras(extras);
            this.deepLinkList = Utils.getDeepLinkListFromExtras(extras);
            this.bigTextList = Utils.getBigTextFromExtras(extras);
            this.smallTextList = Utils.getSmallTextFromExtras(extras);
            this.priceList = Utils.getPriceFromExtras(extras);
            this.pt_product_display_linear = extras.getString("pt_product_display_linear");
            this.notificationManager = (NotificationManager)context.getSystemService("notification");
            this.pt_big_img_alt = extras.getString("pt_big_img_alt");
            this.pt_small_icon_clr = extras.getString("pt_small_icon_clr");
            this.requiresChannelId = Build.VERSION.SDK_INT >= 26;
            this.pt_dismiss_intent = extras.getBoolean("pt_dismiss_intent", false);
            this.pt_rating_toast = extras.getString("pt_rating_toast");
            this.pt_subtitle = extras.getString("pt_subtitle");
            this.setKeysFromDashboard(extras);
            if (this.pt_id != null) {
                this.templateType = TemplateType.fromString(this.pt_id);
            }
            if (this.cleverTapAPI != null) {
                try {
                    this.config = this.cleverTapAPI.getCoreState().getConfig();
                    Task task = CTExecutorFactory.executors((CleverTapInstanceConfig)this.config).postAsyncSafelyTask();
                    task.execute("PushTemplateReceiver#renderNotification", (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try {
                                if (PushTemplateReceiver.this.pt_dismiss_intent) {
                                    Utils.deleteSilentNotificationChannel(context);
                                    Utils.deleteImageFromStorage(context, intent);
                                    return null;
                                }
                                if (PushTemplateReceiver.this.templateType != null) {
                                    switch (PushTemplateReceiver.this.templateType) {
                                        case RATING: {
                                            PushTemplateReceiver.this.handleRatingNotification(context, extras, intent);
                                            break;
                                        }
                                        case FIVE_ICONS: {
                                            PushTemplateReceiver.this.handleFiveCTANotification(context, extras);
                                            break;
                                        }
                                        case PRODUCT_DISPLAY: {
                                            PushTemplateReceiver.this.handleProductDisplayNotification(context, extras);
                                            break;
                                        }
                                        case INPUT_BOX: {
                                            PushTemplateReceiver.this.handleInputBoxNotification(context, extras, intent);
                                            break;
                                        }
                                        case MANUAL_CAROUSEL: {
                                            PushTemplateReceiver.this.handleManualCarouselNotification(context, extras);
                                        }
                                    }
                                }
                            }
                            catch (Throwable t) {
                                PTLog.verbose("Couldn't render notification: " + t.getLocalizedMessage());
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    PTLog.verbose("Couldn't render notification: " + e.getLocalizedMessage());
                }
            } else {
                PTLog.verbose("clevertap instance is null, not running PushTemplateReceiver#renderNotification");
            }
        }
    }

    private void handleManualCarouselNotification(Context context, Bundle extras) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                int newPosition;
                int notificationId = extras.getInt("notificationId");
                Notification notification = Utils.getNotificationById(context, notificationId);
                if (notification == null) {
                    PTLog.verbose("Manual Carousel Notification is null, returning");
                    return;
                }
                this.contentViewManualCarousel = notification.bigContentView;
                this.contentViewSmall = notification.contentView;
                this.setCustomContentViewBasicKeys(this.contentViewManualCarousel, context);
                boolean rightSwipe = extras.getBoolean("right_swipe");
                this.imageList = extras.getStringArrayList("pt_image_list");
                this.deepLinkList = extras.getStringArrayList("pt_deeplink_list");
                int currPosition = extras.getInt("pt_manual_carousel_current");
                if (rightSwipe) {
                    this.contentViewManualCarousel.showNext(R.id.carousel_image);
                    this.contentViewManualCarousel.showNext(R.id.carousel_image_right);
                    this.contentViewManualCarousel.showNext(R.id.carousel_image_left);
                    newPosition = currPosition == this.imageList.size() - 1 ? 0 : currPosition + 1;
                } else {
                    this.contentViewManualCarousel.showPrevious(R.id.carousel_image);
                    this.contentViewManualCarousel.showPrevious(R.id.carousel_image_right);
                    this.contentViewManualCarousel.showPrevious(R.id.carousel_image_left);
                    newPosition = currPosition == 0 ? this.imageList.size() - 1 : currPosition - 1;
                }
                String dl = "";
                if (this.deepLinkList != null && this.deepLinkList.size() == this.imageList.size()) {
                    dl = this.deepLinkList.get(newPosition);
                } else if (this.deepLinkList != null && this.deepLinkList.size() == 1) {
                    dl = this.deepLinkList.get(0);
                } else if (this.deepLinkList != null && this.deepLinkList.size() > newPosition) {
                    dl = this.deepLinkList.get(newPosition);
                } else if (this.deepLinkList != null && this.deepLinkList.size() < newPosition) {
                    dl = this.deepLinkList.get(0);
                }
                extras.putInt("pt_manual_carousel_current", newPosition);
                extras.remove("right_swipe");
                extras.putString("wzrk_dl", dl);
                extras.putInt("manual_carousel_from", currPosition);
                this.contentViewManualCarousel.setOnClickPendingIntent(R.id.rightArrowPos0, PendingIntentFactory.getPendingIntent(context, notificationId, extras, false, 4, null));
                this.contentViewManualCarousel.setOnClickPendingIntent(R.id.leftArrowPos0, PendingIntentFactory.getPendingIntent(context, notificationId, extras, false, 5, null));
                PendingIntent pIntent = PendingIntentFactory.getPendingIntent(context, notificationId, extras, true, 3, null);
                NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context, notification);
                PendingIntent dIntent = PendingIntentFactory.getPendingIntent(context, notificationId, extras, false, 6, null);
                this.setSmallIcon(context);
                this.setNotificationBuilderBasics(notificationBuilder, this.contentViewSmall, this.contentViewManualCarousel, this.pt_title, pIntent, dIntent);
                notification = notificationBuilder.build();
                this.notificationManager.notify(notificationId, notification);
            } else {
                extras.putString("extras_from", "PTReceiver");
                NotificationHandler notificationHandler = CleverTapAPI.getNotificationHandler();
                if (notificationHandler != null) {
                    notificationHandler.onMessageReceived(context, extras, "FCM");
                }
            }
        }
        catch (Throwable t) {
            PTLog.verbose("Error creating manual carousel notification ", t);
        }
    }

    private void handleInputBoxNotification(Context context, Bundle extras, Intent intent) {
        Bundle remoteInput = RemoteInput.getResultsFromIntent((Intent)intent);
        Intent dismissIntent = new Intent(context, PushTemplateReceiver.class);
        PendingIntent dIntent = PendingIntentFactory.setDismissIntent(context, extras, dismissIntent);
        this.config = (CleverTapInstanceConfig)extras.getParcelable("config");
        if (remoteInput != null) {
            CharSequence reply = remoteInput.getCharSequence("pt_input_reply");
            int notificationId = extras.getInt("notificationId");
            if (reply != null) {
                PTLog.verbose("Processing Input from Input Template");
                extras.putString("pt_input_reply", reply.toString());
                Utils.raiseCleverTapEvent(context, this.config, extras, "pt_input_reply");
                NotificationCompat.Builder repliedNotification = this.requiresChannelId ? new NotificationCompat.Builder(context, "pt_silent_sound_channel") : new NotificationCompat.Builder(context);
                this.setSmallIcon(context);
                if (Build.VERSION.SDK_INT >= 31) {
                    repliedNotification.setSubText((CharSequence)this.pt_subtitle);
                }
                repliedNotification.setSmallIcon(this.smallIcon).setContentTitle((CharSequence)this.pt_title).setContentText((CharSequence)extras.getString("pt_input_feedback")).setTimeoutAfter(1300L).setDeleteIntent(dIntent).setWhen(System.currentTimeMillis()).setAutoCancel(true);
                this.setStandardViewBigImageStyle(this.pt_big_img_alt, extras, context, repliedNotification);
                Notification notification = repliedNotification.build();
                this.notificationManager.notify(notificationId, notification);
                if (Build.VERSION.SDK_INT < 31 && (extras.getString("pt_input_auto_open") != null || extras.getBoolean("pt_input_auto_open"))) {
                    Intent launchIntent;
                    try {
                        Thread.sleep(1300L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (extras.containsKey("wzrk_dl") && extras.getString("wzrk_dl") != null) {
                        launchIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)intent.getStringExtra("wzrk_dl")));
                        Utils.setPackageNameFromResolveInfoList(context, launchIntent);
                    } else {
                        launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                        if (launchIntent == null) {
                            return;
                        }
                    }
                    launchIntent.putExtras(extras);
                    launchIntent.putExtra("pt_reply", reply);
                    launchIntent.removeExtra("wzrk_acts");
                    launchIntent.setFlags(0x34000000);
                    context.startActivity(launchIntent);
                }
            } else {
                PTLog.verbose("PushTemplateReceiver: Input is Empty");
            }
        }
    }

    private void handleRatingNotification(Context context, Bundle extras, Intent intent) {
        try {
            int notificationId = extras.getInt("notificationId");
            if (extras.getBoolean("default_dl", false)) {
                this.config = (CleverTapInstanceConfig)extras.getParcelable("config");
                this.notificationManager.cancel(notificationId);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName("com.clevertap.android.sdk.pushnotification.CTNotificationIntentService");
                }
                catch (ClassNotFoundException ex) {
                    PTLog.debug("No Intent Service found");
                }
                boolean isPTIntentServiceAvailable = com.clevertap.android.sdk.Utils.isServiceAvailable((Context)context, clazz);
                if (isPTIntentServiceAvailable) {
                    Intent launchIntent = new Intent("com.clevertap.PUSH_EVENT");
                    launchIntent.setPackage(context.getPackageName());
                    launchIntent.putExtra("ct_type", "com.clevertap.ACTION_BUTTON_CLICK");
                    launchIntent.putExtras(extras);
                    launchIntent.putExtra("dl", this.pt_rating_default_dl);
                    context.startService(launchIntent);
                } else {
                    Intent launchIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.pt_rating_default_dl));
                    launchIntent.removeExtra("wzrk_acts");
                    launchIntent.putExtra("wzrk_from", "CTPushNotificationReceiver");
                    launchIntent.setFlags(0x34000000);
                    Utils.raiseNotificationClicked(context, extras, this.config);
                    launchIntent.putExtras(extras);
                    launchIntent.putExtra("wzrk_dl", this.pt_rating_default_dl);
                    context.startActivity(launchIntent);
                }
                return;
            }
            String pt_dl_clicked = this.deepLinkList.get(0);
            if (1 == extras.getInt("clickedStar", 0)) {
                extras.putString("wzrk_c2a", "rating_1");
                if (this.deepLinkList.size() > 0) {
                    pt_dl_clicked = this.deepLinkList.get(0);
                }
            }
            if (2 == extras.getInt("clickedStar", 0)) {
                extras.putString("wzrk_c2a", "rating_2");
                pt_dl_clicked = this.deepLinkList.size() > 1 ? this.deepLinkList.get(1) : this.deepLinkList.get(0);
            }
            if (3 == extras.getInt("clickedStar", 0)) {
                extras.putString("wzrk_c2a", "rating_3");
                pt_dl_clicked = this.deepLinkList.size() > 2 ? this.deepLinkList.get(2) : this.deepLinkList.get(0);
            }
            if (4 == extras.getInt("clickedStar", 0)) {
                extras.putString("wzrk_c2a", "rating_4");
                pt_dl_clicked = this.deepLinkList.size() > 3 ? this.deepLinkList.get(3) : this.deepLinkList.get(0);
            }
            if (5 == extras.getInt("clickedStar", 0)) {
                extras.putString("wzrk_c2a", "rating_5");
                pt_dl_clicked = this.deepLinkList.size() > 4 ? this.deepLinkList.get(4) : this.deepLinkList.get(0);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                Notification notification = Utils.getNotificationById(context, notificationId);
                if (notification == null) {
                    PTLog.verbose("Rating Notification is null, returning");
                    return;
                }
                this.contentViewRating = notification.bigContentView;
                this.contentViewSmall = notification.contentView;
                if (1 == extras.getInt("clickedStar", 0)) {
                    this.contentViewRating.setImageViewResource(R.id.star1, R.drawable.pt_star_filled);
                    this.clicked1 = false;
                } else {
                    this.contentViewRating.setImageViewResource(R.id.star1, R.drawable.pt_star_outline);
                }
                if (2 == extras.getInt("clickedStar", 0)) {
                    this.contentViewRating.setImageViewResource(R.id.star1, R.drawable.pt_star_filled);
                    this.contentViewRating.setImageViewResource(R.id.star2, R.drawable.pt_star_filled);
                    this.clicked2 = false;
                } else {
                    this.contentViewRating.setImageViewResource(R.id.star2, R.drawable.pt_star_outline);
                }
                if (3 == extras.getInt("clickedStar", 0)) {
                    this.contentViewRating.setImageViewResource(R.id.star1, R.drawable.pt_star_filled);
                    this.contentViewRating.setImageViewResource(R.id.star2, R.drawable.pt_star_filled);
                    this.contentViewRating.setImageViewResource(R.id.star3, R.drawable.pt_star_filled);
                    this.clicked3 = false;
                } else {
                    this.contentViewRating.setImageViewResource(R.id.star3, R.drawable.pt_star_outline);
                }
                if (4 == extras.getInt("clickedStar", 0)) {
                    this.contentViewRating.setImageViewResource(R.id.star1, R.drawable.pt_star_filled);
                    this.contentViewRating.setImageViewResource(R.id.star2, R.drawable.pt_star_filled);
                    this.contentViewRating.setImageViewResource(R.id.star3, R.drawable.pt_star_filled);
                    this.contentViewRating.setImageViewResource(R.id.star4, R.drawable.pt_star_filled);
                    this.clicked4 = false;
                } else {
                    this.contentViewRating.setImageViewResource(R.id.star4, R.drawable.pt_star_outline);
                }
                if (5 == extras.getInt("clickedStar", 0)) {
                    this.contentViewRating.setImageViewResource(R.id.star1, R.drawable.pt_star_filled);
                    this.contentViewRating.setImageViewResource(R.id.star2, R.drawable.pt_star_filled);
                    this.contentViewRating.setImageViewResource(R.id.star3, R.drawable.pt_star_filled);
                    this.contentViewRating.setImageViewResource(R.id.star4, R.drawable.pt_star_filled);
                    this.contentViewRating.setImageViewResource(R.id.star5, R.drawable.pt_star_filled);
                    this.clicked5 = false;
                } else {
                    this.contentViewRating.setImageViewResource(R.id.star5, R.drawable.pt_star_outline);
                }
                this.cancelRatingClickIntents(context, intent);
                extras.putString("wzrk_dl", pt_dl_clicked);
                this.contentViewRating.setOnClickPendingIntent(R.id.tVRatingConfirmation, LaunchPendingIntentFactory.getActivityIntent((Bundle)extras, (Context)context));
                this.setSmallIcon(context);
                NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context, notification);
                Intent dismissIntent = new Intent(context, PushTemplateReceiver.class);
                PendingIntent dIntent = PendingIntentFactory.setDismissIntent(context, extras, dismissIntent);
                if (this.notificationManager != null) {
                    notificationBuilder.setSmallIcon(this.smallIcon).setCustomContentView(this.contentViewSmall).setCustomBigContentView(this.contentViewRating).setContentTitle((CharSequence)this.pt_title).setDeleteIntent(dIntent).setAutoCancel(true);
                    notification = notificationBuilder.build();
                    this.notificationManager.notify(notificationId, notification);
                }
                Utils.raiseCleverTapEvent(context, this.config, "Rating Submitted", Utils.convertRatingBundleObjectToHashMap(extras));
                if (Build.VERSION.SDK_INT < 31) {
                    this.handleRatingDeepLink(context, extras, notificationId, pt_dl_clicked, this.config);
                }
            } else {
                extras.putString("extras_from", "PTReceiver");
                Bundle clonedExtras = (Bundle)extras.clone();
                NotificationHandler notificationHandler = CleverTapAPI.getNotificationHandler();
                if (notificationHandler != null) {
                    notificationHandler.onMessageReceived(context, extras, "FCM");
                    clonedExtras.putString("wzrk_dl", pt_dl_clicked);
                    Utils.raiseCleverTapEvent(context, this.config, "Rating Submitted", Utils.convertRatingBundleObjectToHashMap(extras));
                    this.handleRatingDeepLink(context, clonedExtras, notificationId, pt_dl_clicked, this.config);
                }
            }
        }
        catch (Throwable t) {
            PTLog.verbose("Error creating rating notification ", t);
        }
    }

    private void cancelRatingClickIntents(Context context, Intent intent) {
        int[] requestCodes;
        int flagsLaunchPendingIntent = 0x8000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flagsLaunchPendingIntent |= 0x4000000;
        }
        for (int requestCode : requestCodes = intent.getIntArrayExtra("requestCodes")) {
            PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)flagsLaunchPendingIntent).cancel();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void handleRatingDeepLink(Context context, Bundle extras, int notificationId, String pt_dl_clicked, CleverTapInstanceConfig config) throws InterruptedException {
        Intent launchIntent;
        Thread.sleep(1000L);
        this.notificationManager.cancel(notificationId);
        this.setToast(context, this.pt_rating_toast, config);
        Intent it = new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        context.sendBroadcast(it);
        if (extras.containsKey("wzrk_dl")) {
            launchIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)extras.getString("wzrk_dl")));
            com.clevertap.android.sdk.Utils.setPackageNameFromResolveInfoList((Context)context, (Intent)launchIntent);
        } else {
            launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            if (launchIntent == null) {
                return;
            }
        }
        launchIntent.putExtras(extras);
        launchIntent.putExtra("wzrk_dl", pt_dl_clicked);
        launchIntent.removeExtra("wzrk_acts");
        launchIntent.putExtra("wzrk_from", "CTPushNotificationReceiver");
        launchIntent.setFlags(0x34000000);
        context.startActivity(launchIntent);
    }

    private void handleProductDisplayNotification(Context context, Bundle extras) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                int notificationId = extras.getInt("notificationId");
                Notification notification = Utils.getNotificationById(context, notificationId);
                if (notification == null) {
                    PTLog.verbose("Product Display Notification is null, returning");
                    return;
                }
                this.contentViewBig = notification.bigContentView;
                this.contentViewSmall = notification.contentView;
                boolean isLinear = false;
                if (this.pt_product_display_linear != null && !this.pt_product_display_linear.isEmpty()) {
                    isLinear = true;
                }
                this.setCustomContentViewBasicKeys(this.contentViewBig, context);
                if (!isLinear) {
                    this.setCustomContentViewBasicKeys(this.contentViewSmall, context);
                }
                int currentPosition = extras.getInt("pt_current_position");
                this.contentViewBig.setDisplayedChild(R.id.carousel_image, currentPosition);
                this.imageList = extras.getStringArrayList("pt_image_list");
                this.deepLinkList = extras.getStringArrayList("pt_deeplink_list");
                this.bigTextList = extras.getStringArrayList("pt_big_text_list");
                this.smallTextList = extras.getStringArrayList("pt_small_text_list");
                this.priceList = extras.getStringArrayList("pt_price_list");
                String dl = this.deepLinkList.get(currentPosition);
                if (!isLinear) {
                    this.contentViewBig.setTextViewText(R.id.title, (CharSequence)this.bigTextList.get(currentPosition));
                } else {
                    this.contentViewBig.setTextViewText(R.id.product_name, (CharSequence)this.bigTextList.get(currentPosition));
                }
                this.contentViewBig.setTextViewText(R.id.msg, (CharSequence)this.smallTextList.get(currentPosition));
                this.contentViewBig.setTextViewText(R.id.product_price, (CharSequence)this.priceList.get(currentPosition));
                extras.remove("pt_current_position");
                Bundle bundleBuyNow = (Bundle)extras.clone();
                bundleBuyNow.putBoolean("img1", true);
                bundleBuyNow.putInt("notificationId", notificationId);
                bundleBuyNow.putString("pt_buy_now_dl", dl);
                bundleBuyNow.putBoolean("buynow", true);
                this.contentViewBig.setOnClickPendingIntent(R.id.product_action, PendingIntentFactory.getCtaLaunchPendingIntent(context, bundleBuyNow, dl, notificationId));
                NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context, notification);
                Bundle bundleLaunchIntent = (Bundle)extras.clone();
                bundleLaunchIntent.putString("wzrk_dl", dl);
                PendingIntent pIntent = PendingIntentFactory.getPendingIntent(context, notificationId, bundleLaunchIntent, true, 20, null);
                if (this.notificationManager != null) {
                    Intent dismissIntent = new Intent(context, PushTemplateReceiver.class);
                    PendingIntent dIntent = PendingIntentFactory.setDismissIntent(context, extras, dismissIntent);
                    this.setSmallIcon(context);
                    this.setNotificationBuilderBasics(notificationBuilder, this.contentViewSmall, this.contentViewBig, this.pt_title, pIntent, dIntent);
                    notification = notificationBuilder.build();
                    this.notificationManager.notify(notificationId, notification);
                }
            } else {
                extras.putString("extras_from", "PTReceiver");
                NotificationHandler notificationHandler = CleverTapAPI.getNotificationHandler();
                if (notificationHandler != null) {
                    notificationHandler.onMessageReceived(context, extras, "FCM");
                }
            }
        }
        catch (Throwable t) {
            PTLog.verbose("Error creating product display notification ", t);
        }
    }

    private void handleFiveCTANotification(Context context, Bundle extras) {
        String dl = null;
        int notificationId = extras.getInt("notificationId");
        extras.putString("wzrk_dl", dl);
        if (this.close == extras.getBoolean("close")) {
            extras.putString("wzrk_c2a", "5cta_close");
            this.notificationManager.cancel(notificationId);
        }
        Utils.raiseNotificationClicked(context, extras, this.config);
    }

    private void setNotificationBuilderBasics(NotificationCompat.Builder notificationBuilder, RemoteViews contentViewSmall, RemoteViews contentViewBig, String pt_title, PendingIntent pIntent, PendingIntent dIntent) {
        notificationBuilder.setSmallIcon(this.smallIcon).setCustomContentView(contentViewSmall).setCustomBigContentView(contentViewBig).setContentTitle((CharSequence)Html.fromHtml((String)pt_title)).setDeleteIntent(dIntent).setContentIntent(pIntent).setDefaults(5).setWhen(System.currentTimeMillis()).setAutoCancel(true);
    }

    private void setCustomContentViewBasicKeys(RemoteViews contentView, Context context) {
        contentView.setTextViewText(R.id.app_name, (CharSequence)Utils.getApplicationName(context));
        contentView.setTextViewText(R.id.timestamp, (CharSequence)Utils.getTimeStamp(context));
        if (this.pt_subtitle != null && !this.pt_subtitle.isEmpty()) {
            if (Build.VERSION.SDK_INT >= 24) {
                contentView.setTextViewText(R.id.subtitle, (CharSequence)Html.fromHtml((String)this.pt_subtitle, (int)0));
            } else {
                contentView.setTextViewText(R.id.subtitle, (CharSequence)Html.fromHtml((String)this.pt_subtitle));
            }
        } else {
            contentView.setViewVisibility(R.id.subtitle, 8);
            contentView.setViewVisibility(R.id.sep_subtitle, 8);
        }
        if (this.pt_meta_clr != null && !this.pt_meta_clr.isEmpty()) {
            contentView.setTextColor(R.id.app_name, Utils.getColour(this.pt_meta_clr, "#A6A6A6"));
            contentView.setTextColor(R.id.timestamp, Utils.getColour(this.pt_meta_clr, "#A6A6A6"));
            contentView.setTextColor(R.id.subtitle, Utils.getColour(this.pt_meta_clr, "#A6A6A6"));
        }
    }

    private void setStandardViewBigImageStyle(String imgUrl, Bundle extras, Context context, NotificationCompat.Builder notificationBuilder) {
        NotificationCompat.BigTextStyle bigPictureStyle;
        if (imgUrl != null && imgUrl.startsWith("http")) {
            try {
                Bitmap bpMap = Utils.getNotificationBitmap(imgUrl, false, context);
                if (bpMap == null) {
                    throw new Exception("Failed to fetch big picture!");
                }
                bigPictureStyle = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)extras.getString("pt_input_feedback")).bigPicture(bpMap);
            }
            catch (Throwable t) {
                bigPictureStyle = new NotificationCompat.BigTextStyle().bigText((CharSequence)extras.getString("pt_input_feedback"));
                PTLog.verbose("Falling back to big text notification, couldn't fetch big picture", t);
            }
        } else {
            bigPictureStyle = new NotificationCompat.BigTextStyle().bigText((CharSequence)extras.getString("pt_input_feedback"));
        }
        notificationBuilder.setStyle((NotificationCompat.Style)bigPictureStyle);
    }

    private void setSmallIcon(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), 128);
            Bundle metaData = ai.metaData;
            String x = Utils._getManifestStringValueForKey(metaData, "CLEVERTAP_NOTIFICATION_ICON");
            if (x == null) {
                throw new IllegalArgumentException();
            }
            this.smallIcon = context.getResources().getIdentifier(x, "drawable", context.getPackageName());
            if (this.smallIcon == 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (Throwable t) {
            this.smallIcon = Utils.getAppIconAsIntId(context);
        }
    }

    private void setKeysFromDashboard(Bundle extras) {
        if (this.pt_title == null || this.pt_title.isEmpty()) {
            this.pt_title = extras.getString("nt");
        }
        if (this.pt_msg == null || this.pt_msg.isEmpty()) {
            this.pt_msg = extras.getString("nm");
        }
        if (this.pt_msg_summary == null || this.pt_msg_summary.isEmpty()) {
            this.pt_msg_summary = extras.getString("wzrk_nms");
        }
        if (this.pt_big_img == null || this.pt_big_img.isEmpty()) {
            this.pt_big_img = extras.getString("wzrk_bp");
        }
        if (this.pt_rating_default_dl == null || this.pt_rating_default_dl.isEmpty()) {
            this.pt_rating_default_dl = extras.getString("wzrk_dl");
        }
        if (this.pt_meta_clr == null || this.pt_meta_clr.isEmpty()) {
            this.pt_meta_clr = extras.getString("wzrk_clr");
        }
        if (this.pt_small_icon_clr == null || this.pt_small_icon_clr.isEmpty()) {
            this.pt_small_icon_clr = extras.getString("wzrk_clr");
        }
        if (this.pt_subtitle == null || this.pt_subtitle.isEmpty()) {
            this.pt_subtitle = extras.getString("wzrk_st");
        }
        if (this.pt_small_icon_clr == null || this.pt_small_icon_clr.isEmpty()) {
            this.pt_small_icon_clr = extras.getString("wzrk_clr");
        }
    }

    private void setToast(Context context, String message, CleverTapInstanceConfig config) {
        if (message != null && !message.isEmpty()) {
            Utils.showToast(context, message, config);
        }
    }
}

