/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.json.JSONObject;

@WorkerThread
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FileUtils {
    private final CleverTapInstanceConfig config;
    private final Context context;

    public FileUtils(@NonNull Context context, @NonNull CleverTapInstanceConfig config) {
        this.context = context;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDirectory(String dirName) {
        if (TextUtils.isEmpty((CharSequence)dirName)) {
            return;
        }
        try {
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                File file = new File(this.context.getFilesDir(), dirName);
                if (file.exists() && file.isDirectory()) {
                    String[] children;
                    for (String child : children = file.list()) {
                        boolean deleted = new File(file, child).delete();
                        this.config.getLogger().verbose(this.config.getAccountId(), "File" + child + " isDeleted:" + deleted);
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            this.config.getLogger().verbose(this.config.getAccountId(), "deleteDirectory: failed: " + dirName, e);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return;
        }
        try {
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                File file = new File(this.context.getFilesDir(), fileName);
                if (file.exists()) {
                    if (file.delete()) {
                        this.config.getLogger().verbose(this.config.getAccountId(), "File Deleted:" + fileName);
                    } else {
                        this.config.getLogger().verbose(this.config.getAccountId(), "Failed to delete file" + fileName);
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            this.config.getLogger().verbose(this.config.getAccountId(), "deleteFile: failed: " + fileName, e);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFromFile(String fileNameWithPath) throws IOException {
        String content = "";
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String receiveString;
            String yourFilePath = this.context.getFilesDir() + "/" + fileNameWithPath;
            File yourFile = new File(yourFilePath);
            inputStream = new FileInputStream(yourFile);
            StringBuilder stringBuilder = new StringBuilder();
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((receiveString = bufferedReader.readLine()) != null) {
                stringBuilder.append(receiveString);
            }
            inputStream.close();
            content = stringBuilder.toString();
        }
        catch (Exception e) {
            this.config.getLogger().verbose(this.config.getAccountId(), "readFromFile: failed for " + fileNameWithPath, e);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJsonToFile(String dirName, String fileName, JSONObject jsonObject) throws IOException {
        try (OutputStreamWriter writer = null;){
            if (jsonObject == null || TextUtils.isEmpty((CharSequence)dirName) || TextUtils.isEmpty((CharSequence)fileName)) {
                return;
            }
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                File file;
                block13: {
                    file = new File(this.context.getFilesDir(), dirName);
                    if (file.exists() || file.mkdir()) break block13;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                File file1 = new File(file, fileName);
                writer = new FileWriter(file1, false);
                writer.append(jsonObject.toString());
                writer.flush();
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        {
            return;
        }
    }
}

