/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.task;

import com.clevertap.android.sdk.Logger;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

class PostAsyncSafelyExecutor
implements ExecutorService {
    private long EXECUTOR_THREAD_ID = 0L;
    private static final String TAG = "PostAsyncSafelyExecutor";
    ExecutorService executor = Executors.newSingleThreadExecutor();

    PostAsyncSafelyExecutor() {
    }

    void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(final Runnable task) {
        boolean executeSync;
        if (task == null) {
            throw new NullPointerException("PostAsyncSafelyExecutor#execute: task can't ne null");
        }
        boolean bl = executeSync = Thread.currentThread().getId() == this.EXECUTOR_THREAD_ID;
        if (executeSync) {
            task.run();
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    PostAsyncSafelyExecutor.this.EXECUTOR_THREAD_ID = Thread.currentThread().getId();
                    task.run();
                }
            });
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("PostAsyncSafelyExecutor#invokeAll: This method is not supported");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("PostAsyncSafelyExecutor#invokeAll: This method is not supported");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("PostAsyncSafelyExecutor#invokeAny: This method is not supported");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("PostAsyncSafelyExecutor#invokeAny: This method is not supported");
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(final Callable<T> task) {
        boolean executeSync;
        if (task == null) {
            throw new NullPointerException("PostAsyncSafelyExecutor#submit: task can't ne null");
        }
        Future future = null;
        boolean bl = executeSync = Thread.currentThread().getId() == this.EXECUTOR_THREAD_ID;
        if (executeSync) {
            try {
                task.call();
            }
            catch (Exception e) {
                Logger.d(TAG, "Error executing task synchronously", e);
            }
        } else {
            future = this.executor.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    PostAsyncSafelyExecutor.this.EXECUTOR_THREAD_ID = Thread.currentThread().getId();
                    return task.call();
                }
            });
        }
        return future;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException("PostAsyncSafelyExecutor#submit: task can't ne null");
        }
        FutureTask<T> futureTask = new FutureTask<T>(task, result);
        this.execute(futureTask);
        return futureTask;
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException("PostAsyncSafelyExecutor#submit: task can't ne null");
        }
        FutureTask<Object> futureTask = new FutureTask<Object>(task, null);
        this.execute(futureTask);
        return futureTask;
    }
}

