/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.network.ContentFetchManager;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/clevertap/android/sdk/response/ContentFetchResponse;", "Lcom/clevertap/android/sdk/response/CleverTapResponseDecorator;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "contentFetchManager", "Lcom/clevertap/android/sdk/network/ContentFetchManager;", "<init>", "(Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Lcom/clevertap/android/sdk/network/ContentFetchManager;)V", "logger", "Lcom/clevertap/android/sdk/Logger;", "processResponse", "", "jsonBody", "Lorg/json/JSONObject;", "stringBody", "", "context", "Landroid/content/Context;", "processContentFetchItems", "contentFetchArray", "Lorg/json/JSONArray;", "clevertap-core_release"})
public final class ContentFetchResponse
extends CleverTapResponseDecorator {
    @NotNull
    private final CleverTapInstanceConfig config;
    @NotNull
    private final ContentFetchManager contentFetchManager;
    @NotNull
    private final Logger logger;

    public ContentFetchResponse(@NotNull CleverTapInstanceConfig config, @NotNull ContentFetchManager contentFetchManager) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)contentFetchManager, (String)"contentFetchManager");
        this.config = config;
        this.contentFetchManager = contentFetchManager;
        Logger logger = this.config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @Override
    public void processResponse(@Nullable JSONObject jsonBody, @Nullable String stringBody, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger.verbose(this.config.getAccountId(), "Processing Content Fetch response...");
        if (this.config.isAnalyticsOnly()) {
            this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing Content Fetch response");
            return;
        }
        if (jsonBody == null) {
            this.logger.verbose(this.config.getAccountId(), "Can't parse Content Fetch Response, JSON response object is null");
            return;
        }
        if (!jsonBody.has("content_fetch")) {
            this.logger.verbose(this.config.getAccountId(), "JSON object doesn't contain the content_fetch key");
            return;
        }
        try {
            this.logger.verbose(this.config.getAccountId(), "Processing Content Fetch response");
            JSONArray contentFetchArray = jsonBody.getJSONArray("content_fetch");
            Intrinsics.checkNotNull((Object)contentFetchArray);
            this.processContentFetchItems(contentFetchArray, context);
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Failed to parse content fetch response", t);
        }
    }

    private final void processContentFetchItems(JSONArray contentFetchArray, Context context) {
        if (contentFetchArray.length() == 0) {
            this.logger.verbose(this.config.getAccountId(), "No content fetch items to process");
            return;
        }
        this.logger.verbose(this.config.getAccountId(), "Found " + contentFetchArray.length() + " content fetch items");
        String string2 = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackageName(...)");
        this.contentFetchManager.handleContentFetch(contentFetchArray, string2);
    }
}

