/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Icon;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationCompat;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.interfaces.AudibleNotification;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import com.clevertap.android.sdk.pushnotification.INotificationRenderer;
import com.clevertap.android.sdk.pushnotification.LaunchPendingIntentFactory;
import com.clevertap.android.sdk.utils.Clock;
import org.json.JSONArray;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CoreNotificationRenderer
implements INotificationRenderer,
AudibleNotification {
    private String notifMessage;
    private String notifTitle;
    private int smallIcon;

    @Override
    @Nullable
    public Object getCollapseKey(Bundle extras) {
        return extras.get("wzrk_ck");
    }

    @Override
    public String getMessage(Bundle extras) {
        this.notifMessage = extras.getString("nm");
        return this.notifMessage;
    }

    @Override
    public String getTitle(Bundle extras, Context context) {
        String title = extras.getString("nt", "");
        this.notifTitle = title.isEmpty() ? context.getApplicationInfo().name : title;
        return this.notifTitle;
    }

    @RequiresApi(value=34)
    private Uri getNotificationGifUri(String gif, Context context, CleverTapInstanceConfig config) {
        return Utils.getNotificationGifURI(gif, context, config, Clock.SYSTEM);
    }

    private DownloadedBitmap getNotificationImageBitmap(String bigPictureUrl, Context context, CleverTapInstanceConfig config) {
        if (bigPictureUrl == null || !bigPictureUrl.startsWith("http")) {
            return DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.NO_IMAGE);
        }
        DownloadedBitmap downloadedBitmap = DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.INIT_ERROR);
        try {
            downloadedBitmap = Utils.getNotificationBitmapWithTimeout(bigPictureUrl, false, context, config, 5000L);
            if (downloadedBitmap.getBitmap() != null) {
                long pift = downloadedBitmap.getDownloadTime();
                config.getLogger().verbose("Fetched big picture in " + pift + " millis");
            }
        }
        catch (Throwable t) {
            config.getLogger().verbose(config.getAccountId(), "Falling back to big text notification, couldn't fetch big picture", t);
        }
        return downloadedBitmap;
    }

    private void addContentDescriptionIfNeeded(NotificationCompat.Style style2, Bundle extras, Context context) {
        if (Build.VERSION.SDK_INT >= 31 && style2 instanceof NotificationCompat.BigPictureStyle) {
            String altText = extras.getString("alt_text_wzrk_bp", context.getString(R.string.ct_notification_big_picture_alt_text));
            ((NotificationCompat.BigPictureStyle)style2).setContentDescription((CharSequence)altText);
        }
    }

    private NotificationCompat.Style generateStyle(Bundle extras, Context context, CleverTapInstanceConfig config) {
        String bigPictureUrl = extras.getString("wzrk_bp");
        String gifUrl = extras.getString("wzrk_gif");
        String summaryText = extras.getString("wzrk_nms", this.notifMessage);
        try {
            Uri gifUri;
            if (Build.VERSION.SDK_INT >= 34 && gifUrl != null && gifUrl.startsWith("http") && (gifUri = this.getNotificationGifUri(gifUrl, context, config)) != null) {
                NotificationCompat.BigPictureStyle style2 = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)summaryText).bigPicture(Icon.createWithContentUri((Uri)gifUri));
                this.addContentDescriptionIfNeeded((NotificationCompat.Style)style2, extras, context);
                extras.putString("wzrk_bpds", DownloadedBitmap.Status.GIF_SUCCESS.getStatusValue());
                return style2;
            }
        }
        catch (Exception e) {
            config.getLogger().verbose(config.getAccountId(), "Failed to load GIF, falling back to static big-picture", e);
        }
        DownloadedBitmap downloadedBitmap = this.getNotificationImageBitmap(bigPictureUrl, context, config);
        extras.putString("wzrk_bpds", downloadedBitmap.getStatus().getStatusValue());
        if (downloadedBitmap.getFailureReason() != null) {
            extras.putString("wzrk_bpdsr", downloadedBitmap.getFailureReason());
        }
        try {
            Bitmap bitmap = downloadedBitmap.getBitmap();
            if (bitmap != null) {
                NotificationCompat.BigPictureStyle style3 = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)summaryText).bigPicture(bitmap);
                this.addContentDescriptionIfNeeded((NotificationCompat.Style)style3, extras, context);
                return style3;
            }
        }
        catch (Exception e) {
            config.getLogger().verbose(config.getAccountId(), "Failed to load Big Picture, falling back to text notification", e);
        }
        NotificationCompat.BigTextStyle style4 = new NotificationCompat.BigTextStyle().bigText((CharSequence)this.notifMessage);
        return style4;
    }

    @Override
    public NotificationCompat.Builder renderNotification(Bundle extras, Context context, NotificationCompat.Builder nb, CleverTapInstanceConfig config, int notificationId) {
        NotificationCompat.Style style2 = this.generateStyle(extras, context, config);
        this.addActions(extras, context, nb, config, notificationId);
        return this.finalizeBuilder(nb, extras, context, config, style2);
    }

    public void addActions(Bundle extras, Context context, NotificationCompat.Builder nb, CleverTapInstanceConfig config, int notificationId) {
        String actionsString = extras.getString("wzrk_acts");
        if (actionsString != null) {
            try {
                JSONArray actions = new JSONArray(actionsString);
                this.setActionButtons(context, extras, notificationId, nb, actions);
            }
            catch (Throwable t) {
                config.getLogger().debug(config.getAccountId(), "error parsing notification actions: " + t.getLocalizedMessage());
            }
        }
    }

    @SuppressLint(value={"NotificationTrampoline"})
    private NotificationCompat.Builder finalizeBuilder(NotificationCompat.Builder nb, Bundle extras, Context context, CleverTapInstanceConfig config, NotificationCompat.Style style2) {
        boolean showIcon;
        String dismissValue;
        boolean requiresChannelId;
        boolean bl = requiresChannelId = Build.VERSION.SDK_INT >= 26;
        if (requiresChannelId && extras.containsKey("wzrk_st")) {
            nb.setSubText((CharSequence)extras.getString("wzrk_st"));
        }
        if (extras.containsKey("wzrk_clr")) {
            int color = Color.parseColor((String)extras.getString("wzrk_clr"));
            nb.setColor(color);
            nb.setColorized(true);
        }
        if ((dismissValue = extras.getString("wzrk_dismiss")) != null) {
            try {
                long dismissAfter = Long.parseLong(dismissValue) * 1000L;
                nb.setTimeoutAfter(dismissAfter);
            }
            catch (NumberFormatException e) {
                config.getLogger().verbose(config.getAccountId(), "Failed to parse timeout dismiss value", e);
            }
        }
        if (Build.VERSION.SDK_INT >= 34) {
            boolean isSticky = "true".equalsIgnoreCase(extras.getString("wzrk_sticky"));
            nb.setOngoing(isSticky);
        }
        nb.setContentTitle((CharSequence)this.notifTitle).setContentText((CharSequence)this.notifMessage).setContentIntent(LaunchPendingIntentFactory.getLaunchPendingIntent(extras, context)).setAutoCancel(true).setStyle(style2).setSmallIcon(this.smallIcon);
        String icoPath = extras.getString("ico");
        boolean bl2 = showIcon = !"true".equalsIgnoreCase(extras.getString("wzrk_hide_large_icon"));
        if (showIcon) {
            nb.setLargeIcon(Utils.getNotificationBitmapWithTimeout(icoPath, true, context, config, 2000L).getBitmap());
        }
        return nb;
    }

    @Override
    public void setSmallIcon(int smallIcon, Context context) {
        this.smallIcon = smallIcon;
    }

    @Override
    public String getActionButtonIconKey() {
        return "ico";
    }

    @Override
    public NotificationCompat.Builder setSound(Context context, Bundle extras, NotificationCompat.Builder nb, CleverTapInstanceConfig config) {
        try {
            if (extras.containsKey("wzrk_sound")) {
                Uri soundUri = null;
                Object o = extras.get("wzrk_sound");
                if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                    soundUri = RingtoneManager.getDefaultUri((int)2);
                } else if (o instanceof String) {
                    String s = (String)o;
                    if (s.equals("true")) {
                        soundUri = RingtoneManager.getDefaultUri((int)2);
                    } else if (!s.isEmpty()) {
                        if (s.contains(".mp3") || s.contains(".ogg") || s.contains(".wav")) {
                            s = s.substring(0, s.length() - 4);
                        }
                        soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + s));
                    }
                }
                if (soundUri != null) {
                    nb.setSound(soundUri);
                }
            }
        }
        catch (Throwable t) {
            config.getLogger().debug(config.getAccountId(), "Could not process sound parameter", t);
        }
        return nb;
    }
}

