/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.product_config;

import android.text.TextUtils;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.product_config.CTProductConfigConstants;
import com.clevertap.android.sdk.product_config.ProductConfigUtil;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.OnSuccessListener;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.FileUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class ProductConfigSettings {
    private final CleverTapInstanceConfig config;
    private String guid;
    private final FileUtils fileUtils;
    private final Map<String, String> settingsMap = Collections.synchronizedMap(new HashMap());

    @Deprecated
    ProductConfigSettings(String guid, CleverTapInstanceConfig config, FileUtils fileUtils) {
        this.guid = guid;
        this.config = config;
        this.fileUtils = fileUtils;
        this.initDefaults();
    }

    void eraseStoredSettingsFile(final FileUtils fileUtils) {
        if (fileUtils == null) {
            throw new IllegalArgumentException("FileUtils can't be null");
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
        task.execute("ProductConfigSettings#eraseStoredSettingsFile", new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        String fileName = ProductConfigSettings.this.getFullPath();
                        fileUtils.deleteFile(fileName);
                        ProductConfigSettings.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(ProductConfigSettings.this.config), "Deleted settings file" + fileName);
                    }
                    catch (Exception e) {
                        ProductConfigSettings.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(ProductConfigSettings.this.config), "Error while resetting settings", e);
                    }
                    return null;
                }
            }
        });
    }

    String getDirName() {
        return "Product_Config_" + this.config.getAccountId() + "_" + this.guid;
    }

    String getFullPath() {
        return this.getDirName() + "/" + "config_settings.json";
    }

    @Deprecated
    public String getGuid() {
        return this.guid;
    }

    void setGuid(String guid) {
        this.guid = guid;
    }

    JSONObject getJsonObject(String content) {
        if (!TextUtils.isEmpty((CharSequence)content)) {
            try {
                return new JSONObject(content);
            }
            catch (JSONException e) {
                this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "LoadSettings failed", e);
            }
        }
        return null;
    }

    synchronized long getLastFetchTimeStampInMillis() {
        long lastFetchedTimeStamp = 0L;
        String value = this.settingsMap.get("ts");
        try {
            if (!TextUtils.isEmpty((CharSequence)value)) {
                lastFetchedTimeStamp = (long)Double.parseDouble(value);
            }
        }
        catch (Exception e) {
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetLastFetchTimeStampInMillis failed", e);
        }
        return lastFetchedTimeStamp;
    }

    synchronized void setLastFetchTimeStampInMillis(long timeStampInMillis) {
        long lastFetchTimeStampInMillis = this.getLastFetchTimeStampInMillis();
        if (timeStampInMillis >= 0L && lastFetchTimeStampInMillis != timeStampInMillis) {
            this.settingsMap.put("ts", String.valueOf(timeStampInMillis));
            this.updateConfigToFile();
        }
    }

    long getNextFetchIntervalInSeconds() {
        long minFetchIntervalInSecondsSDK = this.getMinFetchIntervalInSeconds();
        long minFetchIntervalInSecondsServer = TimeUnit.MINUTES.toSeconds(this.getWindowIntervalInMinutes() / this.getNoOfCallsInAllowedWindow());
        return Math.max(minFetchIntervalInSecondsServer, minFetchIntervalInSecondsSDK);
    }

    void initDefaults() {
        this.settingsMap.put("rc_n", String.valueOf(5));
        this.settingsMap.put("rc_w", String.valueOf(60));
        this.settingsMap.put("ts", String.valueOf(0));
        this.settingsMap.put("fetch_min_interval_seconds", String.valueOf(CTProductConfigConstants.DEFAULT_MIN_FETCH_INTERVAL_SECONDS));
        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Settings loaded with default values: " + this.settingsMap);
    }

    synchronized void loadSettings(FileUtils fileUtils) {
        if (fileUtils == null) {
            throw new IllegalArgumentException("fileutils can't be null");
        }
        try {
            String content = fileUtils.readFromFile(this.getFullPath());
            JSONObject jsonObject = this.getJsonObject(content);
            this.populateMapWithJson(jsonObject);
        }
        catch (Exception e) {
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "LoadSettings failed while reading file", e);
        }
    }

    synchronized void populateMapWithJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String value;
            String key = (String)iterator.next();
            if (TextUtils.isEmpty((CharSequence)key)) continue;
            try {
                Object obj = jsonObject.get(key);
                value = String.valueOf(obj);
            }
            catch (Exception e) {
                this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Failed loading setting for key " + key, e);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            this.settingsMap.put(key, value);
        }
        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "LoadSettings completed with settings: " + this.settingsMap);
    }

    void reset(FileUtils fileUtils) {
        this.initDefaults();
        this.eraseStoredSettingsFile(fileUtils);
    }

    void setARPValue(JSONObject arp) {
        if (arp != null) {
            Iterator keys = arp.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    Object object;
                    if (TextUtils.isEmpty((CharSequence)key) || !((object = arp.get(key)) instanceof Number)) continue;
                    int update = (int)((Number)object).doubleValue();
                    if (!"rc_n".equalsIgnoreCase(key) && !"rc_w".equalsIgnoreCase(key)) continue;
                    this.setProductConfigValuesFromARP(key, update);
                }
                catch (Exception e) {
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config setARPValue failed", e);
                }
            }
        }
    }

    synchronized void setMinimumFetchIntervalInSeconds(long intervalInSeconds) {
        long minFetchIntervalInSeconds = this.getMinFetchIntervalInSeconds();
        if (intervalInSeconds > 0L && minFetchIntervalInSeconds != intervalInSeconds) {
            this.settingsMap.put("fetch_min_interval_seconds", String.valueOf(intervalInSeconds));
        }
    }

    private long getMinFetchIntervalInSeconds() {
        long minInterVal = CTProductConfigConstants.DEFAULT_MIN_FETCH_INTERVAL_SECONDS;
        String value = this.settingsMap.get("fetch_min_interval_seconds");
        try {
            if (!TextUtils.isEmpty((CharSequence)value)) {
                minInterVal = (long)Double.parseDouble(value);
            }
        }
        catch (Exception e) {
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetMinFetchIntervalInSeconds failed", e);
        }
        return minInterVal;
    }

    private synchronized int getNoOfCallsInAllowedWindow() {
        int noCallsAllowedInWindow = 5;
        String value = this.settingsMap.get("rc_n");
        try {
            if (!TextUtils.isEmpty((CharSequence)value)) {
                noCallsAllowedInWindow = (int)Double.parseDouble(value);
            }
        }
        catch (Exception e) {
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetNoOfCallsInAllowedWindow failed", e);
        }
        return noCallsAllowedInWindow;
    }

    private synchronized void setNoOfCallsInAllowedWindow(int callsInAllowedWindow) {
        long noOfCallsInAllowedWindow = this.getNoOfCallsInAllowedWindow();
        if (callsInAllowedWindow > 0 && noOfCallsInAllowedWindow != (long)callsInAllowedWindow) {
            this.settingsMap.put("rc_n", String.valueOf(callsInAllowedWindow));
            this.updateConfigToFile();
        }
    }

    private synchronized int getWindowIntervalInMinutes() {
        int windowIntervalInMinutes = 60;
        String value = this.settingsMap.get("rc_w");
        try {
            if (!TextUtils.isEmpty((CharSequence)value)) {
                windowIntervalInMinutes = (int)Double.parseDouble(value);
            }
        }
        catch (Exception e) {
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetWindowIntervalInMinutes failed", e);
        }
        return windowIntervalInMinutes;
    }

    private synchronized void setWindowIntervalInMinutes(int intervalInMinutes) {
        int windowIntervalInMinutes = this.getWindowIntervalInMinutes();
        if (intervalInMinutes > 0 && windowIntervalInMinutes != intervalInMinutes) {
            this.settingsMap.put("rc_w", String.valueOf(intervalInMinutes));
            this.updateConfigToFile();
        }
    }

    private void setProductConfigValuesFromARP(String key, int value) {
        switch (key) {
            case "rc_n": {
                this.setNoOfCallsInAllowedWindow(value);
                break;
            }
            case "rc_w": {
                this.setWindowIntervalInMinutes(value);
            }
        }
    }

    private synchronized void updateConfigToFile() {
        Task<Boolean> task = CTExecutorFactory.executors(this.config).ioTask();
        task.addOnSuccessListener(new OnSuccessListener<Boolean>(){

            @Override
            public void onSuccess(Boolean isSuccess) {
                if (isSuccess.booleanValue()) {
                    ProductConfigSettings.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(ProductConfigSettings.this.config), "Product Config settings: writing Success " + ProductConfigSettings.this.settingsMap);
                } else {
                    ProductConfigSettings.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(ProductConfigSettings.this.config), "Product Config settings: writing Failed");
                }
            }
        }).execute("ProductConfigSettings#updateConfigToFile", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    HashMap toWriteMap = new HashMap(ProductConfigSettings.this.settingsMap);
                    toWriteMap.remove("fetch_min_interval_seconds");
                    ProductConfigSettings.this.fileUtils.writeJsonToFile(ProductConfigSettings.this.getDirName(), "config_settings.json", new JSONObject(toWriteMap));
                }
                catch (Exception e) {
                    ProductConfigSettings.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(ProductConfigSettings.this.config), "UpdateConfigToFile failed", e);
                    return false;
                }
                return true;
            }
        });
    }
}

