/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.os.Parcel;
import android.os.Parcelable;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inbox.CTInboxImageData;
import com.clevertap.android.sdk.inbox.CTInboxMessageContent;
import com.clevertap.android.sdk.inbox.CTInboxMessageType;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CTInboxMessage
implements Parcelable {
    public static final Parcelable.Creator<CTInboxMessage> CREATOR = new Parcelable.Creator<CTInboxMessage>(){

        public CTInboxMessage createFromParcel(Parcel in) {
            return new CTInboxMessage(in);
        }

        public CTInboxMessage[] newArray(int size) {
            return new CTInboxMessage[size];
        }
    };
    private String actionUrl;
    private String bgColor;
    private String body;
    private String campaignId;
    private JSONObject customData = new JSONObject();
    private JSONObject data;
    private long date;
    private long expires;
    private String imageUrl;
    private ArrayList<CTInboxMessageContent> inboxMessageContents = new ArrayList();
    private boolean isRead;
    private String messageId;
    private String orientation;
    private List<String> tags = new ArrayList<String>();
    private String title;
    private CTInboxMessageType type;
    private JSONObject wzrkParams;

    public static Parcelable.Creator<CTInboxMessage> getCREATOR() {
        return CREATOR;
    }

    public CTInboxMessage(JSONObject jsonObject) {
        this.data = jsonObject;
        try {
            JSONObject cellObject;
            JSONArray tagsArray;
            this.messageId = jsonObject.has("id") ? jsonObject.getString("id") : "0";
            this.campaignId = jsonObject.has("wzrk_id") ? jsonObject.getString("wzrk_id") : "0_0";
            this.date = jsonObject.has("date") ? jsonObject.getLong("date") : System.currentTimeMillis() / 1000L;
            this.expires = jsonObject.has("wzrk_ttl") ? jsonObject.getLong("wzrk_ttl") : System.currentTimeMillis() + 86400000L;
            this.isRead = jsonObject.has("isRead") && jsonObject.getBoolean("isRead");
            JSONArray jSONArray = tagsArray = jsonObject.has("tags") ? jsonObject.getJSONArray("tags") : null;
            if (tagsArray != null) {
                for (int i = 0; i < tagsArray.length(); ++i) {
                    this.tags.add(tagsArray.getString(i));
                }
            }
            JSONObject jSONObject = cellObject = jsonObject.has("msg") ? jsonObject.getJSONObject("msg") : null;
            if (cellObject != null) {
                JSONArray customKVJsonArray;
                JSONArray contentArray;
                this.type = cellObject.has("type") ? CTInboxMessageType.fromString(cellObject.getString("type")) : CTInboxMessageType.fromString("");
                this.bgColor = cellObject.has("bg") ? cellObject.getString("bg") : "";
                JSONArray jSONArray2 = contentArray = cellObject.has("content") ? cellObject.getJSONArray("content") : null;
                if (contentArray != null) {
                    for (int i = 0; i < contentArray.length(); ++i) {
                        CTInboxMessageContent ctInboxMessageContent = new CTInboxMessageContent().initWithJSON(contentArray.getJSONObject(i));
                        this.inboxMessageContents.add(ctInboxMessageContent);
                    }
                }
                JSONArray jSONArray3 = customKVJsonArray = cellObject.has("custom_kv") ? cellObject.getJSONArray("custom_kv") : null;
                if (customKVJsonArray != null) {
                    for (int i = 0; i < customKVJsonArray.length(); ++i) {
                        JSONObject customKVJSONObject = customKVJsonArray.getJSONObject(i);
                        if (!customKVJSONObject.has("key")) continue;
                        String key = customKVJSONObject.getString("key");
                        if (!customKVJSONObject.has("value")) continue;
                        JSONObject value = customKVJSONObject.getJSONObject("value");
                        this.customData.put(key, (Object)value.getString("text"));
                    }
                }
                this.orientation = cellObject.has("orientation") ? cellObject.getString("orientation") : "";
            }
            this.wzrkParams = jsonObject.has("wzrkParams") ? jsonObject.getJSONObject("wzrkParams") : null;
        }
        catch (JSONException e) {
            Logger.v("Unable to init CTInboxMessage with JSON - " + e.getLocalizedMessage());
        }
    }

    private CTInboxMessage(Parcel in) {
        try {
            this.title = in.readString();
            this.body = in.readString();
            this.imageUrl = in.readString();
            this.actionUrl = in.readString();
            this.date = in.readLong();
            this.expires = in.readLong();
            this.messageId = in.readString();
            this.data = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.customData = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.isRead = in.readByte() != 0;
            this.type = (CTInboxMessageType)((Object)in.readValue(CTInboxMessageType.class.getClassLoader()));
            if (in.readByte() == 1) {
                this.tags = new ArrayList<String>();
                in.readList(this.tags, String.class.getClassLoader());
            } else {
                this.tags = null;
            }
            this.bgColor = in.readString();
            if (in.readByte() == 1) {
                this.inboxMessageContents = new ArrayList();
                in.readList(this.inboxMessageContents, CTInboxMessageContent.class.getClassLoader());
            } else {
                this.inboxMessageContents = null;
            }
            this.orientation = in.readString();
            this.campaignId = in.readString();
            this.wzrkParams = in.readByte() == 0 ? null : new JSONObject(in.readString());
        }
        catch (JSONException e) {
            Logger.v("Unable to parse CTInboxMessage from parcel - " + e.getLocalizedMessage());
        }
    }

    public int describeContents() {
        return 0;
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public String getBody() {
        return this.body;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public ArrayList<CTInboxImageData> getCarouselImagesData() {
        ArrayList<CTInboxImageData> carouselImages = new ArrayList<CTInboxImageData>();
        for (CTInboxMessageContent ctInboxMessageContent : this.getInboxMessageContents()) {
            carouselImages.add(new CTInboxImageData(ctInboxMessageContent.getMedia(), ctInboxMessageContent.getMediaContentDescription()));
        }
        return carouselImages;
    }

    public ArrayList<String> getCarouselImages() {
        ArrayList<String> carouselImages = new ArrayList<String>();
        for (CTInboxMessageContent ctInboxMessageContent : this.getInboxMessageContents()) {
            carouselImages.add(ctInboxMessageContent.getMedia());
        }
        return carouselImages;
    }

    public JSONObject getCustomData() {
        return this.customData;
    }

    public JSONObject getData() {
        return this.data;
    }

    public long getDate() {
        return this.date;
    }

    public long getExpires() {
        return this.expires;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public ArrayList<CTInboxMessageContent> getInboxMessageContents() {
        return this.inboxMessageContents;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getTitle() {
        return this.title;
    }

    public CTInboxMessageType getType() {
        return this.type;
    }

    public JSONObject getWzrkParams() {
        return this.wzrkParams == null ? new JSONObject() : this.wzrkParams;
    }

    public boolean isRead() {
        return this.isRead;
    }

    void setRead(boolean read) {
        this.isRead = read;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.title);
        dest.writeString(this.body);
        dest.writeString(this.imageUrl);
        dest.writeString(this.actionUrl);
        dest.writeLong(this.date);
        dest.writeLong(this.expires);
        dest.writeString(this.messageId);
        if (this.data == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.data.toString());
        }
        if (this.customData == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.customData.toString());
        }
        dest.writeByte((byte)(this.isRead ? 1 : 0));
        dest.writeValue((Object)this.type);
        if (this.tags == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.tags);
        }
        dest.writeString(this.bgColor);
        if (this.inboxMessageContents == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.inboxMessageContents);
        }
        dest.writeString(this.orientation);
        dest.writeString(this.campaignId);
        if (this.wzrkParams == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.wzrkParams.toString());
        }
    }
}

