/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.cryption.CryptExtensionsKt;
import com.clevertap.android.sdk.cryption.CryptRepository;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0006\u0010\n\u001a\u00020\tJ\n\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/clevertap/android/sdk/cryption/CTKeyGenerator;", "", "cryptRepository", "Lcom/clevertap/android/sdk/cryption/CryptRepository;", "<init>", "(Lcom/clevertap/android/sdk/cryption/CryptRepository;)V", "getCryptRepository", "()Lcom/clevertap/android/sdk/cryption/CryptRepository;", "generateOrGetKey", "Ljavax/crypto/SecretKey;", "generateSecretKey", "fromAndroidKeystore", "clevertap-core_release"})
public final class CTKeyGenerator {
    @NotNull
    private final CryptRepository cryptRepository;

    public CTKeyGenerator(@NotNull CryptRepository cryptRepository) {
        Intrinsics.checkNotNullParameter((Object)cryptRepository, (String)"cryptRepository");
        this.cryptRepository = cryptRepository;
    }

    @NotNull
    public final CryptRepository getCryptRepository() {
        return this.cryptRepository;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SecretKey generateOrGetKey() {
        SecretKey secretKey;
        if (Build.VERSION.SDK_INT >= 23) {
            secretKey = this.fromAndroidKeystore();
        } else {
            Logger.v("KeyStore is not supported on API levels below 23");
            String encodedKey = this.cryptRepository.localEncryptionKey();
            if (encodedKey != null) {
                byte[] decodedKey = CryptExtensionsKt.fromBase64(encodedKey);
                secretKey = new SecretKeySpec(decodedKey, "AES");
            } else {
                void var2_3;
                SecretKey secretKey2 = this.generateSecretKey();
                byte[] byArray = secretKey2.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
                String encodedNewKey = CryptExtensionsKt.toBase64(byArray);
                this.cryptRepository.updateLocalEncryptionKey(encodedNewKey);
                secretKey = var2_3;
            }
        }
        return secretKey;
    }

    @NotNull
    public final SecretKey generateSecretKey() {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        SecretKey secretKey = keyGenerator.generateKey();
        Intrinsics.checkNotNull((Object)secretKey);
        return secretKey;
    }

    @RequiresApi(value=23)
    private final SecretKey fromAndroidKeystore() {
        SecretKey secretKey;
        try {
            SecretKey secretKey2;
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            if (keyStore.containsAlias("EncryptionKey")) {
                Key key = keyStore.getKey("EncryptionKey", null);
                Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type javax.crypto.SecretKey");
                secretKey2 = (SecretKey)key;
            } else {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
                String[] stringArray = new String[]{"GCM"};
                KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder("EncryptionKey", 3).setBlockModes(stringArray);
                stringArray = new String[]{"NoPadding"};
                KeyGenParameterSpec keyGenParameterSpec = builder.setEncryptionPaddings(stringArray).build();
                Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"build(...)");
                KeyGenParameterSpec keyGenParameterSpec2 = keyGenParameterSpec;
                keyGenerator.init((AlgorithmParameterSpec)keyGenParameterSpec2);
                secretKey2 = keyGenerator.generateKey();
            }
            secretKey = secretKey2;
        }
        catch (Exception e) {
            Logger.v("Error generating or retrieving key", e);
            secretKey = null;
        }
        return secretKey;
    }
}

