/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.bitmap.IBitmapInputStreamReader;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/clevertap/android/sdk/bitmap/BitmapInputStreamReader;", "Lcom/clevertap/android/sdk/bitmap/IBitmapInputStreamReader;", "nextBitmapInputStreamReader", "checkDownloadCompleteness", "", "<init>", "(Lcom/clevertap/android/sdk/bitmap/IBitmapInputStreamReader;Z)V", "readInputStream", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "inputStream", "Ljava/io/InputStream;", "connection", "Ljava/net/HttpURLConnection;", "downloadStartTimeInMilliseconds", "", "getDownloadedBitmapFromStream", "dataReadFromStream", "Ljava/io/ByteArrayOutputStream;", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nBitmapInputStreamReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapInputStreamReader.kt\ncom/clevertap/android/sdk/bitmap/BitmapInputStreamReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class BitmapInputStreamReader
implements IBitmapInputStreamReader {
    @Nullable
    private final IBitmapInputStreamReader nextBitmapInputStreamReader;
    private final boolean checkDownloadCompleteness;

    public BitmapInputStreamReader(@Nullable IBitmapInputStreamReader nextBitmapInputStreamReader, boolean checkDownloadCompleteness) {
        this.nextBitmapInputStreamReader = nextBitmapInputStreamReader;
        this.checkDownloadCompleteness = checkDownloadCompleteness;
    }

    public /* synthetic */ BitmapInputStreamReader(IBitmapInputStreamReader iBitmapInputStreamReader, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iBitmapInputStreamReader = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(iBitmapInputStreamReader, bl);
    }

    @Override
    @NotNull
    public DownloadedBitmap readInputStream(@NotNull InputStream inputStream, @NotNull HttpURLConnection connection, long downloadStartTimeInMilliseconds) {
        int fileLength;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Logger.v("reading bitmap input stream in BitmapInputStreamReader....");
        byte[] bufferForHttpInputStream = new byte[16384];
        ByteArrayOutputStream finalDataFromHttpInputStream = new ByteArrayOutputStream();
        int totalBytesRead = 0;
        int bytesRead = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(bufferForHttpInputStream);
            boolean bl = false;
            bytesRead = it;
            if (n == -1) break;
            finalDataFromHttpInputStream.write(bufferForHttpInputStream, 0, bytesRead);
            Logger.v("Downloaded " + (totalBytesRead += bytesRead) + " bytes");
        }
        Logger.v("Total download size for bitmap = " + totalBytesRead);
        if (this.checkDownloadCompleteness && (fileLength = connection.getContentLength()) != -1 && fileLength != totalBytesRead) {
            String reason = "Incomplete Download";
            Logger.d("File not loaded completely not going forward. URL was: " + connection.getURL() + ", Reason: " + reason);
            return DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.DOWNLOAD_FAILED, reason);
        }
        Object object = this.nextBitmapInputStreamReader;
        if (object == null || (object = object.readInputStream(new ByteArrayInputStream(finalDataFromHttpInputStream.toByteArray()), connection, downloadStartTimeInMilliseconds)) == null) {
            object = this.getDownloadedBitmapFromStream(finalDataFromHttpInputStream, downloadStartTimeInMilliseconds);
        }
        return object;
    }

    private final DownloadedBitmap getDownloadedBitmapFromStream(ByteArrayOutputStream dataReadFromStream, long downloadStartTimeInMilliseconds) {
        byte[] dataReadFromStreamInByteArray = dataReadFromStream.toByteArray();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])dataReadFromStreamInByteArray, (int)0, (int)dataReadFromStreamInByteArray.length);
        Intrinsics.checkNotNull((Object)bitmap);
        return DownloadedBitmapFactory.successBitmap$default(DownloadedBitmapFactory.INSTANCE, bitmap, Utils.getNowInMillis() - downloadStartTimeInMilliseconds, null, 4, null);
    }

    public BitmapInputStreamReader() {
        this(null, false, 3, null);
    }
}

