/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import android.net.TrafficStats;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.bitmap.HttpUrlConnectionParams;
import com.clevertap.android.sdk.bitmap.IBitmapInputStreamReader;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/clevertap/android/sdk/bitmap/BitmapDownloader;", "", "httpUrlConnectionParams", "Lcom/clevertap/android/sdk/bitmap/HttpUrlConnectionParams;", "bitmapInputStreamReader", "Lcom/clevertap/android/sdk/bitmap/IBitmapInputStreamReader;", "sizeConstrainedPair", "Lkotlin/Pair;", "", "", "<init>", "(Lcom/clevertap/android/sdk/bitmap/HttpUrlConnectionParams;Lcom/clevertap/android/sdk/bitmap/IBitmapInputStreamReader;Lkotlin/Pair;)V", "downloadStartTimeInMilliseconds", "", "connection", "Ljava/net/HttpURLConnection;", "srcUrl", "", "downloadBitmap", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "createConnection", "url", "Ljava/net/URL;", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nBitmapDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapDownloader.kt\ncom/clevertap/android/sdk/bitmap/BitmapDownloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,86:1\n1#2:87\n216#3,2:88\n*S KotlinDebug\n*F\n+ 1 BitmapDownloader.kt\ncom/clevertap/android/sdk/bitmap/BitmapDownloader\n*L\n83#1:88,2\n*E\n"})
public final class BitmapDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpUrlConnectionParams httpUrlConnectionParams;
    @NotNull
    private final IBitmapInputStreamReader bitmapInputStreamReader;
    @NotNull
    private final Pair<Boolean, Integer> sizeConstrainedPair;
    private long downloadStartTimeInMilliseconds;
    private HttpURLConnection connection;
    private String srcUrl;
    public static final int NETWORK_TAG_DOWNLOAD_REQUESTS = 21;
    @NotNull
    private static final String TAG = "BitmapDownloader";

    public BitmapDownloader(@NotNull HttpUrlConnectionParams httpUrlConnectionParams, @NotNull IBitmapInputStreamReader bitmapInputStreamReader, @NotNull Pair<Boolean, Integer> sizeConstrainedPair) {
        Intrinsics.checkNotNullParameter((Object)httpUrlConnectionParams, (String)"httpUrlConnectionParams");
        Intrinsics.checkNotNullParameter((Object)bitmapInputStreamReader, (String)"bitmapInputStreamReader");
        Intrinsics.checkNotNullParameter(sizeConstrainedPair, (String)"sizeConstrainedPair");
        this.httpUrlConnectionParams = httpUrlConnectionParams;
        this.bitmapInputStreamReader = bitmapInputStreamReader;
        this.sizeConstrainedPair = sizeConstrainedPair;
    }

    public /* synthetic */ BitmapDownloader(HttpUrlConnectionParams httpUrlConnectionParams, IBitmapInputStreamReader iBitmapInputStreamReader, Pair pair, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pair = new Pair((Object)false, (Object)0);
        }
        this(httpUrlConnectionParams, iBitmapInputStreamReader, (Pair<Boolean, Integer>)pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final DownloadedBitmap downloadBitmap(@NotNull String srcUrl) {
        DownloadedBitmap downloadedBitmap;
        HttpURLConnection $this$downloadBitmap_u24lambda_u241;
        block17: {
            block16: {
                void $this$downloadBitmap_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)srcUrl, (String)"srcUrl");
                Logger.v(TAG, "Initiating bitmap download in BitmapDownloader...");
                this.srcUrl = srcUrl;
                this.downloadStartTimeInMilliseconds = Utils.getNowInMillis();
                TrafficStats.setThreadStatsTag((int)21);
                URL uRL = new URL(srcUrl);
                BitmapDownloader bitmapDownloader = this;
                boolean bl = false;
                bitmapDownloader.connection = this.createConnection((URL)$this$downloadBitmap_u24lambda_u240);
                HttpURLConnection httpURLConnection = this.connection;
                if (httpURLConnection == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                    httpURLConnection = null;
                }
                $this$downloadBitmap_u24lambda_u241 = httpURLConnection;
                boolean bl2 = false;
                $this$downloadBitmap_u24lambda_u241.connect();
                if ($this$downloadBitmap_u24lambda_u241.getResponseCode() == 200) break block16;
                String reason = "HTTP Error : " + $this$downloadBitmap_u24lambda_u241.getResponseCode();
                Logger.d(TAG, "File not loaded completely. URL was: " + srcUrl + ", Reason: " + reason);
                DownloadedBitmap downloadedBitmap2 = DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.DOWNLOAD_FAILED, reason);
                HttpURLConnection httpURLConnection2 = this.connection;
                if (httpURLConnection2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                    httpURLConnection2 = null;
                }
                httpURLConnection2.disconnect();
                TrafficStats.clearThreadStatsTag();
                return downloadedBitmap2;
            }
            Logger.v(TAG, "Downloading " + srcUrl + "....");
            int fileLength = $this$downloadBitmap_u24lambda_u241.getContentLength();
            Pair<Boolean, Integer> pair = this.sizeConstrainedPair;
            boolean isSizeConstrained = (Boolean)pair.component1();
            int size = ((Number)pair.component2()).intValue();
            if (!isSizeConstrained || fileLength <= size) break block17;
            Logger.v(TAG, "Image size is larger than " + size + " bytes. Cancelling download!");
            DownloadedBitmap downloadedBitmap3 = DownloadedBitmapFactory.nullBitmapWithStatus$default(DownloadedBitmapFactory.INSTANCE, DownloadedBitmap.Status.SIZE_LIMIT_EXCEEDED, null, 2, null);
            HttpURLConnection httpURLConnection = this.connection;
            if (httpURLConnection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                httpURLConnection = null;
            }
            httpURLConnection.disconnect();
            TrafficStats.clearThreadStatsTag();
            return downloadedBitmap3;
        }
        try {
            InputStream inputStream = $this$downloadBitmap_u24lambda_u241.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            downloadedBitmap = this.bitmapInputStreamReader.readInputStream(inputStream, $this$downloadBitmap_u24lambda_u241, this.downloadStartTimeInMilliseconds);
        }
        catch (Throwable e) {
            DownloadedBitmap downloadedBitmap4;
            try {
                String reason = "Exception : " + e.getClass().getSimpleName() + " : " + e.getMessage();
                Logger.v(TAG, "Couldn't download the notification media. URL was: " + srcUrl + ", Reason: " + reason, e);
                downloadedBitmap4 = DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.DOWNLOAD_FAILED, reason);
            }
            catch (Throwable throwable) {
                try {
                    HttpURLConnection httpURLConnection = this.connection;
                    if (httpURLConnection == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                        httpURLConnection = null;
                    }
                    httpURLConnection.disconnect();
                    TrafficStats.clearThreadStatsTag();
                }
                catch (Throwable t) {
                    Logger.v(TAG, "Couldn't close connection!", t);
                }
                throw throwable;
            }
            try {
                HttpURLConnection httpURLConnection = this.connection;
                if (httpURLConnection == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                    httpURLConnection = null;
                }
                httpURLConnection.disconnect();
                TrafficStats.clearThreadStatsTag();
            }
            catch (Throwable t) {
                Logger.v(TAG, "Couldn't close connection!", t);
            }
            return downloadedBitmap4;
        }
        HttpURLConnection httpURLConnection = this.connection;
        if (httpURLConnection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
            httpURLConnection = null;
        }
        httpURLConnection.disconnect();
        TrafficStats.clearThreadStatsTag();
        return downloadedBitmap;
    }

    private final HttpURLConnection createConnection(URL url) {
        HttpURLConnection httpURLConnection;
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection $this$createConnection_u24lambda_u243 = httpURLConnection = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        $this$createConnection_u24lambda_u243.setConnectTimeout(this.httpUrlConnectionParams.getConnectTimeout());
        $this$createConnection_u24lambda_u243.setReadTimeout(this.httpUrlConnectionParams.getReadTimeout());
        $this$createConnection_u24lambda_u243.setUseCaches(this.httpUrlConnectionParams.getUseCaches());
        $this$createConnection_u24lambda_u243.setDoInput(this.httpUrlConnectionParams.getDoInput());
        Map<String, String> $this$forEach$iv = this.httpUrlConnectionParams.getRequestMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String k = entry.getKey();
            String v = entry.getValue();
            $this$createConnection_u24lambda_u243.addRequestProperty(k, v);
        }
        return httpURLConnection;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/clevertap/android/sdk/bitmap/BitmapDownloader$Companion;", "", "<init>", "()V", "NETWORK_TAG_DOWNLOAD_REQUESTS", "", "TAG", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

