/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import com.clevertap.android.sdk.ActivityLifeCycleManager;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CTPreferenceCache;
import com.clevertap.android.sdk.CallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.CoreState;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.LocationManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.PushPermissionHandler;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.StoreProvider;
import com.clevertap.android.sdk.cryption.CTKeyGenerator;
import com.clevertap.android.sdk.cryption.CryptFactory;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.cryption.CryptMigrator;
import com.clevertap.android.sdk.cryption.CryptRepository;
import com.clevertap.android.sdk.cryption.DataMigrationRepository;
import com.clevertap.android.sdk.cryption.EncryptionLevel;
import com.clevertap.android.sdk.cryption.ICryptHandler;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.db.DBEncryptionHandler;
import com.clevertap.android.sdk.db.DBManager;
import com.clevertap.android.sdk.db.DelayedLegacyInAppDAO;
import com.clevertap.android.sdk.events.EventMediator;
import com.clevertap.android.sdk.events.EventQueueManager;
import com.clevertap.android.sdk.featureFlags.CTFeatureFlagsFactory;
import com.clevertap.android.sdk.inapp.ImpressionManager;
import com.clevertap.android.sdk.inapp.InAppActionHandler;
import com.clevertap.android.sdk.inapp.InAppController;
import com.clevertap.android.sdk.inapp.InAppNotificationInflater;
import com.clevertap.android.sdk.inapp.InAppPreviewHandler;
import com.clevertap.android.sdk.inapp.StoreRegistryInAppQueue;
import com.clevertap.android.sdk.inapp.TriggerManager;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplate;
import com.clevertap.android.sdk.inapp.customtemplates.TemplatesManager;
import com.clevertap.android.sdk.inapp.customtemplates.system.SystemTemplates;
import com.clevertap.android.sdk.inapp.delay.DelayedInAppStorageStrategy;
import com.clevertap.android.sdk.inapp.delay.InAppScheduler;
import com.clevertap.android.sdk.inapp.delay.InAppSchedulerFactory;
import com.clevertap.android.sdk.inapp.delay.InAppSchedulingStrategy;
import com.clevertap.android.sdk.inapp.evaluation.EvaluationManager;
import com.clevertap.android.sdk.inapp.evaluation.LimitsMatcher;
import com.clevertap.android.sdk.inapp.evaluation.TriggersMatcher;
import com.clevertap.android.sdk.inapp.images.FileResourceProvider;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepoFactory;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepoImpl;
import com.clevertap.android.sdk.inapp.store.db.DelayedLegacyInAppStore;
import com.clevertap.android.sdk.inapp.store.preference.ImpressionStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppStore;
import com.clevertap.android.sdk.inapp.store.preference.StoreRegistry;
import com.clevertap.android.sdk.login.LoginController;
import com.clevertap.android.sdk.login.LoginInfoProvider;
import com.clevertap.android.sdk.network.AppLaunchListener;
import com.clevertap.android.sdk.network.ArpRepo;
import com.clevertap.android.sdk.network.CompositeBatchListener;
import com.clevertap.android.sdk.network.ContentFetchManager;
import com.clevertap.android.sdk.network.FetchInAppListener;
import com.clevertap.android.sdk.network.IJRepo;
import com.clevertap.android.sdk.network.NetworkEncryptionManager;
import com.clevertap.android.sdk.network.NetworkManager;
import com.clevertap.android.sdk.network.NetworkRepo;
import com.clevertap.android.sdk.network.QueueHeaderBuilder;
import com.clevertap.android.sdk.network.api.CtApiWrapper;
import com.clevertap.android.sdk.profile.ProfileStateTraverser;
import com.clevertap.android.sdk.pushnotification.PushProviders;
import com.clevertap.android.sdk.pushnotification.work.CTWorkManager;
import com.clevertap.android.sdk.response.ARPResponse;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.ClevertapResponseHandler;
import com.clevertap.android.sdk.response.ConsoleResponse;
import com.clevertap.android.sdk.response.ContentFetchResponse;
import com.clevertap.android.sdk.response.DisplayUnitResponse;
import com.clevertap.android.sdk.response.FeatureFlagResponse;
import com.clevertap.android.sdk.response.FetchVariablesResponse;
import com.clevertap.android.sdk.response.GeofenceResponse;
import com.clevertap.android.sdk.response.InAppResponse;
import com.clevertap.android.sdk.response.InboxResponse;
import com.clevertap.android.sdk.response.MetadataResponse;
import com.clevertap.android.sdk.response.ProductConfigResponse;
import com.clevertap.android.sdk.response.PushAmpResponse;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.CTExecutors;
import com.clevertap.android.sdk.task.MainLooperHandler;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.Clock;
import com.clevertap.android.sdk.utils.NestedJsonBuilder;
import com.clevertap.android.sdk.validation.ValidationConfig;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import com.clevertap.android.sdk.validation.pipeline.ValidationPipelineProvider;
import com.clevertap.android.sdk.variables.CTVariables;
import com.clevertap.android.sdk.variables.Parser;
import com.clevertap.android.sdk.variables.VarCache;
import com.clevertap.android.sdk.variables.repo.VariablesRepo;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J>\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/clevertap/android/sdk/CleverTapFactory;", "", "<init>", "()V", "getCoreState", "Lcom/clevertap/android/sdk/CoreState;", "context", "Landroid/content/Context;", "cleverTapInstanceConfig", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "cleverTapID", "", "initFeatureFlags", "", "controllerManager", "Lcom/clevertap/android/sdk/ControllerManager;", "config", "deviceInfo", "Lcom/clevertap/android/sdk/DeviceInfo;", "callbackManager", "Lcom/clevertap/android/sdk/BaseCallbackManager;", "analyticsManager", "Lcom/clevertap/android/sdk/AnalyticsManager;", "clevertap-core_release"})
public final class CleverTapFactory {
    @NotNull
    public static final CleverTapFactory INSTANCE = new CleverTapFactory();

    private CleverTapFactory() {
    }

    @JvmStatic
    @NotNull
    public static final CoreState getCoreState(@Nullable Context context, @Nullable CleverTapInstanceConfig cleverTapInstanceConfig, @Nullable String cleverTapID) {
        if (context == null || cleverTapInstanceConfig == null) {
            throw new RuntimeException("This is invalid case and will not happen. Context/Config is null");
        }
        StoreProvider storeProvider = StoreProvider.Companion.getInstance();
        String accountId = cleverTapInstanceConfig.getAccountId();
        Intrinsics.checkNotNull((Object)accountId);
        StoreRegistry storeRegistry = new StoreRegistry(null, null, storeProvider.provideLegacyInAppStore(context, accountId), storeProvider.provideInAppAssetsStore(context, accountId), storeProvider.provideFileStore(context, accountId));
        CoreMetaData coreMetaData = new CoreMetaData();
        ValidationResultStack validationResultStack = new ValidationResultStack();
        CTLockManager ctLockManager = new CTLockManager();
        MainLooperHandler mainLooperHandler = new MainLooperHandler();
        CleverTapInstanceConfig config = new CleverTapInstanceConfig(cleverTapInstanceConfig);
        NetworkRepo networkRepo = new NetworkRepo(context, config, null, null, 12, null);
        IJRepo ijRepo = new IJRepo(config);
        CTExecutors executors = CTExecutorFactory.executors(config);
        Logger logger = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        InAppScheduler inAppDelayManager = InAppSchedulerFactory.createDelayedInAppScheduler$default(InAppSchedulerFactory.INSTANCE, accountId, logger, null, null, null, null, 60, null);
        Logger logger2 = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        InAppScheduler inAppInActionManager = InAppSchedulerFactory.createInActionScheduler$default(InAppSchedulerFactory.INSTANCE, accountId, logger2, null, null, null, 28, null);
        Task<Unit> fileResourceProviderInit = executors.ioTask();
        fileResourceProviderInit.execute("initFileResourceProvider", () -> CleverTapFactory.getCoreState$lambda$0(context, config));
        String string2 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        CryptRepository repository = new CryptRepository(context, string2);
        CTKeyGenerator ctKeyGenerator = new CTKeyGenerator(repository);
        String string3 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAccountId(...)");
        CryptFactory cryptFactory = new CryptFactory(string3, ctKeyGenerator);
        CryptHandler cryptHandler = new CryptHandler(repository, cryptFactory);
        ICryptHandler iCryptHandler = cryptHandler;
        Logger logger3 = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getLogger(...)");
        DBEncryptionHandler dbEncryptionHandler = new DBEncryptionHandler(iCryptHandler, logger3, EncryptionLevel.Companion.fromInt(config.getEncryptionLevel()));
        String string4 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAccountId(...)");
        VariablesRepo variablesRepo = new VariablesRepo(context, string4, dbEncryptionHandler);
        String databaseName = DBAdapter.Companion.getDatabaseName(config);
        String string5 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAccountId(...)");
        Logger logger4 = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getLogger(...)");
        DBManager databaseManager2 = new DBManager(string5, logger4, databaseName, ctLockManager, ijRepo, dbEncryptionHandler, (Function0<Unit>)((Function0)new Function0<Unit>((Object)networkRepo){

            public final void invoke() {
                ((NetworkRepo)this.receiver).clearFirstRequestTs();
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)networkRepo){

            public final void invoke() {
                ((NetworkRepo)this.receiver).clearLastRequestTs();
            }
        }));
        Task<Unit> task = executors.postAsyncSafelyTask();
        task.execute("migratingEncryption", () -> CleverTapFactory.getCoreState$lambda$1(databaseManager2, context, config, cryptHandler, repository, variablesRepo));
        Task<Unit> inAppDaoLoaderTask = executors.postAsyncSafelyTask();
        inAppDaoLoaderTask.execute("loadInAppsDao", () -> CleverTapFactory.getCoreState$lambda$2(inAppDelayManager, databaseManager2, context, cryptHandler, config, accountId));
        DeviceInfo deviceInfo = new DeviceInfo(context, config, cleverTapID, coreMetaData);
        deviceInfo.onInitDeviceInfo(cleverTapID);
        ValidationConfig validationConfig = ValidationConfig.Companion.default((Function0<String>)((Function0)() -> CleverTapFactory.getCoreState$lambda$3(deviceInfo))).build();
        Logger logger5 = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"getLogger(...)");
        ValidationPipelineProvider validationPipelineProvider = new ValidationPipelineProvider(validationResultStack, logger5);
        Logger logger6 = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger6, (String)"getLogger(...)");
        ProfileStateTraverser profileStateTraverser = new ProfileStateTraverser(logger6);
        NestedJsonBuilder nestedJsonBuilder = new NestedJsonBuilder();
        LocalDataStore localDataStore = new LocalDataStore(context, config, cryptHandler, deviceInfo, databaseManager2, profileStateTraverser, nestedJsonBuilder);
        EventMediator eventMediator = new EventMediator(config, coreMetaData, networkRepo);
        CTPreferenceCache.Companion.getInstance(context, config);
        BaseCallbackManager callbackManager = new CallbackManager(config, deviceInfo);
        SessionManager sessionManager = new SessionManager(config, coreMetaData, validationConfig, localDataStore);
        ControllerManager controllerManager = new ControllerManager(context, config, ctLockManager, callbackManager, deviceInfo, databaseManager2);
        TriggersMatcher triggersMatcher = new TriggersMatcher(localDataStore);
        String string6 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getAccountId(...)");
        TriggerManager triggersManager = new TriggerManager(context, string6, deviceInfo);
        ImpressionManager impressionManager = new ImpressionManager(storeRegistry, null, null, 6, null);
        LimitsMatcher limitsMatcher = new LimitsMatcher(impressionManager, triggersManager);
        InAppActionHandler inAppActionHandler = new InAppActionHandler(context, config, new PushPermissionHandler(config, callbackManager.getPushPermissionResponseListenerList(), null, null, null, 28, null), null, 8, null);
        Set<CustomTemplate> systemTemplates = SystemTemplates.INSTANCE.getSystemTemplates(inAppActionHandler);
        TemplatesManager templatesManager = TemplatesManager.Companion.createInstance(config, systemTemplates);
        EvaluationManager evaluationManager = new EvaluationManager(triggersMatcher, triggersManager, limitsMatcher, storeRegistry, templatesManager);
        Task<Unit> taskInitStores = executors.ioTask();
        taskInitStores.execute("initStores", () -> CleverTapFactory.getCoreState$lambda$4(deviceInfo, storeRegistry, storeProvider, context, cryptHandler, config, evaluationManager, callbackManager));
        Task<Unit> taskInitFCManager = executors.ioTask();
        taskInitFCManager.execute("initFCManager", () -> CleverTapFactory.getCoreState$lambda$5(deviceInfo, controllerManager, config, context, storeRegistry, impressionManager, executors));
        Logger logger7 = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger7, (String)"getLogger(...)");
        FileResourcesRepoImpl impl = FileResourcesRepoFactory.Companion.createFileResourcesRepo(context, logger7, storeRegistry);
        VarCache varCache = new VarCache(config, context, impl, variablesRepo);
        CTVariables ctVariables = new CTVariables(varCache);
        controllerManager.setCtVariables(ctVariables);
        Parser parser = new Parser(ctVariables);
        Task<Unit> taskVariablesInit = executors.ioTask();
        taskVariablesInit.execute("initCTVariables", () -> CleverTapFactory.getCoreState$lambda$6(ctVariables));
        InAppResponse inAppResponse = new InAppResponse(config, controllerManager, false, storeRegistry, triggersManager, templatesManager, coreMetaData);
        CtApiWrapper ctApiWrapper = new CtApiWrapper(networkRepo, config, deviceInfo);
        NetworkEncryptionManager encryptionManager = new NetworkEncryptionManager(ctKeyGenerator, cryptFactory.getAesGcmCrypt());
        String string7 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getAccountId(...)");
        Logger logger8 = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger8, (String)"getLogger(...)");
        ArpRepo arpRepo = new ArpRepo(string7, logger8, deviceInfo);
        BaseDatabaseManager baseDatabaseManager = databaseManager2;
        Function0 function0 = (Function0)new Function0<Integer>((Object)networkRepo){

            public final Integer invoke() {
                return ((NetworkRepo)this.receiver).getFirstRequestTs();
            }
        };
        Function0 function02 = (Function0)new Function0<Integer>((Object)networkRepo){

            public final Integer invoke() {
                return ((NetworkRepo)this.receiver).getLastRequestTs();
            }
        };
        Logger logger9 = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger9, (String)"getLogger(...)");
        QueueHeaderBuilder queueHeaderBuilder2 = new QueueHeaderBuilder(context, config, coreMetaData, controllerManager, deviceInfo, arpRepo, ijRepo, baseDatabaseManager, validationResultStack, (Function0<Integer>)function0, (Function0<Integer>)function02, logger9);
        ARPResponse arpResponse = new ARPResponse(config, validationConfig, controllerManager, arpRepo);
        ContentFetchManager contentFetchManager = new ContentFetchManager(config, coreMetaData, queueHeaderBuilder2, ctApiWrapper, 0, null, null, 112, null);
        ContentFetchResponse contentFetchResponse = new ContentFetchResponse(config, contentFetchManager);
        Object[] objectArray = new CleverTapResponse[]{inAppResponse, new MetadataResponse(config, deviceInfo, ijRepo), arpResponse, new ConsoleResponse(config), new InboxResponse(config, ctLockManager, callbackManager, controllerManager), new PushAmpResponse(context, config, databaseManager2, callbackManager, controllerManager), new FetchVariablesResponse(config, controllerManager, callbackManager), new DisplayUnitResponse(config, callbackManager, controllerManager), new FeatureFlagResponse(config, controllerManager), new ProductConfigResponse(config, coreMetaData, controllerManager), new GeofenceResponse(config, callbackManager), contentFetchResponse};
        List cleverTapResponses = CollectionsKt.listOf((Object[])objectArray);
        ClevertapResponseHandler responseHandler = new ClevertapResponseHandler(context, cleverTapResponses);
        contentFetchManager.setClevertapResponseHandler(responseHandler);
        NetworkManager networkManager = new NetworkManager(context, config, deviceInfo, coreMetaData, controllerManager, databaseManager2, callbackManager, ctApiWrapper, encryptionManager, arpResponse, networkRepo, queueHeaderBuilder2, responseHandler, null, 8192, null);
        LoginInfoProvider loginInfoProvider = new LoginInfoProvider(context, config, cryptHandler);
        EventQueueManager baseEventQueueManager = new EventQueueManager(databaseManager2, context, config, eventMediator, sessionManager, callbackManager, mainLooperHandler, deviceInfo, validationResultStack, networkManager, coreMetaData, ctLockManager, localDataStore, controllerManager, loginInfoProvider);
        InAppResponse inAppResponseForSendTestInApp = new InAppResponse(config, controllerManager, true, storeRegistry, triggersManager, templatesManager, coreMetaData);
        Logger logger10 = config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger10, (String)"getLogger(...)");
        InAppPreviewHandler inAppPreviewHandler = new InAppPreviewHandler(executors, networkManager, inAppResponseForSendTestInApp, context, logger10);
        AnalyticsManager analyticsManager = new AnalyticsManager(context, config, baseEventQueueManager, validationPipelineProvider, validationConfig, coreMetaData, deviceInfo, callbackManager, controllerManager, ctLockManager, Clock.SYSTEM, executors, localDataStore, inAppPreviewHandler);
        InAppNotificationInflater inAppNotificationInflater = new InAppNotificationInflater(storeRegistry, templatesManager, executors, () -> CleverTapFactory.getCoreState$lambda$7(context, config), false, 16, null);
        networkManager.addNetworkHeadersListener(evaluationManager);
        ManifestInfo manifestInfo = ManifestInfo.getInstance(context);
        Intrinsics.checkNotNullExpressionValue((Object)manifestInfo, (String)"getInstance(...)");
        String string8 = config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getAccountId(...)");
        InAppController inAppController = new InAppController(context, config, executors, controllerManager, callbackManager, analyticsManager, coreMetaData, manifestInfo, deviceInfo, new StoreRegistryInAppQueue(storeRegistry, string8), evaluationManager, templatesManager, inAppActionHandler, inAppNotificationInflater, inAppDelayManager, inAppInActionManager, Clock.SYSTEM);
        controllerManager.setInAppController(inAppController);
        CompositeBatchListener batchListener = new CompositeBatchListener();
        AppLaunchListener appLaunchListener = new AppLaunchListener();
        appLaunchListener.addListener(inAppController.getOnAppLaunchEventSent());
        batchListener.addListener(appLaunchListener);
        batchListener.addListener(new FetchInAppListener(callbackManager));
        callbackManager.setBatchListener(batchListener);
        Task<Unit> taskInitFeatureFlags = executors.ioTask();
        taskInitFeatureFlags.execute("initFeatureFlags", () -> CleverTapFactory.getCoreState$lambda$8(context, controllerManager, config, deviceInfo, callbackManager, analyticsManager));
        LocationManager locationManager = new LocationManager(context, config, coreMetaData, baseEventQueueManager);
        CTWorkManager ctWorkManager = new CTWorkManager(context, config);
        PushProviders pushProviders = PushProviders.load(context, config, databaseManager2, validationResultStack, analyticsManager, controllerManager, ctWorkManager, Clock.SYSTEM);
        Intrinsics.checkNotNullExpressionValue((Object)pushProviders, (String)"load(...)");
        PushProviders pushProviders2 = pushProviders;
        ActivityLifeCycleManager activityLifeCycleManager = new ActivityLifeCycleManager(context, config, analyticsManager, coreMetaData, sessionManager, pushProviders2, callbackManager, inAppController, baseEventQueueManager, executors, Clock.SYSTEM);
        LoginController loginController = new LoginController(context, config, deviceInfo, validationResultStack, baseEventQueueManager, analyticsManager, coreMetaData, controllerManager, sessionManager, localDataStore, callbackManager, databaseManager2, ctLockManager, loginInfoProvider, contentFetchManager);
        return new CoreState(locationManager, config, coreMetaData, databaseManager2, deviceInfo, eventMediator, localDataStore, activityLifeCycleManager, analyticsManager, baseEventQueueManager, ctLockManager, callbackManager, controllerManager, inAppController, evaluationManager, impressionManager, loginController, sessionManager, validationResultStack, mainLooperHandler, networkManager, pushProviders2, varCache, parser, cryptHandler, storeRegistry, templatesManager, ctVariables, executors);
    }

    private final void initFeatureFlags(Context context, ControllerManager controllerManager, CleverTapInstanceConfig config, DeviceInfo deviceInfo, BaseCallbackManager callbackManager, AnalyticsManager analyticsManager) {
        config.getLogger().verbose(config.getAccountId() + ":async_deviceID", "Initializing Feature Flags with device Id = " + deviceInfo.getDeviceID());
        if (config.isAnalyticsOnly()) {
            config.getLogger().debug(config.getAccountId(), "Feature Flag is not enabled for this instance");
        } else {
            controllerManager.setCTFeatureFlagsController(CTFeatureFlagsFactory.getInstance(context, deviceInfo.getDeviceID(), config, callbackManager, analyticsManager));
            config.getLogger().verbose(config.getAccountId() + ":async_deviceID", "Feature Flags initialized");
        }
    }

    private static final Unit getCoreState$lambda$0(Context $context, CleverTapInstanceConfig $config) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        FileResourceProvider.Companion.getInstance($context, $config.getLogger());
        return Unit.INSTANCE;
    }

    private static final Unit getCoreState$lambda$1(DBManager $databaseManager, Context $context, CleverTapInstanceConfig $config, CryptHandler $cryptHandler, CryptRepository $repository, VariablesRepo $variablesRepo) {
        Intrinsics.checkNotNullParameter((Object)$databaseManager, (String)"$databaseManager");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$cryptHandler, (String)"$cryptHandler");
        Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
        Intrinsics.checkNotNullParameter((Object)$variablesRepo, (String)"$variablesRepo");
        DBAdapter dbAdapter = $databaseManager.loadDBAdapter($context);
        DataMigrationRepository dataMigrationRepository = new DataMigrationRepository($context, $config, dbAdapter);
        String string2 = $config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        int n = $config.getEncryptionLevel();
        Logger logger = $config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        CryptMigrator cryptMigrator = new CryptMigrator(string2, n, logger, $cryptHandler, $repository, dataMigrationRepository, $variablesRepo, dbAdapter);
        cryptMigrator.migrateEncryption();
        return Unit.INSTANCE;
    }

    private static final Unit getCoreState$lambda$2(InAppScheduler $inAppDelayManager, DBManager $databaseManager, Context $context, CryptHandler $cryptHandler, CleverTapInstanceConfig $config, String $accountId) {
        Intrinsics.checkNotNullParameter((Object)$inAppDelayManager, (String)"$inAppDelayManager");
        Intrinsics.checkNotNullParameter((Object)$databaseManager, (String)"$databaseManager");
        Intrinsics.checkNotNullParameter((Object)$cryptHandler, (String)"$cryptHandler");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        InAppSchedulingStrategy inAppSchedulingStrategy = $inAppDelayManager.getStorageStrategy$clevertap_core_release();
        Intrinsics.checkNotNull((Object)inAppSchedulingStrategy, (String)"null cannot be cast to non-null type com.clevertap.android.sdk.inapp.delay.DelayedInAppStorageStrategy");
        DelayedInAppStorageStrategy delayedInAppStorageStrategy = (DelayedInAppStorageStrategy)inAppSchedulingStrategy;
        DelayedLegacyInAppDAO delayedLegacyInAppDAO = $databaseManager.loadDBAdapter($context).delayedLegacyInAppDAO();
        Logger logger = $config.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ILogger iLogger = logger;
        Intrinsics.checkNotNull((Object)$accountId);
        delayedInAppStorageStrategy.setDelayedLegacyInAppStore$clevertap_core_release(new DelayedLegacyInAppStore(delayedLegacyInAppDAO, $cryptHandler, iLogger, $accountId));
        return Unit.INSTANCE;
    }

    private static final String getCoreState$lambda$3(DeviceInfo $deviceInfo) {
        Intrinsics.checkNotNullParameter((Object)$deviceInfo, (String)"$deviceInfo");
        return $deviceInfo.getCountryCode();
    }

    private static final Unit getCoreState$lambda$4(DeviceInfo $deviceInfo, StoreRegistry $storeRegistry, StoreProvider $storeProvider, Context $context, CryptHandler $cryptHandler, CleverTapInstanceConfig $config, EvaluationManager $evaluationManager, BaseCallbackManager $callbackManager) {
        Intrinsics.checkNotNullParameter((Object)$deviceInfo, (String)"$deviceInfo");
        Intrinsics.checkNotNullParameter((Object)$storeRegistry, (String)"$storeRegistry");
        Intrinsics.checkNotNullParameter((Object)$storeProvider, (String)"$storeProvider");
        Intrinsics.checkNotNullParameter((Object)$cryptHandler, (String)"$cryptHandler");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$evaluationManager, (String)"$evaluationManager");
        Intrinsics.checkNotNullParameter((Object)$callbackManager, (String)"$callbackManager");
        if ($deviceInfo.getDeviceID() != null) {
            if ($storeRegistry.getInAppStore() == null) {
                ICryptHandler iCryptHandler = $cryptHandler;
                String string2 = $deviceInfo.getDeviceID();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDeviceID(...)");
                String string3 = $config.getAccountId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAccountId(...)");
                InAppStore inAppStore = $storeProvider.provideInAppStore($context, iCryptHandler, string2, string3);
                $storeRegistry.setInAppStore(inAppStore);
                $evaluationManager.loadSuppressedCSAndEvaluatedSSInAppsIds();
                $callbackManager.addChangeUserCallback(inAppStore);
            }
            if ($storeRegistry.getImpressionStore() == null) {
                String string4 = $deviceInfo.getDeviceID();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getDeviceID(...)");
                String string5 = $config.getAccountId();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAccountId(...)");
                ImpressionStore impStore = $storeProvider.provideImpressionStore($context, string4, string5);
                $storeRegistry.setImpressionStore(impStore);
                $callbackManager.addChangeUserCallback(impStore);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit getCoreState$lambda$5(DeviceInfo $deviceInfo, ControllerManager $controllerManager, CleverTapInstanceConfig $config, Context $context, StoreRegistry $storeRegistry, ImpressionManager $impressionManager, CTExecutors $executors) {
        Intrinsics.checkNotNullParameter((Object)$deviceInfo, (String)"$deviceInfo");
        Intrinsics.checkNotNullParameter((Object)$controllerManager, (String)"$controllerManager");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$storeRegistry, (String)"$storeRegistry");
        Intrinsics.checkNotNullParameter((Object)$impressionManager, (String)"$impressionManager");
        Intrinsics.checkNotNullParameter((Object)$executors, (String)"$executors");
        String deviceId = $deviceInfo.getDeviceID();
        if (deviceId != null && $controllerManager.getInAppFCManager() == null) {
            $config.getLogger().verbose($config.getAccountId() + ":async_deviceID", "Initializing InAppFC with device Id = " + deviceId);
            $controllerManager.setInAppFCManager(new InAppFCManager($context, $config, deviceId, $storeRegistry, $impressionManager, $executors, Clock.SYSTEM));
        }
        return Unit.INSTANCE;
    }

    private static final Unit getCoreState$lambda$6(CTVariables $ctVariables) {
        Intrinsics.checkNotNullParameter((Object)$ctVariables, (String)"$ctVariables");
        $ctVariables.init();
        return Unit.INSTANCE;
    }

    private static final FileResourceProvider getCoreState$lambda$7(Context $context, CleverTapInstanceConfig $config) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        return FileResourceProvider.Companion.getInstance($context, $config.getLogger());
    }

    private static final Unit getCoreState$lambda$8(Context $context, ControllerManager $controllerManager, CleverTapInstanceConfig $config, DeviceInfo $deviceInfo, BaseCallbackManager $callbackManager, AnalyticsManager $analyticsManager) {
        Intrinsics.checkNotNullParameter((Object)$controllerManager, (String)"$controllerManager");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$deviceInfo, (String)"$deviceInfo");
        Intrinsics.checkNotNullParameter((Object)$callbackManager, (String)"$callbackManager");
        Intrinsics.checkNotNullParameter((Object)$analyticsManager, (String)"$analyticsManager");
        INSTANCE.initFeatureFlags($context, $controllerManager, $config, $deviceInfo, $callbackManager, $analyticsManager);
        return Unit.INSTANCE;
    }
}

