/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.cryption.CryptRepository;
import com.clevertap.android.sdk.cryption.DataMigrationRepository;
import com.clevertap.android.sdk.cryption.EncryptionLevel;
import com.clevertap.android.sdk.cryption.EncryptionState;
import com.clevertap.android.sdk.cryption.ICryptHandler;
import com.clevertap.android.sdk.cryption.MigrationResult;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.inbox.CTMessageDAO;
import com.clevertap.android.sdk.utils.JsonUtilsKt;
import com.clevertap.android.sdk.variables.repo.VariablesRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0080\b\u0018\u0000 >2\u00020\u0001:\u0001>BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0003H\u0002J \u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0018\u0010+\u001a\u00020%2\u0006\u0010*\u001a\u00020)2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0018\u0010,\u001a\u00020%2\u0006\u0010*\u001a\u00020)2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0018\u0010-\u001a\u00020%2\u0006\u0010*\u001a\u00020)2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0017H\u0002J\u0010\u00100\u001a\u00020)2\u0006\u0010&\u001a\u00020\u0003H\u0002J\t\u00101\u001a\u00020\u0003H\u00c2\u0003J\t\u00102\u001a\u00020\u0005H\u00c2\u0003J\t\u00103\u001a\u00020\u0007H\u00c2\u0003J\t\u00104\u001a\u00020\tH\u00c2\u0003J\t\u00105\u001a\u00020\u000bH\u00c2\u0003J\t\u00106\u001a\u00020\rH\u00c2\u0003J\t\u00107\u001a\u00020\u000fH\u00c2\u0003J\t\u00108\u001a\u00020\u0011H\u00c2\u0003JY\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010:\u001a\u00020\u00172\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020\u0005H\u00d6\u0001J\t\u0010=\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptMigrator;", "", "logPrefix", "", "configEncryptionLevel", "", "logger", "Lcom/clevertap/android/sdk/ILogger;", "cryptHandler", "Lcom/clevertap/android/sdk/cryption/ICryptHandler;", "cryptRepository", "Lcom/clevertap/android/sdk/cryption/CryptRepository;", "dataMigrationRepository", "Lcom/clevertap/android/sdk/cryption/DataMigrationRepository;", "variablesRepo", "Lcom/clevertap/android/sdk/variables/repo/VariablesRepo;", "dbAdapter", "Lcom/clevertap/android/sdk/db/DBAdapter;", "<init>", "(Ljava/lang/String;ILcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/cryption/ICryptHandler;Lcom/clevertap/android/sdk/cryption/CryptRepository;Lcom/clevertap/android/sdk/cryption/DataMigrationRepository;Lcom/clevertap/android/sdk/variables/repo/VariablesRepo;Lcom/clevertap/android/sdk/db/DBAdapter;)V", "migrateEncryption", "", "handleAllMigrations", "", "level", "Lcom/clevertap/android/sdk/cryption/EncryptionLevel;", "storedLevel", "firstUpgrade", "migrateVariablesData", "migrateInboxData", "migrateEventsData", "migrateCachedGuidsKeyPref", "convertCachedGuidsToPlainText", "Lorg/json/JSONObject;", "migrateDBProfile", "migrateInAppData", "performMigrationStep", "Lcom/clevertap/android/sdk/cryption/MigrationResult;", "data", "transitionEncryptionState", "currentState", "Lcom/clevertap/android/sdk/cryption/EncryptionState;", "targetState", "handleEncryptedAesTransition", "handleEncryptedAesGcmTransition", "handlePlainTextTransition", "getFinalEncryptionState", "encrypt", "getCurrentEncryptionState", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nCryptMigrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CryptMigrator.kt\ncom/clevertap/android/sdk/cryption/CryptMigrator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,437:1\n126#2:438\n153#2,3:439\n1863#3,2:442\n*S KotlinDebug\n*F\n+ 1 CryptMigrator.kt\ncom/clevertap/android/sdk/cryption/CryptMigrator\n*L\n131#1:438\n131#1:439,3\n240#1:442,2\n*E\n"})
public final class CryptMigrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String logPrefix;
    private final int configEncryptionLevel;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final ICryptHandler cryptHandler;
    @NotNull
    private final CryptRepository cryptRepository;
    @NotNull
    private final DataMigrationRepository dataMigrationRepository;
    @NotNull
    private final VariablesRepo variablesRepo;
    @NotNull
    private final DBAdapter dbAdapter;
    @NotNull
    public static final String MIGRATION_FAILURE_COUNT_KEY = "encryptionMigrationFailureCount";
    @NotNull
    public static final String SS_IN_APP_MIGRATED = "ssInAppMigrated";
    public static final int UNKNOWN_LEVEL = -1;
    public static final int MIGRATION_NOT_NEEDED = 0;
    public static final int MIGRATION_NEEDED = 1;
    public static final int MIGRATION_FIRST_UPGRADE = -1;

    public CryptMigrator(@NotNull String logPrefix, int configEncryptionLevel, @NotNull ILogger logger, @NotNull ICryptHandler cryptHandler, @NotNull CryptRepository cryptRepository, @NotNull DataMigrationRepository dataMigrationRepository, @NotNull VariablesRepo variablesRepo, @NotNull DBAdapter dbAdapter) {
        Intrinsics.checkNotNullParameter((Object)logPrefix, (String)"logPrefix");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)cryptHandler, (String)"cryptHandler");
        Intrinsics.checkNotNullParameter((Object)cryptRepository, (String)"cryptRepository");
        Intrinsics.checkNotNullParameter((Object)dataMigrationRepository, (String)"dataMigrationRepository");
        Intrinsics.checkNotNullParameter((Object)variablesRepo, (String)"variablesRepo");
        Intrinsics.checkNotNullParameter((Object)dbAdapter, (String)"dbAdapter");
        this.logPrefix = logPrefix;
        this.configEncryptionLevel = configEncryptionLevel;
        this.logger = logger;
        this.cryptHandler = cryptHandler;
        this.cryptRepository = cryptRepository;
        this.dataMigrationRepository = dataMigrationRepository;
        this.variablesRepo = variablesRepo;
        this.dbAdapter = dbAdapter;
    }

    public final void migrateEncryption() {
        int migrationFailureCount;
        int storedEncryptionLevel = this.cryptRepository.storedEncryptionLevel();
        int storedFailureCount = this.cryptRepository.migrationFailureCount();
        boolean isSSInAppDataMigrated = this.cryptRepository.isSSInAppDataMigrated();
        int n = !isSSInAppDataMigrated ? 1 : (migrationFailureCount = storedEncryptionLevel != this.configEncryptionLevel && storedFailureCount != -1 ? 1 : storedFailureCount);
        if (migrationFailureCount == 0) {
            this.logger.verbose(this.logPrefix, "Migration not required: config-encryption-level " + this.configEncryptionLevel + ", stored-encryption-level " + storedEncryptionLevel);
            return;
        }
        this.logger.verbose(this.logPrefix, "Starting migration from encryption level " + storedEncryptionLevel + " to " + this.configEncryptionLevel + " with migrationFailureCount " + migrationFailureCount + " and isSSInAppDataMigrated " + isSSInAppDataMigrated);
        EncryptionLevel level = EncryptionLevel.Companion.fromInt(this.configEncryptionLevel);
        EncryptionLevel storedLevel = EncryptionLevel.Companion.fromInt(storedEncryptionLevel);
        boolean migrationSuccess = this.handleAllMigrations(level, storedLevel, migrationFailureCount == -1);
        if (migrationSuccess) {
            this.cryptRepository.updateEncryptionLevel(this.configEncryptionLevel);
        }
        this.cryptRepository.updateIsSSInAppDataMigrated(migrationSuccess);
        this.cryptRepository.updateMigrationFailureCount(migrationSuccess);
    }

    private final boolean handleAllMigrations(EncryptionLevel level, EncryptionLevel storedLevel, boolean firstUpgrade) {
        boolean cgkMigrationSuccess = this.migrateCachedGuidsKeyPref(level, firstUpgrade);
        boolean dbMigrationSuccess = this.migrateDBProfile(level);
        boolean inAppMigrationSuccess = this.migrateInAppData(level);
        if (EncryptionLevel.FULL_DATA == storedLevel || EncryptionLevel.FULL_DATA == level) {
            this.migrateVariablesData();
            this.migrateInboxData();
            this.migrateEventsData();
        }
        return cgkMigrationSuccess && dbMigrationSuccess && inAppMigrationSuccess;
    }

    private final boolean migrateVariablesData() {
        String variablesData = this.variablesRepo.loadDataFromCache();
        if (variablesData != null) {
            this.variablesRepo.storeDataInCache(variablesData);
        } else {
            this.logger.verbose("Skipping variable migration as there is no data");
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean migrateInboxData() {
        void $this$mapTo$iv$iv;
        Map<String, JSONObject> $this$map$iv = this.dataMigrationRepository.userProfilesInAccount();
        boolean $i$f$map = false;
        Map<String, JSONObject> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        for (String id : (List)destination$iv$iv) {
            ArrayList<CTMessageDAO> messages = this.dbAdapter.getMessages(id);
            this.dbAdapter.upsertMessages((List<? extends CTMessageDAO>)messages);
        }
        return true;
    }

    private final void migrateEventsData() {
        DBAdapter $this$migrateEventsData_u24lambda_u241 = this.dbAdapter;
        boolean bl = false;
        $this$migrateEventsData_u24lambda_u241.migrateEventsData(Table.EVENTS);
        $this$migrateEventsData_u24lambda_u241.migrateEventsData(Table.PROFILE_EVENTS);
    }

    private final boolean migrateCachedGuidsKeyPref(EncryptionLevel level, boolean firstUpgrade) {
        String string2;
        this.logger.verbose(this.logPrefix, "Migrating encryption level for cachedGUIDsKey prefs");
        if (firstUpgrade) {
            JSONObject cgkJson = this.convertCachedGuidsToPlainText();
            int cgkLength = cgkJson.length();
            this.dataMigrationRepository.saveCachedGuidJsonLength(cgkLength);
            if (cgkLength == 0) {
                this.dataMigrationRepository.removeCachedGuidJson();
                return true;
            }
            String string3 = cgkJson.toString();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        } else {
            string2 = this.dataMigrationRepository.cachedGuidString();
            if (string2 == null) {
                return true;
            }
        }
        String cgkString = string2;
        MigrationResult migrationResult = this.performMigrationStep(level, cgkString);
        this.dataMigrationRepository.saveCachedGuidJson(migrationResult.getData());
        this.logger.verbose(this.logPrefix, "Cached GUIDs migrated with success = " + migrationResult + ".migrationSuccessful = " + migrationResult.getData());
        return migrationResult.getMigrationSuccessful();
    }

    private final JSONObject convertCachedGuidsToPlainText() {
        JSONObject cachedGuidJsonObj = this.dataMigrationRepository.cachedGuidJsonObject();
        JSONObject migratedGuidJsonObj = new JSONObject();
        try {
            Iterator keysIterator = cachedGuidJsonObj.keys();
            while (keysIterator.hasNext()) {
                String nextKey = (String)keysIterator.next();
                Intrinsics.checkNotNull((Object)nextKey);
                String[] stringArray = new String[]{"_"};
                List list = StringsKt.split$default((CharSequence)nextKey, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                String key = (String)list.get(0);
                String identifier = (String)list.get(1);
                MigrationResult migrationResult = this.performMigrationStep(EncryptionLevel.NONE, identifier);
                if (!migrationResult.getMigrationSuccessful()) continue;
                String cryptedKey = key + '_' + migrationResult.getData();
                migratedGuidJsonObj.put(cryptedKey, cachedGuidJsonObj.get(nextKey));
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.logPrefix, "Error migrating format for cached GUIDs: Clearing and starting fresh " + t);
        }
        return migratedGuidJsonObj;
    }

    private final boolean migrateDBProfile(EncryptionLevel level) {
        this.logger.verbose(this.logPrefix, "Migrating encryption level for user profiles in DB");
        Map<String, JSONObject> profiles = this.dataMigrationRepository.userProfilesInAccount();
        boolean migrationSuccessful = false;
        migrationSuccessful = true;
        for (Map.Entry<String, JSONObject> entry : profiles.entrySet()) {
            String deviceID = entry.getKey();
            JSONObject profile = entry.getValue();
            try {
                HashSet<String> hashSet = Constants.piiDBKeys;
                Intrinsics.checkNotNullExpressionValue(hashSet, (String)"piiDBKeys");
                Iterable $this$forEach$iv = hashSet;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String value;
                    String piiKey = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)piiKey);
                    if (JsonUtilsKt.getStringOrNull(profile, piiKey) == null) continue;
                    boolean bl2 = false;
                    EncryptionLevel moveTo = EncryptionLevel.FULL_DATA == level ? EncryptionLevel.NONE : level;
                    MigrationResult migrationResult = this.performMigrationStep(moveTo, value);
                    migrationSuccessful = migrationSuccessful && migrationResult.getMigrationSuccessful();
                    profile.put(piiKey, (Object)migrationResult.getData());
                }
                this.logger.verbose(this.logPrefix, "DB migrated with success = " + migrationSuccessful + " = " + profile);
                if (this.dataMigrationRepository.saveUserProfile(deviceID, profile) > -1L) continue;
                migrationSuccessful = false;
            }
            catch (Exception e) {
                this.logger.verbose(this.logPrefix, "Error migrating profile " + deviceID + ": " + e);
                migrationSuccessful = false;
            }
        }
        return migrationSuccessful;
    }

    private final boolean migrateInAppData(EncryptionLevel level) {
        this.logger.verbose(this.logPrefix, "Migrating encryption for InAppData");
        Ref.BooleanRef migrationSuccessful = new Ref.BooleanRef();
        migrationSuccessful.element = true;
        Function1 migrateCode = arg_0 -> CryptMigrator.migrateInAppData$lambda$4(this, level, migrationSuccessful, arg_0);
        Object[] objectArray = new String[]{"inapp_notifs_cs", "inApp"};
        List keysToProcess = CollectionsKt.listOf((Object[])objectArray);
        this.dataMigrationRepository.inAppDataFiles(keysToProcess, (Function1<? super String, String>)migrateCode);
        return migrationSuccessful.element;
    }

    private final MigrationResult performMigrationStep(EncryptionLevel level, String data) {
        EncryptionState currentState = this.getCurrentEncryptionState(data);
        EncryptionState targetState = this.getFinalEncryptionState(level.shouldEncrypt());
        return this.transitionEncryptionState(currentState, targetState, data);
    }

    private final MigrationResult transitionEncryptionState(EncryptionState currentState, EncryptionState targetState, String data) {
        MigrationResult migrationResult;
        if (currentState == targetState) {
            return new MigrationResult(data, true);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[currentState.ordinal()]) {
            case 1: {
                migrationResult = this.handleEncryptedAesTransition(targetState, data);
                break;
            }
            case 2: {
                migrationResult = this.handleEncryptedAesGcmTransition(targetState, data);
                break;
            }
            case 3: {
                migrationResult = this.handlePlainTextTransition(targetState, data);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return migrationResult;
    }

    private final MigrationResult handleEncryptedAesTransition(EncryptionState targetState, String data) {
        MigrationResult migrationResult;
        String decrypted = this.cryptHandler.decryptWithAlgorithm(data, CryptHandler.EncryptionAlgorithm.AES);
        switch (WhenMappings.$EnumSwitchMapping$0[targetState.ordinal()]) {
            case 2: {
                String encrypted;
                String string2;
                String string3;
                String string4 = decrypted;
                if (string4 != null) {
                    String it = string4;
                    boolean bl = false;
                    string3 = this.cryptHandler.encrypt(it);
                } else {
                    string3 = null;
                }
                if ((string2 = (encrypted = string3)) == null) {
                    string2 = decrypted;
                }
                migrationResult = new MigrationResult(string2, encrypted != null || decrypted == null);
                break;
            }
            case 3: {
                String string5 = decrypted;
                if (string5 == null) {
                    string5 = data;
                }
                migrationResult = new MigrationResult(string5, decrypted != null);
                break;
            }
            default: {
                this.logger.verbose(this.logPrefix, "Invalid transition from ENCRYPTED_AES to " + (Object)((Object)targetState));
                migrationResult = MigrationResult.Companion.failure(data);
            }
        }
        return migrationResult;
    }

    private final MigrationResult handleEncryptedAesGcmTransition(EncryptionState targetState, String data) {
        MigrationResult migrationResult;
        String decrypted = this.cryptHandler.decrypt(data);
        if (WhenMappings.$EnumSwitchMapping$0[targetState.ordinal()] == 3) {
            String string2 = decrypted;
            if (string2 == null) {
                string2 = data;
            }
            migrationResult = new MigrationResult(string2, decrypted != null);
        } else {
            this.logger.verbose(this.logPrefix, "Invalid transition from ENCRYPTED_AES_GCM to " + (Object)((Object)targetState));
            migrationResult = MigrationResult.Companion.failure(data);
        }
        return migrationResult;
    }

    private final MigrationResult handlePlainTextTransition(EncryptionState targetState, String data) {
        MigrationResult migrationResult;
        if (WhenMappings.$EnumSwitchMapping$0[targetState.ordinal()] == 2) {
            String encrypted = this.cryptHandler.encrypt(data);
            String string2 = encrypted;
            if (string2 == null) {
                string2 = data;
            }
            migrationResult = new MigrationResult(string2, encrypted != null);
        } else {
            this.logger.verbose(this.logPrefix, "Invalid transition from PLAIN_TEXT to " + (Object)((Object)targetState));
            migrationResult = MigrationResult.Companion.failure(data);
        }
        return migrationResult;
    }

    private final EncryptionState getFinalEncryptionState(boolean encrypt) {
        return encrypt ? EncryptionState.ENCRYPTED_AES_GCM : EncryptionState.PLAIN_TEXT;
    }

    private final EncryptionState getCurrentEncryptionState(String data) {
        return CryptHandler.Companion.isTextAESEncrypted(data) ? EncryptionState.ENCRYPTED_AES : (CryptHandler.Companion.isTextAESGCMEncrypted(data) ? EncryptionState.ENCRYPTED_AES_GCM : EncryptionState.PLAIN_TEXT);
    }

    private final String component1() {
        return this.logPrefix;
    }

    private final int component2() {
        return this.configEncryptionLevel;
    }

    private final ILogger component3() {
        return this.logger;
    }

    private final ICryptHandler component4() {
        return this.cryptHandler;
    }

    private final CryptRepository component5() {
        return this.cryptRepository;
    }

    private final DataMigrationRepository component6() {
        return this.dataMigrationRepository;
    }

    private final VariablesRepo component7() {
        return this.variablesRepo;
    }

    private final DBAdapter component8() {
        return this.dbAdapter;
    }

    @NotNull
    public final CryptMigrator copy(@NotNull String logPrefix, int configEncryptionLevel, @NotNull ILogger logger, @NotNull ICryptHandler cryptHandler, @NotNull CryptRepository cryptRepository, @NotNull DataMigrationRepository dataMigrationRepository, @NotNull VariablesRepo variablesRepo, @NotNull DBAdapter dbAdapter) {
        Intrinsics.checkNotNullParameter((Object)logPrefix, (String)"logPrefix");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)cryptHandler, (String)"cryptHandler");
        Intrinsics.checkNotNullParameter((Object)cryptRepository, (String)"cryptRepository");
        Intrinsics.checkNotNullParameter((Object)dataMigrationRepository, (String)"dataMigrationRepository");
        Intrinsics.checkNotNullParameter((Object)variablesRepo, (String)"variablesRepo");
        Intrinsics.checkNotNullParameter((Object)dbAdapter, (String)"dbAdapter");
        return new CryptMigrator(logPrefix, configEncryptionLevel, logger, cryptHandler, cryptRepository, dataMigrationRepository, variablesRepo, dbAdapter);
    }

    public static /* synthetic */ CryptMigrator copy$default(CryptMigrator cryptMigrator, String string2, int n, ILogger iLogger, ICryptHandler iCryptHandler, CryptRepository cryptRepository, DataMigrationRepository dataMigrationRepository, VariablesRepo variablesRepo, DBAdapter dBAdapter, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = cryptMigrator.logPrefix;
        }
        if ((n2 & 2) != 0) {
            n = cryptMigrator.configEncryptionLevel;
        }
        if ((n2 & 4) != 0) {
            iLogger = cryptMigrator.logger;
        }
        if ((n2 & 8) != 0) {
            iCryptHandler = cryptMigrator.cryptHandler;
        }
        if ((n2 & 0x10) != 0) {
            cryptRepository = cryptMigrator.cryptRepository;
        }
        if ((n2 & 0x20) != 0) {
            dataMigrationRepository = cryptMigrator.dataMigrationRepository;
        }
        if ((n2 & 0x40) != 0) {
            variablesRepo = cryptMigrator.variablesRepo;
        }
        if ((n2 & 0x80) != 0) {
            dBAdapter = cryptMigrator.dbAdapter;
        }
        return cryptMigrator.copy(string2, n, iLogger, iCryptHandler, cryptRepository, dataMigrationRepository, variablesRepo, dBAdapter);
    }

    @NotNull
    public String toString() {
        return "CryptMigrator(logPrefix=" + this.logPrefix + ", configEncryptionLevel=" + this.configEncryptionLevel + ", logger=" + this.logger + ", cryptHandler=" + this.cryptHandler + ", cryptRepository=" + this.cryptRepository + ", dataMigrationRepository=" + this.dataMigrationRepository + ", variablesRepo=" + this.variablesRepo + ", dbAdapter=" + this.dbAdapter + ')';
    }

    public int hashCode() {
        int result = this.logPrefix.hashCode();
        result = result * 31 + Integer.hashCode(this.configEncryptionLevel);
        result = result * 31 + this.logger.hashCode();
        result = result * 31 + this.cryptHandler.hashCode();
        result = result * 31 + this.cryptRepository.hashCode();
        result = result * 31 + this.dataMigrationRepository.hashCode();
        result = result * 31 + this.variablesRepo.hashCode();
        result = result * 31 + this.dbAdapter.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CryptMigrator)) {
            return false;
        }
        CryptMigrator cryptMigrator = (CryptMigrator)other;
        if (!Intrinsics.areEqual((Object)this.logPrefix, (Object)cryptMigrator.logPrefix)) {
            return false;
        }
        if (this.configEncryptionLevel != cryptMigrator.configEncryptionLevel) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.logger, (Object)cryptMigrator.logger)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cryptHandler, (Object)cryptMigrator.cryptHandler)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cryptRepository, (Object)cryptMigrator.cryptRepository)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dataMigrationRepository, (Object)cryptMigrator.dataMigrationRepository)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variablesRepo, (Object)cryptMigrator.variablesRepo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.dbAdapter, (Object)cryptMigrator.dbAdapter);
    }

    private static final String migrateInAppData$lambda$4(CryptMigrator this$0, EncryptionLevel $level, Ref.BooleanRef $migrationSuccessful, String spData) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$level), (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$migrationSuccessful, (String)"$migrationSuccessful");
        Intrinsics.checkNotNullParameter((Object)spData, (String)"spData");
        MigrationResult result = this$0.performMigrationStep($level, spData);
        $migrationSuccessful.element = $migrationSuccessful.element && result.getMigrationSuccessful();
        return result.getData();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptMigrator$Companion;", "", "<init>", "()V", "MIGRATION_FAILURE_COUNT_KEY", "", "SS_IN_APP_MIGRATED", "UNKNOWN_LEVEL", "", "MIGRATION_NOT_NEEDED", "MIGRATION_NEEDED", "MIGRATION_FIRST_UPGRADE", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptionState.values().length];
            try {
                nArray[EncryptionState.ENCRYPTED_AES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionState.ENCRYPTED_AES_GCM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionState.PLAIN_TEXT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

