/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.fragment;

import android.app.Activity;
import android.content.Context;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inapp.InAppDisplayListener;
import com.clevertap.android.sdk.inapp.fragment.CTInAppBaseFragment;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0014J\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/clevertap/android/sdk/inapp/fragment/CTInAppBasePartialFragment;", "Lcom/clevertap/android/sdk/inapp/fragment/CTInAppBaseFragment;", "Lcom/clevertap/android/sdk/inapp/InAppDisplayListener;", "<init>", "()V", "isCleanedUp", "Ljava/util/concurrent/atomic/AtomicBoolean;", "onStart", "", "onStop", "cleanup", "generateListener", "registerInAppDisplayListener", "unregisterInAppDisplayListener", "hideInApp", "clevertap-core_release"})
public abstract class CTInAppBasePartialFragment
extends CTInAppBaseFragment
implements InAppDisplayListener {
    @NotNull
    private final AtomicBoolean isCleanedUp = new AtomicBoolean();

    public void onStart() {
        super.onStart();
        if (this.isCleanedUp.get()) {
            this.cleanup();
        }
        this.registerInAppDisplayListener();
    }

    public void onStop() {
        super.onStop();
        this.unregisterInAppDisplayListener();
    }

    @Override
    protected void cleanup() {
        FragmentActivity activity = this.getActivity();
        if (activity != null && !Utils.isActivityDead((Activity)activity) && this.isCleanedUp.compareAndSet(false, true)) {
            FragmentManager fragmentManager = activity.getSupportFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getSupportFragmentManager(...)");
            FragmentManager fragmentManager2 = fragmentManager;
            FragmentTransaction fragmentTransaction = fragmentManager2.beginTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"beginTransaction(...)");
            FragmentTransaction transaction = fragmentTransaction;
            try {
                int n = transaction.remove((Fragment)this).commit();
            }
            catch (IllegalStateException illegalStateException) {
                int n = fragmentManager2.beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
            }
        }
    }

    @Override
    protected void generateListener() {
        this.setListener(CleverTapAPI.instanceWithConfig(this.requireContext(), this.getConfig()).getCoreState().getInAppController());
    }

    private final void registerInAppDisplayListener() {
        block0: {
            Context context = this.getContext();
            if (context == null) break block0;
            Context it = context;
            boolean bl = false;
            CleverTapAPI.instanceWithConfig(it, this.getConfig()).getCoreState().getInAppController().registerInAppDisplayListener(this);
        }
    }

    private final void unregisterInAppDisplayListener() {
        block0: {
            Context context = this.getContext();
            if (context == null) break block0;
            Context it = context;
            boolean bl = false;
            CleverTapAPI.instanceWithConfig(it, this.getConfig()).getCoreState().getInAppController().unregisterInAppDisplayListener();
        }
    }

    @Override
    public void hideInApp() {
        this.didDismiss(null);
    }
}

